/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.histogram.HistogramDataCreater;
import cgdp.recog.histogram.HistogramType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComboBox;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class HistogramDialog
extends AbstractApplyDialog
implements ItemListener {
    private static HistogramDialog HISTOGRAM_DIALOG;
    private static final String TITLE = "Histogram";
    private static final DecimalFormat NUMERIC_FORMAT;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JRadioButton descriptionButton;
    private JRadioButton funcNameButton;
    private JRadioButton valueButton;
    private JRadioButton diffButton;
    private OrganismSelectPanel valueOrganismSelectPanel;
    private InfoTitleComboBox valueGeneInfoTitleComboBox;
    private OrganismComboBox primaryOrganismComboBox;
    private OrganismComboBox secondaryOrganismComboBox;
    private InfoTitleComboBox diffGeneInfoTitleComboBox;
    private JCheckBox showLabelCheckBox;
    private RestrictTextField minTextField;
    private RestrictTextField maxTextField;
    private JButton autoRangeButton;
    private JRadioButton barButton;
    private JRadioButton lineButton;

    private HistogramDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        HISTOGRAM_DIALOG = new HistogramDialog(frame, mediatorImpl);
    }

    public static HistogramDialog getInstance() {
        return HISTOGRAM_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        JPanel jPanel = this.createTargetPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Target"));
        JPanel jPanel2 = this.createViewPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("View"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 15, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createTargetPanel() {
        this.descriptionButton = new JRadioButton("Description/Function Category");
        this.descriptionButton.addActionListener(this);
        this.funcNameButton = new JRadioButton("Function Category Name");
        this.funcNameButton.addActionListener(this);
        this.valueButton = new JRadioButton("Value");
        this.valueButton.addActionListener(this);
        this.diffButton = new JRadioButton("Difference");
        this.diffButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.descriptionButton);
        buttonGroup.add(this.funcNameButton);
        buttonGroup.add(this.valueButton);
        buttonGroup.add(this.diffButton);
        JPanel jPanel = this.createValuePanel();
        JPanel jPanel2 = this.createDiffPanel();
        this.descriptionButton.setSelected(true);
        this.setEnableValueComponents(false);
        this.setEnableDiffComponents(false);
        JSeparator jSeparator = new JSeparator();
        JSeparator jSeparator2 = new JSeparator();
        JSeparator jSeparator3 = new JSeparator();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this.descriptionButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 15), 0, 0));
        jPanel3.add((Component)jSeparator, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 10), 0, 0));
        jPanel3.add((Component)this.funcNameButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 15), 0, 0));
        jPanel3.add((Component)jSeparator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 10), 0, 0));
        jPanel3.add((Component)this.valueButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 10), 0, 0));
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 35, 10, 15), 0, 0));
        jPanel3.add((Component)jSeparator3, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 10), 0, 0));
        jPanel3.add((Component)this.diffButton, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 0, 10), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 35, 5, 15), 0, 0));
        return jPanel3;
    }

    private JPanel createValuePanel() {
        this.valueOrganismSelectPanel = new OrganismSelectPanel(false, false, false);
        this.valueGeneInfoTitleComboBox = new InfoTitleComboBox();
        this.valueGeneInfoTitleComboBox.addItemListener(this);
        JLabel jLabel = new JLabel("Organism");
        JLabel jLabel2 = new JLabel("Property");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.valueGeneInfoTitleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 10, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.valueOrganismSelectPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createDiffPanel() {
        this.primaryOrganismComboBox = new OrganismComboBox();
        this.primaryOrganismComboBox.addItemListener(this);
        this.secondaryOrganismComboBox = new OrganismComboBox();
        this.secondaryOrganismComboBox.addItemListener(this);
        this.diffGeneInfoTitleComboBox = new InfoTitleComboBox();
        JLabel jLabel = new JLabel("Organism 1");
        JLabel jLabel2 = new JLabel("Organism 2");
        JLabel jLabel3 = new JLabel("Property");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.primaryOrganismComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.secondaryOrganismComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.diffGeneInfoTitleComboBox, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 10, 0), 0, 0));
        return jPanel;
    }

    private JPanel createViewPanel() {
        JLabel jLabel = new JLabel("Range");
        JLabel jLabel2 = new JLabel("Min");
        this.minTextField = new RestrictTextField(10);
        this.minTextField.setDecimal(true);
        this.minTextField.setNegative(true);
        JLabel jLabel3 = new JLabel("Max");
        this.maxTextField = new RestrictTextField(10);
        this.maxTextField.setDecimal(true);
        this.maxTextField.setNegative(true);
        this.autoRangeButton = new JButton("Auto range");
        this.autoRangeButton.addActionListener(this);
        JLabel jLabel4 = new JLabel("Graph Style");
        this.barButton = new JRadioButton("Bar");
        this.lineButton = new JRadioButton("Line");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.barButton);
        buttonGroup.add(this.lineButton);
        this.barButton.setSelected(true);
        this.showLabelCheckBox = new JCheckBox("Show value");
        this.showLabelCheckBox.setSelected(true);
        this.setEnableViewComponents(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 15, 5, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 25, 5, 0), 0, 0));
        jPanel.add((Component)this.minTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 15), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 25, 5, 0), 0, 0));
        jPanel.add((Component)this.maxTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 15), 0, 0));
        jPanel.add((Component)this.autoRangeButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 5, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(20, 15, 5, 0), 0, 0));
        jPanel.add((Component)this.barButton, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 25, 5, 0), 0, 0));
        jPanel.add((Component)this.lineButton, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 25, 5, 0), 0, 0));
        jPanel.add((Component)this.showLabelCheckBox, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 2, new Insets(10, 15, 5, 15), 0, 0));
        return jPanel;
    }

    public void updateValue(String string, List list, ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        if (StringTool.isNull(string)) {
            string = ((Organism)list.get(0)).getOrganismCode();
        }
        List list2 = OrganismUtil.getOrganismCodeList(list);
        this.updateValueForValue(string, list2, list);
        this.updateValueForDiff(string, list2, list);
        this.pack();
    }

    public void updateValue(HistogramCondition histogramCondition, List list, ClusterTbl clusterTbl) {
        if (histogramCondition == null) {
            String string = ((Organism)list.get(0)).getOrganismCode();
            this.updateValue(string, list, clusterTbl);
            return;
        }
        this.clusterTbl = clusterTbl;
        List list2 = OrganismUtil.getOrganismCodeList(list);
        this.setHistogramType(histogramCondition.getHistogramType());
        this.updateValueForValue(histogramCondition, list2, list);
        this.updateValueForDiff(histogramCondition, list2, list);
        this.updateRange(histogramCondition);
        this.updateGraphType(histogramCondition);
        this.pack();
    }

    private void setHistogramType(int n) {
        if (HistogramType.isValue(n)) {
            this.valueButton.setSelected(true);
        } else if (HistogramType.isDiff(n)) {
            this.diffButton.setSelected(true);
        } else if (HistogramType.isFuncName(n)) {
            this.funcNameButton.setSelected(true);
        } else {
            this.descriptionButton.setSelected(true);
        }
    }

    private void updateValueForValue(String string, List list, List list2) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        Organism organism = OrganismUtil.getOrganism(list2, string);
        arrayList.add(organism);
        this.valueOrganismSelectPanel.updateValue(list2, arrayList);
        this.updateGeneInfoTitleForValue(list);
    }

    private void updateValueForValue(HistogramCondition histogramCondition, List list, List list2) {
        List list3 = OrganismUtil.getOrganismList(list2, histogramCondition.getValueOrganismCodeList());
        this.valueOrganismSelectPanel.updateValue(list2, list3);
        this.updateGeneInfoTitleForValue(list);
        this.valueGeneInfoTitleComboBox.setSelectedItem(histogramCondition.getValueGeneInfoTitle().getName());
    }

    private void updateGeneInfoTitleForValue(Collection collection) {
        List list = this.getGeneInfoTitleList(collection);
        list.addAll(this.getClusterInfoTitleList());
        list.addAll(this.getCellInfoTitleList());
        this.valueGeneInfoTitleComboBox.updateInfoTitleItems(list);
    }

    private void updateValueForDiff(String string, List list, List list2) {
        if (list.size() <= 1) {
            this.diffButton.setEnabled(false);
            if (this.diffButton.isSelected()) {
                this.descriptionButton.setSelected(true);
            }
            this.setEnableDiffComponents(false);
            return;
        }
        String string2 = null;
        List list3 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && ((string2 = (String)iterator.next()).equals(string) || CollectionUtil.isNull(list3 = this.getGeneInfoTitleListForDiff(string, string2)))) {
        }
        if (StringTool.isNull(string2)) {
            this.diffButton.setEnabled(false);
            if (this.diffButton.isSelected()) {
                this.descriptionButton.setSelected(true);
            }
            this.setEnableDiffComponents(false);
            return;
        }
        this.diffButton.setEnabled(true);
        if (this.diffButton.isSelected()) {
            this.setEnableDiffComponents(true);
        }
        this.primaryOrganismComboBox.removeItemListener(this);
        this.primaryOrganismComboBox.updateValueByOrganism(list2);
        this.primaryOrganismComboBox.setSelectedOrganismCode(string);
        this.primaryOrganismComboBox.addItemListener(this);
        this.secondaryOrganismComboBox.removeItemListener(this);
        this.secondaryOrganismComboBox.updateValueByOrganism(list2);
        this.secondaryOrganismComboBox.setSelectedOrganismCode(string2);
        this.secondaryOrganismComboBox.addItemListener(this);
        this.diffGeneInfoTitleComboBox.updateInfoTitleItems(list3);
    }

    private void updateValueForDiff(HistogramCondition histogramCondition, List list, List list2) {
        if (list.size() <= 1) {
            this.diffButton.setEnabled(false);
            if (this.diffButton.isSelected()) {
                this.descriptionButton.setSelected(true);
            }
            this.setEnableDiffComponents(false);
            return;
        }
        String string = histogramCondition.getPrimaryOrganismCode();
        String string2 = histogramCondition.getSecondaryOrganismCode();
        List list3 = this.getGeneInfoTitleListForDiff(string, string2);
        if (StringTool.isNull(string2)) {
            this.diffButton.setEnabled(false);
            if (this.diffButton.isSelected()) {
                this.descriptionButton.setSelected(true);
            }
            this.setEnableDiffComponents(false);
            return;
        }
        this.diffButton.setEnabled(true);
        if (this.diffButton.isSelected()) {
            this.setEnableDiffComponents(true);
        }
        this.primaryOrganismComboBox.removeItemListener(this);
        this.primaryOrganismComboBox.updateValueByOrganism(list2);
        this.primaryOrganismComboBox.setSelectedOrganismCode(string);
        this.primaryOrganismComboBox.addItemListener(this);
        this.secondaryOrganismComboBox.removeItemListener(this);
        this.secondaryOrganismComboBox.updateValueByOrganism(list2);
        this.secondaryOrganismComboBox.setSelectedOrganismCode(string2);
        this.secondaryOrganismComboBox.addItemListener(this);
        this.diffGeneInfoTitleComboBox.updateInfoTitleItems(list3);
        this.diffGeneInfoTitleComboBox.setSelectedItem(histogramCondition.getDiffGeneInfoTitle().getName());
    }

    private void updateGeneInfoTitleForDiff() {
        Organism organism = this.primaryOrganismComboBox.getSelectedOrganism();
        String string = organism.getOrganismCode();
        Organism organism2 = this.secondaryOrganismComboBox.getSelectedOrganism();
        String string2 = organism2.getOrganismCode();
        List list = this.getGeneInfoTitleListForDiff(string, string2);
        this.diffGeneInfoTitleComboBox.updateInfoTitleItems(list);
    }

    private void updateRange(HistogramCondition histogramCondition) {
        this.minTextField.setText(NUMERIC_FORMAT.format(histogramCondition.getMinValue()));
        this.maxTextField.setText(NUMERIC_FORMAT.format(histogramCondition.getMaxValue()));
    }

    private void updateGraphType(HistogramCondition histogramCondition) {
        this.barButton.setSelected(histogramCondition.isBar());
        this.lineButton.setSelected(histogramCondition.isLine());
    }

    private void setEnableValueComponents(boolean bl) {
        this.valueGeneInfoTitleComboBox.setEnabled(bl);
        this.valueOrganismSelectPanel.setEnableComponents(bl);
    }

    private void setEnableValueOrganismSelectPanel(boolean bl) {
        this.valueOrganismSelectPanel.setEnableComponents(bl);
    }

    private void setEnableDiffComponents(boolean bl) {
        this.primaryOrganismComboBox.setEnabled(bl);
        this.secondaryOrganismComboBox.setEnabled(bl);
        this.diffGeneInfoTitleComboBox.setEnabled(bl);
    }

    private void setEnableViewComponents(boolean bl) {
        this.minTextField.setEnabled(bl);
        this.maxTextField.setEnabled(bl);
        this.autoRangeButton.setEnabled(bl);
        this.barButton.setEnabled(bl);
        this.lineButton.setEnabled(bl);
    }

    private List getGeneInfoTitleList(Collection collection) {
        List list = GeneInfoFacade.getGeneInfoTitleList(collection);
        list = InfoUtil.filterByType(list, 1);
        return list;
    }

    private List getClusterInfoTitleList() {
        return ClusterInfoFacade.createSelectableTitleListForHistogram(this.clusterTbl);
    }

    private List getCellInfoTitleList() {
        return CellInfoFacade.getInfoTitleListByAnalysisKey("UseHist", this.clusterTbl);
    }

    private List getGeneInfoTitleListForDiff(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashSet.add(string2);
        List list = GeneInfoFacade.getCommonGeneInfoTitleList(hashSet);
        list.addAll(CellInfoFacade.getInfoTitleList());
        list = InfoUtil.filterByType(list, 1);
        return list;
    }

    private int getHistogramType() {
        int n = -1;
        if (this.descriptionButton.isSelected()) {
            n = 1;
        } else if (this.valueButton.isSelected()) {
            n = 2;
        } else if (this.diffButton.isSelected()) {
            n = 3;
        } else if (this.funcNameButton.isSelected()) {
            n = 5;
        }
        return n;
    }

    private List getValueOrganismCodeList() {
        return this.valueOrganismSelectPanel.getTargetOrganismCodeList();
    }

    private AbstractInfoTitle getValueGeneInfoTitle() {
        return this.valueGeneInfoTitleComboBox.getSelectedInfoTitle();
    }

    private String getPrimaryOrganismCode() {
        return this.primaryOrganismComboBox.getSelectedOrganismCode();
    }

    private String getSecondaryOrganismCode() {
        return this.secondaryOrganismComboBox.getSelectedOrganismCode();
    }

    private AbstractInfoTitle getDiffGeneInfoTitle() {
        return this.diffGeneInfoTitleComboBox.getSelectedInfoTitle();
    }

    private boolean isShowDataLabel() {
        return this.showLabelCheckBox.isSelected();
    }

    private double getMinValue() {
        return Double.parseDouble(this.minTextField.getText());
    }

    private double getMaxValue() {
        return Double.parseDouble(this.maxTextField.getText());
    }

    private int getGraphType() {
        int n = 1;
        if (this.lineButton.isSelected()) {
            n = 2;
        }
        return n;
    }

    public HistogramCondition createHistogramCondition() {
        HistogramCondition histogramCondition = new HistogramCondition();
        histogramCondition.setHistogramType(this.getHistogramType());
        histogramCondition.setValueOrganismCodeList(this.getValueOrganismCodeList());
        histogramCondition.setValueGeneInfoTitle(this.getValueGeneInfoTitle());
        histogramCondition.setPrimaryOrganismCode(this.getPrimaryOrganismCode());
        histogramCondition.setSecondaryOrganismCode(this.getSecondaryOrganismCode());
        histogramCondition.setDiffGeneInfoTitle(this.getDiffGeneInfoTitle());
        if (HistogramType.isValue(this.getHistogramType())) {
            histogramCondition.setMultiElementType(this.getValueGeneInfoTitle().getMultiElementType());
            histogramCondition.setMultiInfoType(this.getValueGeneInfoTitle().getMultiInfoType());
        } else if (HistogramType.isDiff(this.getHistogramType())) {
            histogramCondition.setMultiElementType(this.getDiffGeneInfoTitle().getMultiElementType());
            histogramCondition.setMultiInfoType(this.getDiffGeneInfoTitle().getMultiInfoType());
        }
        histogramCondition.setShowLable(this.isShowDataLabel());
        histogramCondition.setGraphType(this.getGraphType());
        if (StringTool.isDouble(this.minTextField.getText()) && StringTool.isDouble(this.maxTextField.getText())) {
            histogramCondition.setMinValue(this.getMinValue());
            histogramCondition.setMaxValue(this.getMaxValue());
            histogramCondition.setCalcedRange(true);
        }
        return histogramCondition;
    }

    @Override
    protected boolean check() {
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private void setAutoRange() {
        if (this.descriptionButton.isSelected() || this.funcNameButton.isSelected()) {
            return;
        }
        HistogramCondition histogramCondition = this.createHistogramCondition();
        HistogramDataCreater histogramDataCreater = new HistogramDataCreater(this, this.mediator, this.clusterTbl, this.clusterTbl.getClusterList(), histogramCondition);
        if (this.valueButton.isSelected()) {
            if (CollectionUtil.isNull(this.getValueOrganismCodeList())) {
                return;
            }
            AbstractInfoTitle abstractInfoTitle = this.getValueGeneInfoTitle();
            if (abstractInfoTitle != null && abstractInfoTitle.isCluster()) {
                histogramDataCreater.executeForValue(new DummyProgressComponent());
            } else if (this.getValueOrganismCodeList().size() >= 2) {
                histogramDataCreater.executeForMultiValue(new DummyProgressComponent());
            } else {
                histogramDataCreater.executeForValue(new DummyProgressComponent());
            }
        } else if (this.diffButton.isSelected()) {
            histogramDataCreater.executeForValue(new DummyProgressComponent());
        }
        this.minTextField.setText(NUMERIC_FORMAT.format(Math.floor(histogramDataCreater.getMinValue())));
        this.maxTextField.setText(NUMERIC_FORMAT.format(Math.ceil(histogramDataCreater.getMaxValue())));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.descriptionButton) {
            this.setEnableValueComponents(false);
            this.setEnableDiffComponents(false);
            this.setEnableViewComponents(false);
        } else if (actionEvent.getSource() == this.funcNameButton) {
            this.setEnableValueComponents(false);
            this.setEnableDiffComponents(false);
            this.setEnableViewComponents(false);
        } else if (actionEvent.getSource() == this.valueButton) {
            this.setEnableValueComponents(true);
            this.setEnableDiffComponents(false);
            this.setEnableViewComponents(true);
        } else if (actionEvent.getSource() == this.diffButton) {
            this.setEnableValueComponents(false);
            this.setEnableDiffComponents(true);
            this.setEnableViewComponents(true);
        } else if (actionEvent.getSource() == this.autoRangeButton) {
            this.setAutoRange();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.primaryOrganismComboBox) {
            this.updateGeneInfoTitleForDiff();
        } else if (itemEvent.getSource() == this.secondaryOrganismComboBox) {
            this.updateGeneInfoTitleForDiff();
        } else if (itemEvent.getSource() == this.valueGeneInfoTitleComboBox) {
            AbstractInfoTitle abstractInfoTitle = this.getValueGeneInfoTitle();
            if (abstractInfoTitle == null) {
                return;
            }
            this.setEnableValueOrganismSelectPanel(!abstractInfoTitle.isCluster());
        }
    }

    static {
        NUMERIC_FORMAT = new DecimalFormat("###############.###############");
    }
}

