/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ColorTbl;
import cgdp.recog.histogram.AbstractValueRenderer;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

class MultiLineRenderer
extends AbstractValueRenderer {
    MultiLineRenderer() {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        graphics2D.setFont(this.context.getFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.context.getWidth(), this.context.getHeight());
        ArrayList arrayList = new ArrayList(this.context.getViewClusterList());
        double d = this.context.calcIntervalY(arrayList.size());
        double d2 = d < 1.0 ? 1.0 : d;
        for (String string : this.context.getValueOrganismCodeList()) {
            if (!this.context.isShowOrganism(string)) continue;
            this.drawLine(graphics2D, arrayList, string, d2, d);
        }
        this.drawBaseLine(graphics2D, arrayList, d2, d);
        this.drawScale(graphics2D);
    }

    public void drawLine(Graphics2D graphics2D, List list, String string, double d, double d2) {
        double d3 = this.context.calcScaleX();
        double d4 = this.context.getOffsetTop();
        boolean bl = true;
        double d5 = -1.0;
        Color color = ColorTbl.getInstance().getColor(string);
        if (color == null) {
            color = ColorTbl.DEFAULT_COLOR;
        }
        graphics2D.setColor(color);
        for (int i = 0; i < list.size() && i < this.context.getRowCount(); ++i) {
            int n = i + this.context.getStartRow();
            Cluster cluster = (Cluster)list.get(n);
            if (this.context.containsValue(cluster, string)) {
                double d6 = this.context.getValue(cluster, string);
                double d7 = this.context.calcX(d3, d6);
                graphics2D.fill(new Rectangle2D.Double(d7 - 2.0, d4 + this.adjustCellHeight(d) / 2.0 - 2.0, 5.0, 5.0));
                if (!bl) {
                    graphics2D.draw(new Line2D.Double(d7, d4 + this.adjustCellHeight(d) / 2.0, d5, d4 - this.adjustCellHeight(d) / 2.0));
                } else {
                    bl = false;
                }
                d5 = d7;
            } else {
                bl = true;
            }
            d4 += d2;
        }
    }

    private void drawBaseLine(Graphics2D graphics2D, List list, double d, double d2) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getBorderLineColorString());
        double d3 = this.context.getOffsetTop();
        for (int i = 0; i < list.size() && i < this.context.getRowCount(); ++i) {
            int n = i + this.context.getStartRow();
            this.drawBorderLine(graphics2D, d3, d, color);
            this.drawSelectBorderLine(graphics2D, n, d3, d);
            d3 += d2;
        }
    }
}

