/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInfo {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractInfo.class);
    private int cls = -1;
    private Map valueMap = new HashMap();

    public AbstractInfo() {
    }

    public AbstractInfo(AbstractInfo abstractInfo) {
        this.setCls(abstractInfo.getCls());
        this.setValueMap(new HashMap(abstractInfo.getValueMap()));
    }

    public int getCls() {
        return this.cls;
    }

    protected void setCls(int n) {
        this.cls = n;
    }

    public Object getInfo(AbstractInfoTitle abstractInfoTitle) {
        return this.valueMap.get(abstractInfoTitle);
    }

    public List getMultiInfo(AbstractInfoTitle abstractInfoTitle) {
        List<Object> list = new ArrayList<Object>();
        Object object = this.getInfo(abstractInfoTitle);
        if (object == null || StringTool.isNull(String.valueOf(object))) {
            return list;
        }
        if (abstractInfoTitle.isMulti()) {
            list = abstractInfoTitle.splitMultiData(object);
        } else {
            list.add(object);
        }
        return list;
    }

    public boolean putInfo(AbstractInfoTitle abstractInfoTitle, Object object) {
        try {
            if (abstractInfoTitle.isNumeric() && (object == null || StringTool.isNull(String.valueOf(object)))) {
                return false;
            }
            this.valueMap.put(abstractInfoTitle, abstractInfoTitle.getValueAsType(object));
            return true;
        }
        catch (Exception exception) {
            logger.warn("Fail to register valueMap. title=" + abstractInfoTitle + " value=" + object, exception);
            return false;
        }
    }

    public boolean putMultiInfo(AbstractInfoTitle abstractInfoTitle, List list) {
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        this.valueMap.put(abstractInfoTitle, abstractInfoTitle.combineMultiData(list));
        return true;
    }

    public void addAllInfoTitle(List list) {
        for (AbstractInfoTitle abstractInfoTitle : list) {
            if (this.containsTitle(abstractInfoTitle)) continue;
            this.putInfo(abstractInfoTitle, "");
        }
    }

    public void putAllInfo(Map map) {
        this.valueMap.putAll(map);
    }

    public void putAllInfo(AbstractInfo abstractInfo) {
        this.putAllInfo(abstractInfo.getValueMap());
    }

    public boolean containsTitle(AbstractInfoTitle abstractInfoTitle) {
        return this.getInfo(abstractInfoTitle) != null;
    }

    public void retailAllInfo(Collection collection) {
        HashSet hashSet = new HashSet(this.valueMap.keySet());
        for (AbstractInfoTitle abstractInfoTitle : hashSet) {
            if (collection.contains(abstractInfoTitle)) continue;
            this.valueMap.remove(abstractInfoTitle);
        }
    }

    public void removeInfo(AbstractInfoTitle abstractInfoTitle) {
        this.valueMap.remove(abstractInfoTitle);
    }

    public void removeAllInfo(Collection collection) {
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            this.valueMap.remove(abstractInfoTitle);
        }
    }

    public Set getTitleSet() {
        return this.valueMap.keySet();
    }

    public Map getValueMap() {
        return new HashMap(this.valueMap);
    }

    private void setValueMap(Map map) {
        this.valueMap = map;
    }

    public int getValueSize() {
        return this.valueMap.size();
    }

    public boolean isExistValue() {
        return !this.valueMap.isEmpty();
    }
}

