/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractInfoConfImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractInfoConfImporter.class);
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_KEY = "Key";
    public static final String COLUMN_TYPE = "Type";
    public static final String COLUMN_CATEGORY = "Category";
    public static final String COLUMN_LOCATION = "Location";
    public static final String COLUMN_CLUSTER_INFO_TYPE = "ClusterInfoType";
    public static final String COLUMN_EDITABLE = "Editable";
    public static final String COLUMN_SERVER_SERACH_ENABLE = "ServerSearchEnable";
    public static final String COLUMN_SERACH_EQUAL_TYPE = "SearchEqualType";
    public static final String COLUMN_MULTI_ELEMENT_TYPE = "MultiElementType";
    public static final String COLUMN_NA_ELEMENT_TYPE = "NAElementType";
    public static final String COLUMN_NA_ELEMENT_SPEC_VALUE = "NAElementSpecValue";
    public static final String COLUMN_MULTI_INFO_TYPE = "MultiInfoType";
    public static final String COLUMN_NA_INFO_TYPE = "NAInfoType";
    public static final String COLUMN_NA_INFO_SPEC_VALUE = "NAInfoSpecValue";
    public static final String COLUMN_NEED_CACHE = "NeedCache";
    public static final String COLUMN_DOMCLUST_ID = "DomClust ID";
    public static final String COLUMN_ORGANISM = "Organism";
    protected static final String DELIMITER = "\t";
    protected static final String DELIMITER_SP = ",";
    protected static final String DELIMITER_DOMCLUST_ID = ",";
    protected List infoTitleList = new ArrayList();
    private String filepath;
    protected List columnNameList = new ArrayList();

    public List getInfoTitleList() {
        return this.infoTitleList;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    protected boolean setAnalysisOptions(String string, String string2, AbstractInfoTitle abstractInfoTitle) {
        if (string.equals("UseSort")) {
            abstractInfoTitle.setUseAnalysis("UseSort", new Boolean(string2));
            return true;
        }
        if (string.equals("UseHist")) {
            abstractInfoTitle.setUseAnalysis("UseHist", new Boolean(string2));
            return true;
        }
        if (string.equals("UseGeneColor")) {
            abstractInfoTitle.setUseAnalysis("UseGeneColor", new Boolean(string2));
            return true;
        }
        if (string.equals("UseSearch")) {
            abstractInfoTitle.setUseAnalysis("UseSearch", new Boolean(string2));
            return true;
        }
        if (string.equals("UsePPMLabel")) {
            abstractInfoTitle.setUseAnalysis("UsePPMLabel", new Boolean(string2));
            return true;
        }
        return false;
    }

    protected boolean setCalcOptions(String string, String string2, AbstractInfoTitle abstractInfoTitle) {
        if (string.equals(COLUMN_MULTI_ELEMENT_TYPE)) {
            try {
                int n = Integer.parseInt(string2);
                abstractInfoTitle.setMultiElementType(n);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse Multi Element Type.", exception);
            }
            return true;
        }
        if (string.equals(COLUMN_NA_ELEMENT_TYPE)) {
            try {
                int n = Integer.parseInt(string2);
                abstractInfoTitle.setNaElementType(n);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse NA Element Type.", exception);
            }
            return true;
        }
        if (string.equals(COLUMN_NA_ELEMENT_SPEC_VALUE)) {
            try {
                double d = Double.parseDouble(string2);
                abstractInfoTitle.setNaElementSpecValue(d);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse NA Element Spec Value.", exception);
            }
            return true;
        }
        if (string.equals(COLUMN_MULTI_INFO_TYPE)) {
            try {
                int n = Integer.parseInt(string2);
                abstractInfoTitle.setMultiInfoType(n);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse Multi Info Type.", exception);
            }
            return true;
        }
        if (string.equals(COLUMN_NA_INFO_TYPE)) {
            try {
                int n = Integer.parseInt(string2);
                abstractInfoTitle.setNaInfoType(n);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse NA Info Type.", exception);
            }
            return true;
        }
        if (string.equals(COLUMN_NA_INFO_SPEC_VALUE)) {
            try {
                double d = Double.parseDouble(string2);
                abstractInfoTitle.setNaInfoSpecValue(d);
            }
            catch (Exception exception) {
                logger.warn("Fail to parse NA Info Spec Value.", exception);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void parseHeaderLine(String string) {
        this.columnNameList = new ArrayList(StringTool.splitString(string, DELIMITER));
    }
}

