/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.calc.NAPanel;
import cgdp.recog.info.AbstractInfoTabPanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AbstractMultiOptionPanel;
import cgdp.recog.info.InfoClass;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.MultiNumOptionPanel;
import cgdp.recog.info.MultiOptionPanel;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class CalcOptionPanel
extends TabPanel
implements ActionListener {
    private AbstractInfoTitle infoTitle;
    private AbstractMultiOptionPanel multiElementPanel;
    private AbstractMultiOptionPanel multiInfoPanel;
    private NAPanel naInfoPanel;
    private NAPanel naElementPanel;
    private JButton allApplyButton;
    private List infoTitleList = new ArrayList();
    private AbstractInfoTabPanel infoTabPanel;

    public CalcOptionPanel(Component component) {
        super(component);
    }

    private void init(AbstractInfoTitle abstractInfoTitle) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createMultiPanel(abstractInfoTitle), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    private JPanel createMultiPanel(AbstractInfoTitle abstractInfoTitle) {
        this.multiInfoPanel = this.createMultiOptionPanel(abstractInfoTitle.getType());
        this.multiInfoPanel.setBorder(BorderFactory.createTitledBorder("Presentative value of multiple property value"));
        this.multiElementPanel = this.createMultiOptionPanel(abstractInfoTitle.getType());
        this.multiElementPanel.setBorder(BorderFactory.createTitledBorder("Presentative value of multiple gene in one cell"));
        this.naInfoPanel = new NAPanel();
        this.naInfoPanel.setBorder(BorderFactory.createTitledBorder("Treatment of missing property values"));
        this.naElementPanel = new NAPanel();
        this.naElementPanel.setBorder(BorderFactory.createTitledBorder("Treatment of missing genes"));
        this.allApplyButton = new JButton("Apply all properties");
        this.allApplyButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.multiInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.multiElementPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.naInfoPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.naElementPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.allApplyButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return jPanel;
    }

    void updateValue(AbstractInfoTitle abstractInfoTitle, List list, AbstractInfoTabPanel abstractInfoTabPanel) {
        this.init(abstractInfoTitle);
        this.infoTitle = abstractInfoTitle;
        this.infoTitleList = list;
        this.infoTabPanel = abstractInfoTabPanel;
        this.multiElementPanel.setMultiType(this.infoTitle.getMultiElementType());
        this.multiInfoPanel.setMultiType(this.infoTitle.getMultiInfoType());
        this.naElementPanel.updateValue(this.infoTitle.getNaElementType(), this.infoTitle.getNaElementSpecValue());
        this.naInfoPanel.updateValue(this.infoTitle.getNaInfoType(), this.infoTitle.getNaInfoSpecValue());
        ((TitledBorder)this.multiElementPanel.getBorder()).setTitle(this.getMultiElementBorderTitle(abstractInfoTitle.getCls()));
        ((TitledBorder)this.naElementPanel.getBorder()).setTitle(this.getNaElementBorderTitle(abstractInfoTitle.getCls()));
        this.allApplyButton.setVisible(this.isEnableAllApplyButton());
    }

    private boolean isEnableAllApplyButton() {
        return this.infoTabPanel != null && !CollectionUtil.isNull(this.infoTitleList);
    }

    private String getMultiElementBorderTitle(int n) {
        String string = "";
        if (InfoClass.isGene(n)) {
            string = "Presentative value of multiple gene in one cell";
        } else if (InfoClass.isCell(n)) {
            string = "Presentative value of multiple cluster";
        } else if (InfoClass.isCluster(n)) {
            string = "Presentative value of multiple cluster";
        }
        return string;
    }

    private String getNaElementBorderTitle(int n) {
        String string = "";
        if (InfoClass.isGene(n)) {
            string = "Treatment of missing genes";
        } else if (InfoClass.isCell(n)) {
            string = "Treatment of missing cells";
        } else if (InfoClass.isCluster(n)) {
            string = "Treatment of missing clusters";
        }
        return string;
    }

    private AbstractMultiOptionPanel createMultiOptionPanel(int n) {
        if (InfoType.isNumeric(n)) {
            return new MultiNumOptionPanel();
        }
        return new MultiOptionPanel();
    }

    public void setParameter(AbstractInfoTitle abstractInfoTitle) {
        abstractInfoTitle.setMultiElementType(this.getCalcMultiElementType());
        abstractInfoTitle.setMultiInfoType(this.getCalcMultiInfoType());
        abstractInfoTitle.setNaElementType(this.getNaElementType());
        abstractInfoTitle.setNaElementSpecValue(this.getNaElementSpecValue());
        abstractInfoTitle.setNaInfoType(this.getNaInfoType());
        abstractInfoTitle.setNaInfoSpecValue(this.getNaInfoSpecValue());
    }

    @Override
    protected void changeDefault() {
    }

    @Override
    public boolean check() {
        return true;
    }

    private int getCalcMultiInfoType() {
        return this.multiInfoPanel.getMultiType();
    }

    private int getCalcMultiElementType() {
        return this.multiElementPanel.getMultiType();
    }

    private int getNaInfoType() {
        return this.naInfoPanel.getNaType();
    }

    private double getNaInfoSpecValue() {
        return this.naInfoPanel.getSpecValue();
    }

    private int getNaElementType() {
        return this.naElementPanel.getNaType();
    }

    private double getNaElementSpecValue() {
        return this.naElementPanel.getSpecValue();
    }

    @Override
    protected void updateParameters() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.allApplyButton) {
            if (!this.isEnableAllApplyButton()) {
                return;
            }
            for (AbstractInfoTitle abstractInfoTitle : this.infoTitleList) {
                this.setParameter(abstractInfoTitle);
                this.infoTabPanel.addEditInfoTitle(abstractInfoTitle);
            }
        }
    }
}

