/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InfoExporter {
    public static final String DELIMITER = "\t";
    private String filepath;
    private List infoList;
    private List infoTitleList;
    private Map parameterMap;
    private String delimiter = "\t";
    private boolean outputName = false;

    protected InfoExporter(String string, List list, List list2) {
        this.filepath = string;
        this.infoTitleList = list;
        this.infoList = list2;
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    protected void setOutputName(boolean bl) {
        this.outputName = bl;
    }

    protected boolean isOutputName() {
        return this.outputName;
    }

    protected void setDelimiter(String string) {
        this.delimiter = string;
    }

    protected String getDelimiter() {
        return this.delimiter;
    }

    private String getFilepath() {
        return this.filepath;
    }

    protected List extractInfoTitleList() {
        List list = InfoUtil.extractInfoTitleList(this.infoList);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (CollectionUtil.isNull(this.getInfoTitleList())) {
            this.infoTitleList = this.extractInfoTitleList();
        }
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(this.getFilepath(), false);
            printWriter = new PrintWriter(fileOutputStream);
            String string = this.createParameterLines();
            if (!StringTool.isNull(string)) {
                printWriter.print(string);
            }
            printWriter.println(this.createHeaderLine());
            for (AbstractInfo abstractInfo : this.infoList) {
                String string2 = this.createDataLine(abstractInfo);
                printWriter.println(string2);
            }
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    protected String createParameterLines() {
        if (MapUtil.isNull(this.parameterMap)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(this.parameterMap.keySet());
        for (String string : arrayList) {
            String string2 = (String)this.parameterMap.get(string);
            stringBuffer.append(ServerStatus.createParameterMessageAddPrefix(string, string2));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    protected String createHeaderLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(InfoExporter.createHeaderLineCore(this.getInfoTitleList(), this.isOutputName(), this.getDelimiter()));
        return stringBuffer.toString();
    }

    public static String createHeaderLineCore(List list, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (AbstractInfoTitle abstractInfoTitle : list) {
            stringBuffer.append(AbstractInfoTitle.getNameTypeString(abstractInfoTitle, bl));
            if (n != list.size() - 1) {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String createDataLine(AbstractInfo abstractInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (AbstractInfoTitle abstractInfoTitle : this.infoTitleList) {
            Object object = abstractInfo.getInfo(abstractInfoTitle);
            if (object == null) {
                object = "";
            }
            if (object instanceof String && ((String)object).indexOf(this.getDelimiter()) != -1) {
                object = "\"" + object + "\"";
            }
            stringBuffer.append(object);
            if (n != this.getInfoTitleList().size() - 1) {
                stringBuffer.append(this.getDelimiter());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected List getInfoTitleList() {
        return this.infoTitleList;
    }
}

