/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoEditDialog;
import cgdp.recog.info.InfoFacade;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;

public class InfoOptionLinkLabel
extends JLabel {
    private static final ApplicationLogger logger = new ApplicationLogger(InfoOptionLinkLabel.class);

    public InfoOptionLinkLabel(String string, final Component component, final InfoTitleComboBox infoTitleComboBox) {
        super("<html><a href='" + string + "'>" + string + "</a>");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!InfoOptionLinkLabel.this.isEnabled()) {
                    return;
                }
                AbstractInfoTitle abstractInfoTitle = infoTitleComboBox.getSelectedInfoTitle();
                InfoEditDialog infoEditDialog = InfoEditDialog.getInstance(component);
                infoEditDialog.updateValue(abstractInfoTitle);
                infoEditDialog.setVisible(true);
                if (infoEditDialog.isCanceled()) {
                    return;
                }
                try {
                    InfoFacade.exportTitle(abstractInfoTitle);
                }
                catch (IOException iOException) {
                    String string = "Fail to save property information. " + abstractInfoTitle.getKey();
                    logger.warn(string, iOException);
                }
            }
        });
    }
}

