/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

public class InfoType {
    public static final int NO_TYPE = -1;
    public static final int NUMERIC = 1;
    public static final int CHARACTOR = 2;
    public static final int ENUM = 3;
    public static final int HIERARCHY = 4;
    public static final String NAME_NUMERIC = "Num";
    public static final String NAME_CHARACTOR = "Char";
    public static final String NAME_ENUM = "Enum";
    public static final String NAME_HIERARCHY = "Hierarchy";
    public static final String NAME_MULTI = "Multi";
    public static final String[] TYPE_NAMES = new String[]{"Char", "Num", "Enum", "Hierarchy"};

    public static boolean isNumeric(int n) {
        return n == 1;
    }

    public static boolean isCharactor(int n) {
        return n == 2;
    }

    public static boolean isEnum(int n) {
        return n == 3;
    }

    public static boolean isHierarchy(int n) {
        return n == 4;
    }

    public static boolean isNoType(int n) {
        return n == -1;
    }

    public static boolean isNumericName(String string) {
        return InfoType.isName(string, NAME_NUMERIC);
    }

    public static boolean isCharactorName(String string) {
        return InfoType.isName(string, NAME_CHARACTOR);
    }

    public static boolean isEnumName(String string) {
        return InfoType.isName(string, NAME_ENUM);
    }

    public static boolean isHierarchyName(String string) {
        return InfoType.isName(string, NAME_HIERARCHY);
    }

    public static boolean isMulti(String string) {
        return InfoType.isName(string, NAME_MULTI);
    }

    public static boolean isTypeKeyword(String string) {
        return InfoType.isCharactorName(string) || InfoType.isNumericName(string) || InfoType.isEnumName(string) || InfoType.isHierarchyName(string);
    }

    private static boolean isName(String string, String string2) {
        return string.toLowerCase().equals(string2.toLowerCase());
    }

    public static int getTypeIndex(String string) {
        int n = -1;
        if (InfoType.isNumericName(string)) {
            n = 1;
        } else if (InfoType.isCharactorName(string)) {
            n = 2;
        } else if (InfoType.isEnumName(string)) {
            n = 3;
        } else if (InfoType.isHierarchyName(string)) {
            n = 4;
        }
        return n;
    }

    public static String getTypeName(int n) {
        String string = null;
        if (InfoType.isNumeric(n)) {
            string = NAME_NUMERIC;
        } else if (InfoType.isCharactor(n)) {
            string = NAME_CHARACTOR;
        } else if (InfoType.isEnum(n)) {
            string = NAME_ENUM;
        } else if (InfoType.isHierarchy(n)) {
            string = NAME_HIERARCHY;
        }
        return string;
    }
}

