/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfExporter;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class CellInfoConfExporter
extends AbstractInfoConfExporter {
    public CellInfoConfExporter(List list) {
        this(list, Const.USER_CELL_INFO_PATH);
    }

    public CellInfoConfExporter(List list, String string) {
        super(list, string);
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringTool.conbineStrList(this.getHeaderNameList(), "\t"));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (CellInfoTitle cellInfoTitle : this.infoTitleList) {
            stringBuffer.append(this.createLine(cellInfoTitle));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private String createLine(CellInfoTitle cellInfoTitle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cellInfoTitle.getName());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getKey());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getTypeString());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getCategory());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getLocationName());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getInfoType());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.isEditable());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.isServerSearchEnable());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.getSearchEqualType());
        stringBuffer.append("\t");
        stringBuffer.append(cellInfoTitle.isCacheNeed());
        stringBuffer.append("\t");
        stringBuffer.append(this.createAnalysisOptionLine(cellInfoTitle));
        stringBuffer.append("\t");
        stringBuffer.append(this.createCalcOptionLine(cellInfoTitle));
        stringBuffer.append("\t");
        stringBuffer.append(StringTool.conbineStrList(cellInfoTitle.getDomClustIdSet(), ","));
        return stringBuffer.toString();
    }

    @Override
    protected List getHeaderNameList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Name");
        arrayList.add("Key");
        arrayList.add("Type");
        arrayList.add("Category");
        arrayList.add("Location");
        arrayList.add("ClusterInfoType");
        arrayList.add("Editable");
        arrayList.add("ServerSearchEnable");
        arrayList.add("SearchEqualType");
        arrayList.add("NeedCache");
        for (n = 0; n < ANALYSIS_HEADERS.length; ++n) {
            arrayList.add(ANALYSIS_HEADERS[n]);
        }
        for (n = 0; n < CALC_HEADERS.length; ++n) {
            arrayList.add(CALC_HEADERS[n]);
        }
        arrayList.add("DomClust ID");
        return arrayList;
    }
}

