/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cell;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoManager;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.util.ApplicationLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CellInfoFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(CellInfoFacade.class);
    private static final CellInfoFacade CELL_INFO_FACADE = new CellInfoFacade();

    private CellInfoFacade() {
    }

    public static CellInfoFacade getInstance() {
        return CELL_INFO_FACADE;
    }

    public static List getInfoTitleList() {
        return CellInfoManager.getInstance().getInfoTitleList();
    }

    public static List getInfoTitleList(String string) {
        return CellInfoManager.getInstance().getInfoTitleList(string);
    }

    public static void addCellInfo(Map map, Collection collection) {
        CellInfoManager.getInstance().addCellInfo(map, collection);
    }

    public static void addCellInfo(Map map, CellInfoTitle cellInfoTitle) {
        HashSet<CellInfoTitle> hashSet = new HashSet<CellInfoTitle>();
        hashSet.add(cellInfoTitle);
        CellInfoFacade.addCellInfo(map, hashSet);
    }

    public static List createValueList(String string, List list, CellInfoTitle cellInfoTitle) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Cluster cluster : list) {
            Object object = CellInfoFacade.getValue(string, cluster, cellInfoTitle);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static List getInfoTitleListByAnalysisKey(String string) {
        return CellInfoManager.getInstance().getInfoTitleListByAnalysisKey(string, null);
    }

    public static List getInfoTitleListByAnalysisKey(String string, ClusterTbl clusterTbl) {
        if (clusterTbl == null) {
            return new ArrayList();
        }
        List list = CellInfoManager.getInstance().getInfoTitleListByAnalysisKey(string, clusterTbl.getClusterId());
        return list;
    }

    private static Object getValue(String string, Cluster cluster, CellInfoTitle cellInfoTitle) {
        Object object = null;
        if (CellInfoManager.getInstance().isCachedInfoTitle(cellInfoTitle)) {
            object = CellInfoManager.getInstance().getValue(string, cluster, cellInfoTitle);
        } else if (cellInfoTitle.equalsKey("gene_count")) {
            int n = cluster.getGeneCount(string);
            if (n == -1) {
                return null;
            }
            object = new Float(n);
        }
        return object;
    }

    public static Map createClusterCellInfoMap(String string, List list, CellInfoTitle cellInfoTitle) {
        HashSet<CellInfoTitle> hashSet = new HashSet<CellInfoTitle>();
        hashSet.add(cellInfoTitle);
        return CellInfoFacade.createClusterCellInfoMap(string, list, hashSet);
    }

    public static Map createClusterCellInfoMap(String string, List list, Collection collection) {
        HashMap<Cluster, CellInfo> hashMap = new HashMap<Cluster, CellInfo>();
        for (Cluster cluster : list) {
            ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
            if (cluster instanceof SuperCluster) {
                arrayList.addAll(((SuperCluster)cluster).getSubClusterList());
            } else {
                arrayList.add(cluster);
            }
            for (Cluster cluster2 : arrayList) {
                CellInfo cellInfo = new CellInfo();
                for (CellInfoTitle cellInfoTitle : collection) {
                    Object object = CellInfoFacade.getValue(string, cluster2, cellInfoTitle);
                    if (object == null) continue;
                    cellInfo.putInfo(cellInfoTitle, object);
                    hashMap.put(cluster2, cellInfo);
                }
            }
        }
        return hashMap;
    }

    public static CellInfoTitle getCellInfoTitle(String string) {
        CellInfoManager cellInfoManager = CellInfoManager.getInstance();
        return (CellInfoTitle)cellInfoManager.getInfoTitle(string);
    }

    public static CellInfoTitle getCellInfoTitle(String string, int n) {
        CellInfoTitle cellInfoTitle = CellInfoFacade.getCellInfoTitle(string);
        if (ClusterMode.isBaseCluster(n)) {
            cellInfoTitle.setInfoType(3);
        } else {
            cellInfoTitle.setInfoType(4);
        }
        return cellInfoTitle;
    }

    public static void removeCachedInfo(CellInfoTitle cellInfoTitle) {
        HashSet<CellInfoTitle> hashSet = new HashSet<CellInfoTitle>();
        hashSet.add(cellInfoTitle);
        CellInfoManager.getInstance().removeCachedInfo(hashSet);
    }

    public static void removeCachedInfo(Collection collection) {
        CellInfoManager.getInstance().removeCachedInfo(collection);
    }

    public static void exportTitleList(List list) throws IOException {
        CellInfoManager.getInstance().exportTitleList(list);
    }

    public static void exportTitle(AbstractInfoTitle abstractInfoTitle) throws IOException {
        List list = CellInfoFacade.getInfoTitleList();
        int n = list.indexOf(abstractInfoTitle);
        if (n != -1) {
            list.remove(n);
            list.add(abstractInfoTitle);
        }
        CellInfoManager.getInstance().exportTitleList(list);
    }
}

