/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.calc.CoefCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternFactory;
import cgdp.recog.propvect.PropVectFacade;
import cgdp.recog.util.MathUtil;
import java.util.HashSet;
import java.util.List;

public class ClusterInfoCalculator {
    public static String getPattern(Cluster cluster, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (cluster.containsSp(string)) {
                stringBuffer.append("1");
                continue;
            }
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public static int getGeneCount(Cluster cluster) {
        return cluster.getGeneCount();
    }

    public static double getPatternCoef(Cluster cluster, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        List list = clusterInfoCalcCondition.getOrganismCodeList();
        Pattern pattern = clusterInfoCalcCondition.getBasePattern();
        Pattern pattern2 = new Pattern(new HashSet(list), cluster.getSpSet());
        for (String string : pattern2.getOrganismCodeList()) {
            if (!pattern.isIgnore(string)) continue;
            pattern2.setIgnore(string, true);
        }
        double d = PropVectFacade.calcDistance(clusterInfoCalcCondition.getDistType(), pattern, pattern2, pattern.getOrganismCodeListWithoutIgnore());
        d = MathUtil.roundDecimal(d, 4);
        return d;
    }

    public static double getNumVectCoef(Cluster cluster, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        CoefCondition coefCondition;
        List list = clusterInfoCalcCondition.getOrganismCodeList();
        Pattern pattern = clusterInfoCalcCondition.getBasePattern();
        Pattern pattern2 = PatternFactory.createNumericPattern(pattern, list, cluster, coefCondition = clusterInfoCalcCondition.getCoefCondition());
        if (pattern2 == null) {
            return Double.NaN;
        }
        Pattern pattern3 = (Pattern)pattern.clone();
        if (coefCondition.isIgnore()) {
            if (pattern2.getOrganismCodeListWithoutIgnore().size() == 0) {
                return Double.NaN;
            }
            for (String string : pattern.getOrganismCodeList()) {
                if (!pattern2.isIgnore(string)) continue;
                pattern3.setIgnore(string, true);
            }
        }
        List list2 = pattern3.getOrganismCodeListWithoutIgnore();
        double d = PropVectFacade.calcNumVectDistance(clusterInfoCalcCondition.getDistType(), pattern3, pattern2, list2);
        d = MathUtil.roundDecimal(d, 4);
        return d;
    }
}

