/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.Calculater;
import cgdp.recog.calc.CalculaterFactory;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoConvertCondition;
import cgdp.recog.info.cluster.ClusterInfoRegister;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.LocusTagComparator;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoConverter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoConverter.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterInfoConvertCondition condition;
    private List clusterList = new ArrayList();

    public ClusterInfoConverter(Component component, MediatorImpl mediatorImpl, ClusterInfoConvertCondition clusterInfoConvertCondition, List list) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.condition = clusterInfoConvertCondition;
        this.clusterList = list;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(this.condition.getOrganismCodeC().size() * this.clusterList.size());
            List list = this.clusterList;
            Map map = new HashMap();
            if (this.condition.isGene()) {
                map = this.createClusterOrganismCodeValueMapForGene(progressImpl);
            } else if (this.condition.isCell()) {
                map = this.createClusterOrganismCodeValueMapForCell(progressImpl);
            }
            ClusterInfoTitle clusterInfoTitle = this.condition.createClusterInfoTitle();
            Map map2 = this.createClusterInfoMap(list, map, clusterInfoTitle);
            ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
            arrayList.add(ClusterInfoTitle.TITLE_ID);
            arrayList.add(clusterInfoTitle);
            ClusterInfoRegister.margeLocalClusterInfo(this.condition.getDomClustId(), this.condition.getClusterInfoType(), arrayList, map2);
            ArrayList arrayList2 = new ArrayList(map2.values());
            ClusterInfoRegister.exportClusterInfo(this.condition.getDomClustId(), this.condition.getClusterInfoType(), arrayList2, arrayList);
        }
        catch (Exception exception) {
            String string = "Fail to caclulate the cluster property. Gene property:" + this.condition.getInfoTitle().getName() + "Cluster property:" + this.condition.getName();
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private Map createClusterOrganismCodeValueMapForGene(ProgressImpl progressImpl) throws Exception {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        for (String string : this.condition.getOrganismCodeC()) {
            Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, this.condition.getInfoTitle());
            LocusTagComparator locusTagComparator = new LocusTagComparator(this.condition, (GeneInfoTitle)this.condition.getInfoTitle(), map);
            Iterator iterator = this.clusterList.iterator();
            while (iterator.hasNext()) {
                List list;
                progressImpl.increment();
                Cluster cluster = (Cluster)iterator.next();
                this.calcProcessAveGene(cluster, string, this.condition, map, hashMap2, hashMap3);
                HashMap<String, Number> hashMap6 = (HashMap<String, Number>)hashMap.get(cluster);
                if (hashMap6 == null) {
                    hashMap6 = new HashMap<String, Number>();
                    hashMap.put(cluster, hashMap6);
                }
                if (CollectionUtil.isNull(list = cluster.getLocusTagWithoutDomainList(string))) {
                    this.registerNaCellMap(cluster, string, hashMap5);
                    continue;
                }
                Number number = (Number)((Object)GeneInfoMultiInfoManager.getRepresentativeValue(this.condition, list, locusTagComparator, map));
                if (number == null) {
                    this.registerNaCellMap(cluster, string, hashMap4);
                    continue;
                }
                hashMap6.put(string, number);
            }
        }
        this.calcAve(hashMap2, hashMap3);
        this.registerNaValueGene(hashMap5, hashMap2, hashMap);
        this.registerNaValueInfo(hashMap4, hashMap2, hashMap);
        return hashMap;
    }

    private void registerNaCellMap(Cluster cluster, String string, Map map) {
        HashSet<String> hashSet = (HashSet<String>)map.get(cluster);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            map.put(cluster, hashSet);
        }
        hashSet.add(string);
    }

    private void calcProcessAveGene(Cluster cluster, String string, ClusterInfoConvertCondition clusterInfoConvertCondition, Map map, Map map2, Map map3) {
        List list = cluster.getLocusTagWithoutDomainList(string);
        if (CollectionUtil.isNull(list)) {
            return;
        }
        for (String string2 : list) {
            GeneInfo geneInfo = (GeneInfo)map.get(string2);
            if (geneInfo == null) continue;
            this.calcProcesAve(cluster, clusterInfoConvertCondition, geneInfo, map2, map3);
        }
    }

    private void calcAve(Map map, Map map2) {
        for (Cluster cluster : map.keySet()) {
            double d = ((Number)map.get(cluster)).doubleValue();
            double d2 = ((Integer)map2.get(cluster)).doubleValue();
            double d3 = d / d2;
            map.put(cluster, new Float(d3));
        }
    }

    private void registerNaValueGene(Map map, Map map2, Map map3) {
        for (Cluster cluster : map.keySet()) {
            Set set = (Set)map.get(cluster);
            for (String string : set) {
                HashMap<String, Float> hashMap = (HashMap<String, Float>)map3.get(cluster);
                if (hashMap == null) {
                    hashMap = new HashMap<String, Float>();
                    map3.put(cluster, hashMap);
                }
                Number number = (Number)map2.get(cluster);
                double d = Double.NaN;
                if (number != null) {
                    d = number.doubleValue();
                }
                double d2 = this.condition.getComplementValueForGene(d);
                hashMap.put(string, new Float(d2));
            }
        }
    }

    private void registerNaValueInfo(Map map, Map map2, Map map3) {
        for (Cluster cluster : map.keySet()) {
            Set set = (Set)map.get(cluster);
            for (String string : set) {
                HashMap<String, Float> hashMap = (HashMap<String, Float>)map3.get(cluster);
                if (hashMap == null) {
                    hashMap = new HashMap<String, Float>();
                    map3.put(cluster, hashMap);
                }
                Number number = (Number)map2.get(cluster);
                double d = Double.NaN;
                if (number != null) {
                    d = number.doubleValue();
                }
                double d2 = this.condition.getComplementValueForInfo(d);
                hashMap.put(string, new Float(d2));
            }
        }
    }

    private Map createClusterOrganismCodeValueMapForCell(ProgressImpl progressImpl) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        for (String string : this.condition.getOrganismCodeC()) {
            Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)this.condition.getInfoTitle());
            Iterator iterator = this.clusterList.iterator();
            while (iterator.hasNext()) {
                CellInfo cellInfo;
                progressImpl.increment();
                Cluster cluster = (Cluster)iterator.next();
                this.calcProcessAveCell(cluster, this.condition, map, hashMap2, hashMap3);
                HashMap<String, Number> hashMap6 = (HashMap<String, Number>)hashMap.get(cluster);
                if (hashMap6 == null) {
                    hashMap6 = new HashMap<String, Number>();
                    hashMap.put(cluster, hashMap6);
                }
                if ((cellInfo = (CellInfo)map.get(cluster)) == null) {
                    this.registerNaCellMap(cluster, string, hashMap5);
                    continue;
                }
                Number number = (Number)cellInfo.getInfo(this.condition.getInfoTitle());
                if (number == null) {
                    this.registerNaCellMap(cluster, string, hashMap4);
                    continue;
                }
                hashMap6.put(string, number);
            }
        }
        this.calcAve(hashMap2, hashMap3);
        this.registerNaValueGene(hashMap5, hashMap2, hashMap);
        this.registerNaValueInfo(hashMap4, hashMap2, hashMap);
        return hashMap;
    }

    private void calcProcessAveCell(Cluster cluster, ClusterInfoConvertCondition clusterInfoConvertCondition, Map map, Map map2, Map map3) {
        CellInfo cellInfo = (CellInfo)map.get(cluster);
        if (cellInfo == null) {
            return;
        }
        this.calcProcesAve(cluster, clusterInfoConvertCondition, cellInfo, map2, map3);
    }

    private void calcProcesAve(Cluster cluster, ClusterInfoConvertCondition clusterInfoConvertCondition, AbstractInfo abstractInfo, Map map, Map map2) {
        Number number = (Number)abstractInfo.getInfo(clusterInfoConvertCondition.getInfoTitle());
        if (number == null) {
            return;
        }
        float f = ((Number)abstractInfo.getInfo(clusterInfoConvertCondition.getInfoTitle())).floatValue();
        double d = 0.0;
        if (map.containsKey(cluster)) {
            d = ((Number)map.get(cluster)).doubleValue();
        }
        map.put(cluster, new Float(d += (double)f));
        int n = 0;
        if (map2.containsKey(cluster)) {
            n = (Integer)map2.get(cluster);
        }
        map2.put(cluster, new Integer(++n));
    }

    private Map createClusterInfoMap(List list, Map map, ClusterInfoTitle clusterInfoTitle) {
        Calculater calculater = CalculaterFactory.createCalculater(this.condition.getCalcType());
        HashMap<String, ClusterInfo> hashMap = new HashMap<String, ClusterInfo>();
        for (Cluster cluster : list) {
            Map map2 = (Map)map.get(cluster);
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (Float f : map2.values()) {
                if (f == null) continue;
                arrayList.add(f);
            }
            calculater.setValueList(arrayList);
            double d = calculater.calculate();
            String string = ClusterInfoUtil.getClusterInfoKey(cluster, clusterInfoTitle.getInfoType());
            ClusterInfo clusterInfo = new ClusterInfo();
            clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, ClusterInfoUtil.getClusterInfoKey(cluster, clusterInfoTitle.getInfoType()));
            clusterInfo.putInfo(clusterInfoTitle, new Float(d));
            hashMap.put(string, clusterInfo);
        }
        return hashMap;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        this.mediator.updatePPMLabel();
    }
}

