/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.Const;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.info.cluster.ClusterInfoCalculator;
import cgdp.recog.info.cluster.ClusterInfoConfExporter;
import cgdp.recog.info.cluster.ClusterInfoConfImporter;
import cgdp.recog.info.cluster.ClusterInfoListExporter;
import cgdp.recog.info.cluster.ClusterInfoListImporter;
import cgdp.recog.info.cluster.ClusterInfoManager;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoTitleListDownloader;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.info.gene.GeneInfoTypeValidater;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoFacade.class);
    private static final ClusterInfoFacade CLUSTER_INFO_FACADE = new ClusterInfoFacade();

    private ClusterInfoFacade() {
    }

    public static ClusterInfoFacade getInstance() {
        return CLUSTER_INFO_FACADE;
    }

    public static Map importClusterInfo(ClusterInfoTitle clusterInfoTitle, String string) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        String string2 = DataManager.getClusterInfoFilepath(project, string, clusterInfoTitle.getInfoType());
        ClusterInfoListImporter clusterInfoListImporter = new ClusterInfoListImporter(string2, clusterInfoTitle.getInfoType(), string);
        clusterInfoListImporter.execute();
        return clusterInfoListImporter.getClusterInfoMap();
    }

    public static void saveClusterInfo(ClusterInfoTitle clusterInfoTitle, Map map, String string, int n) throws Exception {
        Object object;
        List list = ClusterInfoFacade.getInfoTitleList();
        if (!list.contains(clusterInfoTitle)) {
            list.add(clusterInfoTitle);
            clusterInfoTitle.addDomClustId(string);
        } else {
            int n2 = list.indexOf(clusterInfoTitle);
            object = (ClusterInfoTitle)list.get(n2);
            ((AbstractInfoTitle)object).addDomClustId(string);
        }
        ClusterInfoFacade.exportTitleList(list);
        Map map2 = ClusterInfoFacade.getInfoMap(string, n);
        for (String string2 : map.keySet()) {
            ClusterInfo clusterInfo = (ClusterInfo)map2.get(string2);
            if (clusterInfo == null) {
                clusterInfo = new ClusterInfo();
                map2.put(string2, clusterInfo);
            }
            ClusterInfo clusterInfo2 = (ClusterInfo)map.get(string2);
            Object object2 = clusterInfo2.getInfo(clusterInfoTitle);
            clusterInfo.putInfo(clusterInfoTitle, object2);
        }
        object = ClusterInfoUtil.getClusterInfoList(map2, n);
        ClusterInfoFacade.exportListFile(string, n, (List)object);
    }

    public static void exportTitleList(List list) throws IOException {
        ClusterInfoManager.getInstance().exportTitleList(list);
    }

    public static void exportTitle(AbstractInfoTitle abstractInfoTitle) throws IOException {
        List list = ClusterInfoFacade.getInfoTitleList();
        int n = list.indexOf(abstractInfoTitle);
        if (n != -1) {
            list.remove(n);
            list.add(abstractInfoTitle);
        }
        ClusterInfoManager.getInstance().exportTitleList(list);
    }

    public static List getInfoTitleList() {
        return ClusterInfoManager.getInstance().getInfoTitleList();
    }

    public static List getInfoTitleListWithoutGlobalByDomClustId(int n, String string) {
        List list = ClusterInfoFacade.getInfoTitleList();
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (ClusterInfoTitle clusterInfoTitle : list) {
            if (LocationType.isNameGlobal(clusterInfoTitle.getLocationName()) || LocationType.isNameSystem(clusterInfoTitle.getLocationName()) || clusterInfoTitle.getInfoType() != n || !clusterInfoTitle.containsDomClustId(string)) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }

    public static List getInfoTitleList(String string) {
        return ClusterInfoManager.getInstance().getInfoTitleList(string);
    }

    private static void exportListFile(String string, int n, List list) throws Exception {
        List list2 = InfoUtil.getInfoTitleList(list);
        list2.remove(ClusterInfoTitle.TITLE_ID);
        list2.add(0, ClusterInfoTitle.TITLE_ID);
        String string2 = DataManager.getClusterInfoFilepath(string, n);
        ClusterInfoListExporter clusterInfoListExporter = new ClusterInfoListExporter(string2, list2, list);
        clusterInfoListExporter.execute();
    }

    public static Map getInfoMap(String string, int n) {
        try {
            String string2 = DataManager.getClusterInfoFilepath(string, n);
            ClusterInfoListImporter clusterInfoListImporter = new ClusterInfoListImporter(string2, n, string);
            clusterInfoListImporter.execute();
            return clusterInfoListImporter.getClusterInfoMap();
        }
        catch (Exception exception) {
            String string3 = "Fail to load cluster info file. ";
            logger.warn(string3, exception);
            return new HashMap();
        }
    }

    public static ClusterInfo createClusterInfo(ClusterTbl clusterTbl, Cluster cluster, Collection collection) throws Exception {
        ClusterInfo clusterInfo = new ClusterInfo();
        ClusterInfo clusterInfo2 = clusterTbl.getClusterInfo();
        clusterInfo.putAllInfo(clusterInfo2);
        clusterInfo.retailAllInfo(collection);
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("combine_clusterid");
        if (collection.contains(clusterInfoTitle)) {
            clusterInfo.putInfo(clusterInfoTitle, cluster.getDisplayClusterId());
        }
        return clusterInfo;
    }

    public static List createValueList(List list, ClusterInfoTitle clusterInfoTitle, String string) throws Exception {
        ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();
        clusterInfoCalcCondition.setDomClustId(string);
        Map map = ClusterInfoFacade.createClusterInfoMap(list, clusterInfoTitle, clusterInfoCalcCondition);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ClusterInfo clusterInfo : map.values()) {
            Object object = clusterInfo.getInfo(clusterInfoTitle);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static List createSelectableClusterInfoTitleList() {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("domclust_id");
        ClusterInfoTitle clusterInfoTitle2 = ClusterInfoFacade.getInfoTitle("combine_clusterid");
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        arrayList.add(clusterInfoTitle);
        arrayList.add(clusterInfoTitle2);
        return arrayList;
    }

    public static Map createSelectableClusterInfoTitleMap() {
        List list = ClusterInfoFacade.createSelectableClusterInfoTitleList();
        HashMap<String, ClusterInfoTitle> hashMap = new HashMap<String, ClusterInfoTitle>();
        for (ClusterInfoTitle clusterInfoTitle : list) {
            hashMap.put(clusterInfoTitle.getKey(), clusterInfoTitle);
        }
        return hashMap;
    }

    public static ClusterInfoTitle getInfoTitle(String string) {
        ClusterInfoManager clusterInfoManager = ClusterInfoManager.getInstance();
        return (ClusterInfoTitle)clusterInfoManager.getInfoTitle(string);
    }

    public static List getUseAnalysisClusterInfoTitleList() {
        ArrayList arrayList = new ArrayList(ClusterInfoManager.getInstance().getCachedInfoTitleSet());
        arrayList.remove(ClusterInfoFacade.getInfoTitle("clusterid"));
        arrayList.remove(ClusterInfoFacade.getInfoTitle("combine_clusterid"));
        Collections.sort(arrayList, new InfoTitleComparator());
        return arrayList;
    }

    public static List getInfoTitleListByAnalysisKey(String string, ClusterTbl clusterTbl) {
        if (clusterTbl == null) {
            return new ArrayList();
        }
        List list = ClusterInfoManager.getInstance().getInfoTitleListByAnalysisKey(string, clusterTbl.getClusterId());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (clusterTbl.isExistHomCluster()) {
            hashSet.add(new Integer(2));
        }
        if (clusterTbl.isOutgroup()) {
            hashSet.add(new Integer(3));
            hashSet.add(new Integer(4));
        } else {
            hashSet.add(new Integer(3));
        }
        List list2 = ClusterInfoUtil.filterClusterInfoListByInfoType(list, hashSet);
        return list2;
    }

    public static List createSelectableTitleListForHistogram(ClusterTbl clusterTbl) {
        List list = ClusterInfoFacade.getInfoTitleListByAnalysisKey("UseHist", clusterTbl);
        List list2 = InfoUtil.filterByType(list, 1);
        return list2;
    }

    public static Map createClusterInfoMap(List list, ClusterInfoTitle clusterInfoTitle, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        HashSet<ClusterInfoTitle> hashSet = new HashSet<ClusterInfoTitle>();
        hashSet.add(clusterInfoTitle);
        return ClusterInfoFacade.createClusterInfoMap(list, hashSet, clusterInfoCalcCondition);
    }

    public static Map createClusterInfoMap(List list, Collection collection, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        List list2;
        List list3 = ClusterInfoFacade.getHomClusterUnitInfoTitle(collection);
        List list4 = ClusterInfoFacade.getClusterUnitInfoTitle(collection);
        List list5 = ClusterInfoFacade.getSubClusterUnitInfoTitle(collection);
        HashMap hashMap = new HashMap();
        if (!CollectionUtil.isNull(list3)) {
            list2 = ClusterTbl.createSuperClusterListByHomCluster(list);
            ClusterInfoFacade.createClusterInfoMapCore(list2, list3, clusterInfoCalcCondition, hashMap);
        }
        if (!CollectionUtil.isNull(list4)) {
            list2 = ClusterTbl.createSuperClusterListByCluster(list);
            ClusterInfoFacade.createClusterInfoMapCore(list2, list4, clusterInfoCalcCondition, hashMap);
        }
        if (!CollectionUtil.isNull(list5)) {
            ClusterInfoFacade.createClusterInfoMapCore(list, list5, clusterInfoCalcCondition, hashMap);
        }
        return hashMap;
    }

    private static void createClusterInfoMapCore(List list, Collection collection, ClusterInfoCalcCondition clusterInfoCalcCondition, Map map) {
        for (Cluster cluster : list) {
            Object object;
            Object object22;
            ClusterInfo clusterInfo = new ClusterInfo();
            for (Object object22 : collection) {
                if (!((AbstractInfoTitle)object22).isCluster() || (object = ClusterInfoFacade.getValue(cluster, (ClusterInfoTitle)object22, clusterInfoCalcCondition)) == null) continue;
                clusterInfo.putInfo((AbstractInfoTitle)object22, object);
            }
            if (!clusterInfo.isExistValue()) continue;
            ArrayList arrayList = new ArrayList();
            if (cluster instanceof SuperCluster) {
                arrayList.addAll(((SuperCluster)cluster).getSubClusterList());
            } else {
                arrayList.add(cluster);
            }
            object22 = arrayList.iterator();
            while (object22.hasNext()) {
                object = (Cluster)object22.next();
                ClusterInfo clusterInfo2 = (ClusterInfo)map.get(object);
                if (clusterInfo2 == null) {
                    clusterInfo2 = new ClusterInfo();
                    map.put(object, clusterInfo2);
                }
                clusterInfo2.putAllInfo(clusterInfo);
            }
        }
    }

    private static List getHomClusterUnitInfoTitle(Collection collection) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            ClusterInfoTitle clusterInfoTitle;
            if (!abstractInfoTitle.isCluster() || !(clusterInfoTitle = (ClusterInfoTitle)abstractInfoTitle).isInfoTypeHomCluster()) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }

    private static List getClusterUnitInfoTitle(Collection collection) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            ClusterInfoTitle clusterInfoTitle;
            if (!abstractInfoTitle.isCluster() || !(clusterInfoTitle = (ClusterInfoTitle)abstractInfoTitle).isInfoTypeCluster()) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }

    private static List getSubClusterUnitInfoTitle(Collection collection) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : collection) {
            ClusterInfoTitle clusterInfoTitle;
            if (!abstractInfoTitle.isCluster() || !(clusterInfoTitle = (ClusterInfoTitle)abstractInfoTitle).isInfoTypeSubCluster()) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }

    public static Object getValue(Cluster cluster, ClusterInfoTitle clusterInfoTitle, String string) {
        ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();
        clusterInfoCalcCondition.setDomClustId(string);
        return ClusterInfoFacade.getValue(cluster, clusterInfoTitle, clusterInfoCalcCondition);
    }

    private static Object getValue(Cluster cluster, ClusterInfoTitle clusterInfoTitle, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        Object object;
        if (ClusterInfoManager.getInstance().isCachedInfoTitle(clusterInfoTitle)) {
            object = ClusterInfoManager.getInstance().getValue(clusterInfoTitle, cluster);
        } else if (clusterInfoTitle.equalsKey("CPattern") || clusterInfoTitle.equalsKey("SCPattern")) {
            object = ClusterInfoCalculator.getPattern(cluster, clusterInfoCalcCondition.getOrganismCodeList());
        } else if (clusterInfoTitle.equalsKey("combine_clusterid")) {
            object = cluster.getConbinedClusterId();
        } else if (clusterInfoTitle.equalsKey("CGeneCount") || clusterInfoTitle.equalsKey("SCGeneCount")) {
            object = new Integer(ClusterInfoCalculator.getGeneCount(cluster));
        } else if (clusterInfoTitle.isCacheNeed() && !ClusterInfoManager.getInstance().isCachedInfoTitle(clusterInfoTitle)) {
            try {
                Map map = ClusterInfoFacade.importClusterInfo(clusterInfoTitle, clusterInfoCalcCondition.getDomClustId());
                ClusterInfoFacade.addClusterInfo(map, clusterInfoTitle, clusterInfoTitle.getInfoType());
                object = ClusterInfoManager.getInstance().getValue(clusterInfoTitle, cluster);
            }
            catch (Exception exception) {
                logger.warn("Fail to load cluster information." + clusterInfoTitle.getKey(), exception);
                object = null;
            }
        } else {
            object = clusterInfoTitle.equalsKey("CFuncCat") || clusterInfoTitle.equalsKey("CFuncMbgd") || clusterInfoTitle.equalsKey("CFuncCog") || clusterInfoTitle.equalsKey("CFuncKegg") || clusterInfoTitle.equalsKey("CFuncTigr") ? cluster.getFunctionCategory() : (clusterInfoTitle.equalsKey("SCFuncMbgd") || clusterInfoTitle.equalsKey("SCFuncCog") || clusterInfoTitle.equalsKey("SCFuncKegg") || clusterInfoTitle.equalsKey("SCFuncTigr") ? cluster.getSubFunctionCategory() : cluster.getValue(clusterInfoTitle));
        }
        return object;
    }

    public static Object getValue(Cluster cluster, ClusterInfoTitle clusterInfoTitle) {
        return ClusterInfoFacade.getValue(cluster, clusterInfoTitle, (ClusterInfoCalcCondition)null);
    }

    public static ClusterInfoCalcCondition createClusterInfoCalcCondition(ClusterTbl clusterTbl) {
        ClusterInfoCalcCondition clusterInfoCalcCondition = new ClusterInfoCalcCondition();
        clusterInfoCalcCondition.setDomClustId(clusterTbl.getClusterId());
        clusterInfoCalcCondition.setOrganismCodeList(clusterTbl.getViewOrganismCodeList());
        return clusterInfoCalcCondition;
    }

    public static void addClusterInfo(Map map, ClusterInfoTitle clusterInfoTitle, int n) {
        HashSet<ClusterInfoTitle> hashSet = new HashSet<ClusterInfoTitle>();
        hashSet.add(clusterInfoTitle);
        ClusterInfoManager.getInstance().addClusterInfo(map, hashSet, n);
    }

    public static void removeClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        HashSet<ClusterInfoTitle> hashSet = new HashSet<ClusterInfoTitle>();
        hashSet.add(clusterInfoTitle);
        ClusterInfoFacade.removeCachedInfo(hashSet);
    }

    public static void removeCachedInfo(Collection collection) {
        ClusterInfoManager.getInstance().removeCachedInfo(collection);
    }

    public static void loadClusterInfo(ClusterInfoTitle clusterInfoTitle, String string) throws IOException {
        Map map = ClusterInfoFacade.importClusterInfo(clusterInfoTitle, string);
        ClusterInfoFacade.addClusterInfo(map, clusterInfoTitle, clusterInfoTitle.getInfoType());
    }

    public static void setDomClustId(String string) {
        ClusterInfoManager.getInstance().setDomClustId(string);
    }

    public static boolean validateInfoTitle(Component component, ClusterInfoTitle clusterInfoTitle) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        arrayList.add(clusterInfoTitle);
        return ClusterInfoFacade.validateInfoTitle(component, arrayList);
    }

    public static boolean validateInfoTitle(Component component, List list) {
        List list2 = ClusterInfoFacade.getInfoTitleList();
        HashSet hashSet = new HashSet(ClusterInfoTitle.getSystemClusterInfoTitleKeyList());
        return ClusterInfoFacade.validateInfoTitle(component, list, list2, hashSet);
    }

    public static boolean validateInfoTitle(Component component, List list, List list2, Set set) {
        HashSet<String[]> hashSet = new HashSet<String[]>();
        HashSet<String[]> hashSet2 = new HashSet<String[]>();
        for (String[] stringArray : list) {
            String[] stringArray2;
            if (set.contains(stringArray.getKey())) {
                stringArray2 = new String[]{"This cluster property is reserved.", "[" + stringArray.getName() + "]"};
                MessageManager.showErrorMessage(component, stringArray2);
                return false;
            }
            if (LocationType.isNameGlobal(stringArray.getLocationName()) || LocationType.isNameSystem(stringArray.getLocationName()) || CollectionUtil.isNull((Collection)(stringArray2 = InfoUtil.getInfoTitle(stringArray.getKey(), list2)))) continue;
            for (ClusterInfoTitle clusterInfoTitle : stringArray2) {
                System.out.println(stringArray.getInfoType());
                System.out.println(clusterInfoTitle.getInfoType());
                if (stringArray.getInfoType() != clusterInfoTitle.getInfoType()) {
                    hashSet.add(stringArray);
                    continue;
                }
                if (!stringArray.getLocationName().equals(clusterInfoTitle.getLocationName())) continue;
                hashSet2.add(stringArray);
            }
        }
        if (!CollectionUtil.isNull(hashSet)) {
            String[] stringArray;
            String string = StringTool.conbineStrList(InfoUtil.getInfoTitleNameSet(hashSet), ",");
            stringArray = new String[]{"You have already made cluster property.", "[" + (String)string + "]"};
            MessageManager.showErrorMessage(component, stringArray);
            return false;
        }
        return true;
    }

    public static void clear() {
        if (ClusterInfoFacade.getInstance() == null) {
            return;
        }
        ClusterInfoManager.getInstance().clear();
    }

    public static Object validateInfoValue(AbstractInfoTitle abstractInfoTitle, AbstractInfoTitle abstractInfoTitle2) {
        Set set = ((ClusterInfoTitle)abstractInfoTitle).getDomClustIdSet();
        for (String string : set) {
            try {
                Map map = ClusterInfoFacade.getInfoMap(string, abstractInfoTitle2.getInfoType());
                for (ClusterInfo clusterInfo : map.values()) {
                    Object object = clusterInfo.getInfo(abstractInfoTitle);
                    if (GeneInfoTypeValidater.validateValue(abstractInfoTitle2, object)) continue;
                    return object;
                }
            }
            catch (Exception exception) {
                String string2 = "Fail to load cluster propery file. " + string;
                logger.warn(string2, exception);
            }
        }
        return null;
    }

    public static List downloadClusterInfoTitleList(String string, Project project) throws Exception {
        ClusterInfoTitleListDownloader clusterInfoTitleListDownloader = new ClusterInfoTitleListDownloader(string, project);
        clusterInfoTitleListDownloader.execute();
        return clusterInfoTitleListDownloader.getClusterInfoTitleList();
    }

    public void deleteClusterInfo(String string, Project project) throws IOException {
        boolean bl = false;
        ClusterInfoConfImporter clusterInfoConfImporter = new ClusterInfoConfImporter(Const.USER_CLUSTER_INFO_PATH);
        clusterInfoConfImporter.execute();
        List list = clusterInfoConfImporter.getInfoTitleList();
        for (int i = 0; i < list.size(); ++i) {
            ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)list.get(i);
            if (project.getProjectName().compareTo(clusterInfoTitle.getLocationName()) != 0) continue;
            Set set = clusterInfoTitle.getDomClustIdSet();
            for (String string2 : set) {
                if (string.compareTo(string2) != 0) continue;
                set.clear();
                list.remove(i);
                logger.info("cluster_info: " + clusterInfoTitle.getName() + " " + clusterInfoTitle.getLocationName() + " " + clusterInfoTitle.getDomClustIdSet().toString() + " was deleted.");
                bl = true;
            }
        }
        if (bl) {
            ClusterInfoConfExporter clusterInfoConfExporter = new ClusterInfoConfExporter(list);
            clusterInfoConfExporter.execute();
        }
    }
}

