/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoImporter;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.StringTool;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ClusterInfoListImporter
extends InfoImporter {
    private int infoType = -1;
    private String location;
    private String domClustId;
    private Map clusterInfoMap = new HashMap();

    protected ClusterInfoListImporter(String string) {
        super(string);
        Project project = ProjectAccesser.getSelectedProject();
        this.location = project.getProjectName();
    }

    protected ClusterInfoListImporter(String string, int n, String string2) {
        super(string);
        this.setInfoType(n);
        this.setDomClustId(string2);
        Project project = ProjectAccesser.getSelectedProject();
        this.location = project.getProjectName();
    }

    public static ClusterInfoListImporter createRegisterClusterInfoImporter(String string, int n, String string2) {
        ClusterInfoListImporter clusterInfoListImporter = new ClusterInfoListImporter(string, n, string2);
        clusterInfoListImporter.addConvertTitle("ID", ClusterInfoTitle.TITLE_ID);
        clusterInfoListImporter.addConvertTitle("##ID", ClusterInfoTitle.TITLE_ID);
        return clusterInfoListImporter;
    }

    @Override
    protected AbstractInfoTitle createInfoTitle(String string) {
        return ClusterInfoTitle.createClusterInfoTitle(string, this.getInfoType(), this.location);
    }

    @Override
    protected void initTitleConvertMap(Map map) {
        map.put("id", ClusterInfoTitle.TITLE_ID);
    }

    @Override
    protected void parseDataLineCore(int n, String string) {
        String string2;
        Vector vector = StringTool.splitString(string, "\t");
        if (ClusterInfoType.isNoSelect(this.infoType)) {
            string2 = (String)vector.get(0);
            if (Cluster.isSubClusterKey(string2)) {
                this.setInfoType(4);
            } else {
                this.setInfoType(3);
            }
            this.updateInfoTitle();
        }
        if (vector.size() != this.getInfoTitleList().size()) {
            this.setError(true);
            this.setErrorMessage("The data is not correct. [" + string + "]");
            return;
        }
        string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = String.valueOf(vector.get(i)).trim();
            if (i == 0) {
                string2 = string3;
                continue;
            }
            ClusterInfo clusterInfo = (ClusterInfo)this.clusterInfoMap.get(string2);
            if (clusterInfo == null) {
                clusterInfo = new ClusterInfo();
                this.clusterInfoMap.put(string2, clusterInfo);
            }
            ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)this.infoTitleList.get(i);
            clusterInfo.putInfo(clusterInfoTitle, string3);
        }
    }

    @Override
    protected void afterProcess() {
    }

    private void updateInfoTitle() {
        for (ClusterInfoTitle clusterInfoTitle : this.getInfoTitleList()) {
            if (clusterInfoTitle.isEditable()) {
                clusterInfoTitle.addDomClustId(this.getDomClustId());
                clusterInfoTitle.setCacheNeed(true);
            }
            clusterInfoTitle.setInfoType(this.getInfoType());
        }
    }

    public int getInfoType() {
        return this.infoType;
    }

    public void setInfoType(int n) {
        this.infoType = n;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public Map getClusterInfoMap() {
        return this.clusterInfoMap;
    }
}

