/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoListExporter;
import cgdp.recog.info.cluster.ClusterInfoListImporter;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClusterInfoRegister
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoRegister.class);
    private Component parent;
    private MediatorImpl mediator;
    private String filepath;
    private String domClustId;
    private int infoType;

    public ClusterInfoRegister(Component component, MediatorImpl mediatorImpl, String string, String string2, int n) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.filepath = string;
        this.domClustId = string2;
        this.infoType = n;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            ClusterInfoListImporter clusterInfoListImporter = new ClusterInfoListImporter(this.filepath, this.infoType, this.domClustId);
            clusterInfoListImporter.execute();
            if (ClusterInfoType.isNoSelect(this.infoType)) {
                this.infoType = clusterInfoListImporter.getInfoType();
            }
            if (clusterInfoListImporter.isError()) {
                MessageManager.showErrorMessage(this.parent, clusterInfoListImporter.getErrorMessage());
                return;
            }
            List list = clusterInfoListImporter.getInfoTitleList();
            Map map = clusterInfoListImporter.getClusterInfoMap();
            List list2 = ClusterInfoFacade.getInfoTitleList();
            if (!this.validateInfoTitle(list, list2)) {
                return;
            }
            int n = 29;
            progressImpl.setCount(n);
            progressImpl.increment();
            ClusterInfoRegister.margeLocalClusterInfo(this.domClustId, this.infoType, list, map, 30, 70.0, progressImpl);
            n = 89;
            progressImpl.setCount(n);
            progressImpl.increment();
            this.setId(map);
            ArrayList arrayList = new ArrayList(map.values());
            ClusterInfoRegister.exportClusterInfo(this.domClustId, this.infoType, arrayList, list);
            n = 99;
            progressImpl.setCount(n);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to save cluster property file.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void setId(Map map) {
        for (String string : map.keySet()) {
            ClusterInfo clusterInfo = (ClusterInfo)map.get(string);
            clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, string);
        }
    }

    public static void margeLocalClusterInfo(String string, int n, List list, Map map) throws IOException {
        ClusterInfoRegister.margeLocalClusterInfo(string, n, list, map, 0, 0.0, new DummyProgressComponent());
    }

    private static void margeLocalClusterInfo(String string, int n, List list, Map map, int n2, double d, ProgressImpl progressImpl) throws IOException {
        int n3 = n2;
        String string2 = DataManager.getClusterInfoFilepath(string, n);
        if (new File(string2).isFile()) {
            ClusterInfoListImporter clusterInfoListImporter = ClusterInfoListImporter.createRegisterClusterInfoImporter(string2, n, string);
            clusterInfoListImporter.execute();
            List list2 = clusterInfoListImporter.getInfoTitleList();
            Map map2 = clusterInfoListImporter.getClusterInfoMap();
            int n4 = (int)(d / ((double)list2.size() * 2.0));
            ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
            for (ClusterInfoTitle clusterInfoTitle : list2) {
                progressImpl.setCount(n3 += n4);
                progressImpl.increment();
                if (list.contains(clusterInfoTitle)) continue;
                arrayList.add(clusterInfoTitle);
                for (String string3 : map2.keySet()) {
                    ClusterInfo clusterInfo = (ClusterInfo)map2.get(string3);
                    if (clusterInfo == null) continue;
                    ClusterInfo clusterInfo2 = (ClusterInfo)map.get(string3);
                    if (clusterInfo2 == null) {
                        clusterInfo2 = new ClusterInfo();
                        map.put(string3, clusterInfo2);
                    }
                    clusterInfo2.putInfo(clusterInfoTitle, clusterInfo.getInfo(clusterInfoTitle));
                }
            }
            list.addAll(arrayList);
        }
    }

    public static void exportClusterInfo(String string, int n, List list, List list2) throws Exception {
        String string2 = DataManager.getClusterInfoFilepath(string, n);
        List list3 = ClusterInfoFacade.getInfoTitleList();
        Collections.sort(list, new InfoComparator(ClusterInfoTitle.TITLE_ID));
        ClusterInfoListExporter clusterInfoListExporter = new ClusterInfoListExporter(string2, list2, list);
        clusterInfoListExporter.execute();
        ClusterInfoFacade.removeCachedInfo(list2);
        for (ClusterInfoTitle clusterInfoTitle : list2) {
            if (clusterInfoTitle.equals(ClusterInfoTitle.TITLE_ID)) continue;
            if (list3.contains(clusterInfoTitle)) {
                int n2 = list3.indexOf(clusterInfoTitle);
                ClusterInfoTitle clusterInfoTitle2 = (ClusterInfoTitle)list3.get(n2);
                clusterInfoTitle2.addDomClustId(string);
                continue;
            }
            list3.add(clusterInfoTitle);
        }
        ClusterInfoFacade.exportTitleList(list3);
    }

    private boolean validateInfoTitle(List list, List list2) {
        if (!list.contains(ClusterInfoTitle.TITLE_ID)) {
            String[] stringArray = new String[]{"This file does not include [ID] column."};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return false;
        }
        HashSet hashSet = new HashSet(ClusterInfoTitle.getSystemClusterInfoTitleKeyList());
        hashSet.remove("##ID");
        return ClusterInfoFacade.validateInfoTitle(this.parent, list, list2, hashSet);
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        this.mediator.updatePPMLabel();
    }
}

