/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.info.AnalysisUseType;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.URLList;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClusterInfoTitleListDownloader
extends AbstractServerResourceAccesser {
    private static final String DELIMITER = "\t";
    private String domClustId;
    private Map clusterInfoMap = new HashMap();

    public ClusterInfoTitleListDownloader(String string, Project project) {
        this.setProject(project);
        this.domClustId = string;
        this.setContextPath(URLList.getInstance().getGetClusterPropTitleList());
        this.setOptions();
    }

    @Override
    public void parseOutputStringData(int n, String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (vector.size() != 2) {
            return;
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        String string4 = string2 + "(" + string3 + ")";
        ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)this.clusterInfoMap.get(string2);
        if (clusterInfoTitle == null) {
            Project project = ProjectAccesser.getSelectedProject();
            clusterInfoTitle = ClusterInfoTitle.createClusterInfoTitle(string4, 3, project.getProjectName());
            clusterInfoTitle.setLocationName("Server");
            clusterInfoTitle.setEditable(false);
            clusterInfoTitle.setCacheNeed(true);
            AnalysisUseType.setUserAnalysisFlag(clusterInfoTitle);
            this.clusterInfoMap.put(string2, clusterInfoTitle);
        }
        clusterInfoTitle.addDomClustId(this.domClustId);
    }

    public List getClusterInfoTitleList() {
        ArrayList arrayList = new ArrayList(this.clusterInfoMap.values());
        Collections.sort(arrayList, new InfoTitleComparator());
        return arrayList;
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tabid=");
        stringBuffer.append(this.domClustId);
        this.setOptions(stringBuffer.toString());
    }
}

