/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import java.util.List;

public class ClusterInfoUploader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoUploader.class);
    private static final String DELIMITER = "\t";
    private static final String ID = "ID";
    private String domClustId;
    private ClusterInfoTitle clusterInfoTitle;
    private List clusterInfoList;
    private String uploadType = "";

    public ClusterInfoUploader(ClusterInfoTitle clusterInfoTitle, List list, String string, String string2) throws Exception {
        this.clusterInfoList = list;
        this.clusterInfoTitle = clusterInfoTitle;
        this.domClustId = string;
        this.setUploadType(string2);
        this.setContextPath(URLList.getInstance().getPutClusterProp());
        this.setOptions();
    }

    private void setUploadType(String string) {
        this.uploadType = string;
    }

    @Override
    public void parseOutputStringData(int n, String string) {
    }

    public void setOptions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode=");
        if (this.uploadType != null) {
            stringBuffer.append(this.uploadType);
        }
        stringBuffer.append("&tabid=");
        stringBuffer.append(this.domClustId);
        stringBuffer.append("&prop_val=");
        stringBuffer.append(Codec.encode(this.getPropertyContents()));
        this.setOptions(stringBuffer.toString());
    }

    private String getPropertyContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ID);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(AbstractInfoTitle.getNameTypeString(this.clusterInfoTitle, true));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (ClusterInfo clusterInfo : this.clusterInfoList) {
            if (!clusterInfo.containsTitle(this.clusterInfoTitle)) continue;
            stringBuffer.append(clusterInfo.getInfo(ClusterInfoTitle.TITLE_ID));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(clusterInfo.getInfo(this.clusterInfoTitle));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        logger.info(stringBuffer.toString());
        return stringBuffer.toString();
    }
}

