/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class GeneInfoTypeValidater {
    private GeneInfoTypeValidater() {
    }

    public static boolean validateValue(AbstractInfoTitle abstractInfoTitle, Object object) {
        try {
            ArrayList<Object> arrayList;
            if (object == null) {
                return true;
            }
            if (abstractInfoTitle.isMulti()) {
                arrayList = abstractInfoTitle.splitMultiData(object);
            } else {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
            }
            for (Object e : arrayList) {
                if (StringTool.isNull(String.valueOf(e))) continue;
                if (abstractInfoTitle.isNumeric() && !GeneInfoTypeValidater.validateNumeric(e)) {
                    return false;
                }
                if (abstractInfoTitle.isEnum() && !GeneInfoTypeValidater.validateEnum(e, abstractInfoTitle.getElementList())) {
                    return false;
                }
                if (!abstractInfoTitle.isHierarchy() || GeneInfoTypeValidater.validateHierarchy(e)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validateStrandValue(GeneInfoTitle geneInfoTitle, Object object) {
        int n;
        List list = GeneInfoTypeValidater.convertValueList(geneInfoTitle, object);
        if (CollectionUtil.isNull(list)) {
            return true;
        }
        Object e = list.get(n);
        for (n = 0; e == null && n < list.size(); ++n) {
            e = list.get(n);
        }
        if (StringTool.isNull(String.valueOf(e))) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("+");
        hashSet.add("-");
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("-1");
        hashSet2.add("1");
        hashSet2.add("0");
        HashSet<String> hashSet3 = hashSet2;
        if (hashSet.contains(e)) {
            hashSet3 = hashSet;
        }
        for (Object e2 : list) {
            if (StringTool.isNull(String.valueOf(e2)) || !geneInfoTitle.isEnum() || GeneInfoTypeValidater.validateEnum(e2, hashSet3)) continue;
            return false;
        }
        return true;
    }

    private static List convertValueList(GeneInfoTitle geneInfoTitle, Object object) {
        ArrayList<Object> arrayList;
        if (geneInfoTitle.isMulti()) {
            arrayList = geneInfoTitle.splitMultiData(object);
        } else {
            arrayList = new ArrayList<Object>();
            arrayList.add(object);
        }
        return arrayList;
    }

    public static boolean validateNumeric(Object object) {
        try {
            Float.parseFloat(String.valueOf(object));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean validateEnum(Object object, Collection collection) {
        if (StringTool.isNull(String.valueOf(object))) {
            return true;
        }
        return collection.contains(object);
    }

    public static boolean validateHierarchy(Object object) {
        Vector vector = StringTool.splitString(String.valueOf(object), ".");
        for (String string : vector) {
            try {
                Integer.parseInt(string);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

