/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class GeneInfoUtil {
    static String getOrganismCodeFromFileName(String string) {
        return string.replaceAll(".dat", "");
    }

    public static Map createLocusTagGeneInfoMap(Collection collection) {
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        if (collection == null || collection.isEmpty()) {
            return hashMap;
        }
        for (GeneInfo geneInfo : collection) {
            hashMap.put(geneInfo.getLocusTag(), geneInfo);
        }
        return hashMap;
    }

    public static Set createOrganismCodeLocusTagSet(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GeneInfo geneInfo : collection) {
            hashSet.add(GeneUtil.createOrganismLocusTagKey(geneInfo));
        }
        return hashSet;
    }

    public static Map createOrganismCodeLocusTagListMap(Collection collection) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        for (GeneInfo geneInfo : collection) {
            String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(geneInfo.getLocusTag());
        }
        return hashMap;
    }

    public static Map createOrganismCodeGeneInfoListMap(Collection collection) {
        HashMap<String, ArrayList<GeneInfo>> hashMap = new HashMap<String, ArrayList<GeneInfo>>();
        for (GeneInfo geneInfo : collection) {
            String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            ArrayList<GeneInfo> arrayList = (ArrayList<GeneInfo>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<GeneInfo>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(geneInfo);
        }
        return hashMap;
    }

    public static Set getGeneInfoSet(Collection collection) {
        HashSet hashSet = new HashSet();
        for (Cluster cluster : collection) {
            hashSet.addAll(cluster.createGeneInfoSet());
        }
        return hashSet;
    }

    public static Set adjustUniqueGeneInfo(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<GeneInfo> hashSet2 = new HashSet<GeneInfo>();
        for (GeneInfo geneInfo : collection) {
            if (hashSet.contains(geneInfo.getLocusTag())) continue;
            hashSet2.add(geneInfo);
            hashSet.add(geneInfo.getLocusTag());
        }
        return hashSet2;
    }

    public static List createGeneInfoList(Map map) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            for (String string2 : list) {
                GeneInfo geneInfo = new GeneInfo();
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
                geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string2);
                arrayList.add(geneInfo);
            }
        }
        return arrayList;
    }

    public static List createGeneInfoList(Collection collection) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (String string : collection) {
            Vector vector = StringTool.splitString(string, ":");
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(1);
            GeneInfo geneInfo = new GeneInfo();
            geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string2);
            geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string3);
            arrayList.add(geneInfo);
        }
        return arrayList;
    }

    public static List createGeneInfoListByClusterList(List list) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Cluster cluster : list) {
            List list2 = cluster.getGeneInfoListWithoutDomainNo();
            if (CollectionUtil.isNull(list2)) continue;
            for (GeneInfo geneInfo : list2) {
                String string = geneInfo.getKey();
                if (hashSet.contains(string)) continue;
                arrayList.add(geneInfo);
                hashSet.add(string);
            }
        }
        return arrayList;
    }

    public static String createOrganismLocusTagString(Collection collection) {
        return GeneInfoUtil.createOrganismLocusTagString(collection, false);
    }

    public static String createOrganismLocusTagString(Collection collection, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (GeneInfo geneInfo : collection) {
            stringBuffer.append(geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE));
            stringBuffer.append(":");
            String string = geneInfo.getLocusTag();
            if (bl) {
                string = GeneUtil.removeDomainNo(string);
            }
            stringBuffer.append(string);
            if (n != collection.size() - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Set getClusterListByGeneInfo(Collection collection, ClusterTbl clusterTbl) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (GeneInfo geneInfo : collection) {
            String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            String string2 = geneInfo.getLocusTag();
            Cluster cluster = clusterTbl.getCluster(string, string2);
            hashSet.add(cluster);
        }
        return hashSet;
    }

    public static String getDefaultGeneInfoTitleName(String string) {
        List list = GeneInfoFacade.getGeneInfoTitleList();
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractInfoTitle abstractInfoTitle : list) {
            hashSet.add(abstractInfoTitle.getKey());
            hashSet.add(abstractInfoTitle.getName());
        }
        Object object = string;
        int n = 2;
        while (hashSet.contains(object)) {
            object = string + " " + n;
            ++n;
        }
        return object;
    }
}

