/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTableModel;
import cgdp.recog.util.TableSorter;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class GeneList
extends JScrollPane {
    private MediatorImpl mediator;
    private JTable geneListTable;

    GeneList(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.setPreferredSize(new Dimension(750, 500));
    }

    void createGeneList(String string, List list, List list2) {
        GeneInfoTableModel geneInfoTableModel = new GeneInfoTableModel(list, list2);
        TableSorter tableSorter = new TableSorter(geneInfoTableModel);
        this.geneListTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.geneListTable.getTableHeader());
        this.geneListTable.setSelectionMode(0);
        this.geneListTable.setRowHeight(20);
        this.setViewportView(this.geneListTable);
    }

    void clearTable() {
        if (this.isShowTable()) {
            this.setViewportView(null);
        }
    }

    boolean isShowTable() {
        return this.geneListTable != null && this.geneListTable.getRowCount() > 0;
    }

    private GeneInfoTableModel getGeneInfoTableModel() {
        return (GeneInfoTableModel)((TableSorter)this.geneListTable.getModel()).getTableModel();
    }

    private TableSorter getTableSorter() {
        return (TableSorter)this.geneListTable.getModel();
    }

    void saveGeneList(File file) throws Exception {
        TableSorter tableSorter = this.getTableSorter();
        GeneInfoTableModel geneInfoTableModel = this.getGeneInfoTableModel();
        List list = geneInfoTableModel.getGeneInfoList();
        HashMap<Integer, GeneInfo> hashMap = new HashMap<Integer, GeneInfo>();
        for (int i = 0; i < list.size(); ++i) {
            GeneInfo geneInfo = (GeneInfo)list.get(i);
            int n = tableSorter.viewIndex(i);
            hashMap.put(new Integer(n), geneInfo);
        }
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (int i = 0; i < list.size(); ++i) {
            GeneInfo geneInfo = (GeneInfo)hashMap.get(new Integer(i));
            arrayList.add(geneInfo);
        }
        GeneInfoFacade.exportGeneInfoList(file.getAbsolutePath(), arrayList, geneInfoTableModel.getGeneInfoTitleList());
    }
}

