/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.mapping.ContigGap;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContigGapGroup {
    private String chrNo;
    private List contigGapList = new ArrayList();
    private String shape = "linear";
    private ContigGap endGap = new ContigGap();

    public ContigGapGroup() {
        this.endGap.setGapLength(0);
    }

    public String getChrNo() {
        return this.chrNo;
    }

    public void setChrNo(String string) {
        this.chrNo = string;
    }

    public List getContigGapList() {
        return this.contigGapList;
    }

    public void setContigGapList(List list) {
        this.contigGapList = list;
    }

    public boolean isExistContigGap() {
        return !CollectionUtil.isNull(this.getContigGapList());
    }

    public void addAllContigGapList(List list) {
        this.contigGapList.addAll(list);
    }

    public void removeAllContigGapList(Collection collection) {
        HashSet<ContigGap> hashSet = new HashSet<ContigGap>();
        Set set = this.getContigIdSet(collection);
        for (ContigGap contigGap : this.contigGapList) {
            if (!set.contains(new Integer(contigGap.getContigId()))) continue;
            hashSet.add(contigGap);
        }
        this.contigGapList.removeAll(hashSet);
    }

    private Set getContigIdSet(Collection collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ContigGap contigGap : collection) {
            hashSet.add(new Integer(contigGap.getContigId()));
        }
        return hashSet;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String string) {
        this.shape = string;
    }

    public void setSeqNo(String string) {
        for (ContigGap contigGap : this.getContigGapList()) {
            contigGap.setSeqNo(string);
        }
        this.endGap.setSeqNo(string);
    }

    public ContigGap getEndGap() {
        return this.endGap;
    }

    public void setEndGap(ContigGap contigGap) {
        this.endGap = contigGap;
    }

    public int getEndGapLength() {
        return this.endGap.getGapLength();
    }

    public void setEndGapLength(int n) {
        this.endGap.setGapLength(n);
    }

    public void setOrganismCode(String string) {
        for (ContigGap contigGap : this.getContigGapList()) {
            contigGap.setOrganismCode(string);
        }
        this.getEndGap().setOrganismCode(string);
    }

    public Chromosome getChromosome() {
        if (CollectionUtil.isNull(this.getContigGapList())) {
            return null;
        }
        return ((ContigGap)this.getContigGapList().get(0)).getChromosome();
    }

    public void setChromosome(Chromosome chromosome) {
        for (ContigGap contigGap : this.getContigGapList()) {
            contigGap.setChromosome(chromosome);
        }
        this.endGap.setChromosome(chromosome);
    }

    public void clearChromosome() {
        for (ContigGap contigGap : this.getContigGapList()) {
            contigGap.clearChromosome();
        }
        this.endGap.clearChromosome();
    }

    public int getLength() {
        int n = 0;
        for (ContigGap contigGap : this.getContigGapList()) {
            n += contigGap.getLength();
        }
        return n += this.endGap.getLength();
    }
}

