/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeComparator;
import cgdp.recog.data.ChromosomeExporter;
import cgdp.recog.data.ChromosomeImporter;
import cgdp.recog.data.ChromosomeUtil;
import cgdp.recog.data.ContigTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneExporter;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.mapping.ContigGap;
import cgdp.recog.mapping.ContigGapGroup;
import cgdp.recog.mapping.MapCondition;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.mapping.MappingUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.GeneUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(MapExecuter.class);
    private MapCondition mapCondition;

    public MapExecuter(MapCondition mapCondition) {
        this.mapCondition = mapCondition;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            progressImpl.setTotal(7);
            Project project = ProjectAccesser.getSelectedProject();
            MappingUtil.createDataDirectory(project);
            progressImpl.increment();
            MapFacade.deleteMapConf(this.mapCondition.getRemoveMapConfSet());
            if (this.mapCondition.isAllDelete()) {
                progressImpl.setCount(6);
                progressImpl.increment();
                return;
            }
            progressImpl.increment();
            List list = MapFacade.createChromosomeList(this.mapCondition.getOrganismCode(), this.mapCondition.getContigGapGroupMap(), this.mapCondition.getMapConf().getFilename());
            progressImpl.increment();
            ContigTbl contigTbl = new ContigTbl(this.mapCondition.getOrganismCode());
            contigTbl.read();
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            Map map = ChromosomeUtil.createChromNoMap(list);
            for (Object object42 : this.mapCondition.getContigGapGroupMap().keySet()) {
                object3 = (ContigGapGroup)this.mapCondition.getContigGapGroupMap().get(object42);
                object2 = ((ContigGapGroup)object3).getContigGapList();
                Chromosome chromosome = (Chromosome)map.get(object42);
                ((ContigGapGroup)object3).setOrganismCode(this.mapCondition.getOrganismCode());
                ((ContigGapGroup)object3).setChromosome(chromosome);
                hashMap.putAll(this.createContigIdChromIdMap(chromosome, (List)object2));
                hashMap2.putAll(this.createContigIdOffsetMap(chromosome, (List)object2));
                hashMap3.putAll(this.createContigIdDirectionMap(chromosome, (List)object2));
            }
            progressImpl.increment();
            GeneTbl geneTbl = new GeneTbl(this.mapCondition.getOrganismCode());
            geneTbl.setServerOnly(true);
            geneTbl.read();
            object42 = new ArrayList(geneTbl.values());
            object3 = object42.iterator();
            while (object3.hasNext()) {
                object2 = (Gene)object3.next();
                int n = ((Gene)object2).getContigId();
                object = new Integer(n);
                if (!hashMap.containsKey(object)) continue;
                int n2 = (Integer)hashMap.get(object);
                int n3 = (Integer)hashMap2.get(object);
                int n4 = (Integer)hashMap3.get(object);
                ((Gene)object2).setChromId(n2);
                int n5 = ((Gene)object2).getDirection();
                ((Gene)object2).setDirection(n4 * n5);
                int n6 = ((Gene)object2).getStart() + n3;
                int n7 = ((Gene)object2).getEnd() + n3;
                String string = GeneUtil.convertLocation(((Gene)object2).getLocation(), n3);
                ((Gene)object2).setStart(n6);
                ((Gene)object2).setEnd(n7);
                ((Gene)object2).setLocation(string);
            }
            progressImpl.increment();
            object3 = ChromosomeUtil.createChromNoMap(list);
            for (String string : this.mapCondition.getChromosomeNoList()) {
                object = (ContigGapGroup)this.mapCondition.getContigGapGroupMap().get(string);
                Chromosome chromosome = (Chromosome)object3.get(string);
                ((ContigGapGroup)object).setSeqNo(chromosome.getSeqNo());
            }
            object2 = this.convertMapRecodeList();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            int n = this.saveChromosome(list);
            this.saveGene((List)object42);
            object = this.mapCondition.getMapConf();
            MapFacade.saveMapRecode((MapConf)object, (List)object2);
            MapFacade.saveBaseChromId(n);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to create the mapping information file.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private int saveChromosome(List list) throws IOException {
        Object object3;
        Object object2;
        Set set = MapFacade.getChrIdSetFromMappingFile(this.mapCondition.getOrganismCode(), this.mapCondition.getMapConf().getFilename());
        set.removeAll(MapFacade.getChromIdSetFromChromosome(list));
        List list2 = new ArrayList();
        String string = DataManager.getProjectChromosomeFilePath(this.mapCondition.getOrganismCode());
        try {
            object2 = new ChromosomeImporter(this.mapCondition.getOrganismCode());
            ((ChromosomeImporter)object2).setFilepath(string);
            ((FileImporter)object2).execute();
            list2 = ((ChromosomeImporter)object2).getChromosomeList();
        }
        catch (Exception exception) {
            logger.warn("Fail to load chromosome file. " + string, exception);
        }
        object2 = new HashSet();
        for (Object object3 : list2) {
            if (set.contains(new Integer(((Chromosome)object3).getId()))) continue;
            object2.add(object3);
        }
        list2.removeAll((Collection<?>)object2);
        list2.addAll(list);
        Collections.sort(list2, new ChromosomeComparator());
        ChromosomeExporter chromosomeExporter = new ChromosomeExporter(string, list2);
        chromosomeExporter.execute();
        object3 = MapFacade.getChromIdSetFromChromosome(list2);
        int n = -1;
        if (!CollectionUtil.isNull((Collection)object3)) {
            n = (Integer)Collections.min((Collection)object3) - 1;
        }
        return n;
    }

    private void saveGene(List list) throws IOException {
        String string = DataManager.getProjectGeneFilePath(this.mapCondition.getOrganismCode());
        GeneExporter geneExporter = new GeneExporter(string, list);
        geneExporter.execute();
    }

    private List convertMapRecodeList() {
        ArrayList<MapRecode> arrayList = new ArrayList<MapRecode>();
        List list = this.mapCondition.getChromosomeNoList();
        Map map = this.mapCondition.getContigGapGroupMap();
        for (String string : list) {
            ContigGapGroup contigGapGroup = (ContigGapGroup)map.get(string);
            arrayList.addAll(MapFacade.convertMapRecodeList(contigGapGroup.getContigGapList()));
            arrayList.add(contigGapGroup.getEndGap().getGapMapRecode());
        }
        return arrayList;
    }

    private Map createContigIdChromIdMap(Chromosome chromosome, List list) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (ContigGap contigGap : list) {
            int n = contigGap.getContigId();
            hashMap.put(new Integer(n), new Integer(chromosome.getId()));
        }
        return hashMap;
    }

    private Map createContigIdOffsetMap(Chromosome chromosome, List list) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (ContigGap contigGap : list) {
            int n2 = contigGap.getContigId();
            hashMap.put(new Integer(n2), new Integer(n += contigGap.getGapLength()));
            n += contigGap.getContigLength();
        }
        return hashMap;
    }

    private Map createContigIdDirectionMap(Chromosome chromosome, List list) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (ContigGap contigGap : list) {
            int n = contigGap.getContigId();
            int n2 = contigGap.getContigDirection();
            hashMap.put(new Integer(n), new Integer(n2));
        }
        return hashMap;
    }

    @Override
    public void done() {
    }
}

