/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.menu;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class AggregateModeTool
extends JButton
implements CommandImpl {
    private MediatorImpl mediator;

    public AggregateModeTool(ActionListener actionListener, MediatorImpl mediatorImpl) {
        this.changeMode();
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setEnabled(false);
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.mediator.register(this);
    }

    @Override
    public void execute() {
        this.mediator.changeAggregateMode(!this.isAggregateMode());
    }

    public void changeMode() {
        this.setToolTipText(this.getLabelText());
        this.changeIcon();
    }

    private String getLabelText() {
        return this.isAggregateMode() ? "Disaggregate Mode" : "Aggregate Mode";
    }

    private void changeIcon() {
        try {
            if (this.isAggregateMode()) {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/intensive.png")));
            } else {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/dispersion.png")));
            }
        }
        catch (Exception exception) {
            this.setText("0");
        }
    }

    private boolean isAggregateMode() {
        return OptionTbl.getInstance().getOptionValues().isIntensive();
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }
}

