/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.mgmap.AlignmentFrame;
import cgdp.recog.mgmap.RGMCondition;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

class LabelOnOffTool
extends JToggleButton
implements CommandImpl {
    private AlignmentFrame alignmentFrame;

    LabelOnOffTool(ActionListener actionListener, AlignmentFrame alignmentFrame) {
        this.setToolTipText("Lable ON/OFF");
        this.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/labelOff.png")));
            this.setSelectedIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/labelOn.png")));
        }
        catch (Exception exception) {
            this.setText("0");
        }
        this.addActionListener(actionListener);
        this.alignmentFrame = alignmentFrame;
    }

    void updateValue(RGMCondition rGMCondition) {
        this.setSelected(rGMCondition.isShowLabel());
    }

    @Override
    public void execute() {
        this.alignmentFrame.labelOnOff(this.isSelected());
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }
}

