/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.multiplealign;

import cgdp.recog.multiplealign.Content;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DnaTool {
    public static final int DONT_NORMALIZATION = 0;
    public static final int NORMALIZATION0_1 = 1;
    public static final int NORMALIZATION1_1 = 2;
    public static final int EVEN_WEIGHT = 0;
    public static final int LINEAR_WEIGHT = 1;

    public static final String reverseComplement(String string) {
        String string2 = "";
        if (string == null || string.length() < 1) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block26: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'A': {
                    stringBuffer.append('T');
                    continue block26;
                }
                case 'C': {
                    stringBuffer.append('G');
                    continue block26;
                }
                case 'G': {
                    stringBuffer.append('C');
                    continue block26;
                }
                case 'T': {
                    stringBuffer.append('A');
                    continue block26;
                }
                case 'M': {
                    stringBuffer.append('K');
                    continue block26;
                }
                case 'R': {
                    stringBuffer.append('Y');
                    continue block26;
                }
                case 'Y': {
                    stringBuffer.append('R');
                    continue block26;
                }
                case 'K': {
                    stringBuffer.append('M');
                    continue block26;
                }
                case 'V': {
                    stringBuffer.append('T');
                    continue block26;
                }
                case 'H': {
                    stringBuffer.append('G');
                    continue block26;
                }
                case 'D': {
                    stringBuffer.append('C');
                    continue block26;
                }
                case 'B': {
                    stringBuffer.append('A');
                    continue block26;
                }
                case 'a': {
                    stringBuffer.append('t');
                    continue block26;
                }
                case 'c': {
                    stringBuffer.append('g');
                    continue block26;
                }
                case 'g': {
                    stringBuffer.append('c');
                    continue block26;
                }
                case 't': {
                    stringBuffer.append('a');
                    continue block26;
                }
                case 'm': {
                    stringBuffer.append('k');
                    continue block26;
                }
                case 'r': {
                    stringBuffer.append('y');
                    continue block26;
                }
                case 'y': {
                    stringBuffer.append('r');
                    continue block26;
                }
                case 'k': {
                    stringBuffer.append('m');
                    continue block26;
                }
                case 'v': {
                    stringBuffer.append('t');
                    continue block26;
                }
                case 'h': {
                    stringBuffer.append('g');
                    continue block26;
                }
                case 'd': {
                    stringBuffer.append('c');
                    continue block26;
                }
                case 'b': {
                    stringBuffer.append('a');
                    continue block26;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.reverse();
        string2 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer = null;
        return string2;
    }

    public static final String complement(String string) {
        String string2 = "";
        if (string == null || string.length() < 1) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block26: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'A': {
                    stringBuffer.append('T');
                    continue block26;
                }
                case 'C': {
                    stringBuffer.append('G');
                    continue block26;
                }
                case 'G': {
                    stringBuffer.append('C');
                    continue block26;
                }
                case 'T': {
                    stringBuffer.append('A');
                    continue block26;
                }
                case 'M': {
                    stringBuffer.append('K');
                    continue block26;
                }
                case 'R': {
                    stringBuffer.append('Y');
                    continue block26;
                }
                case 'Y': {
                    stringBuffer.append('R');
                    continue block26;
                }
                case 'K': {
                    stringBuffer.append('M');
                    continue block26;
                }
                case 'V': {
                    stringBuffer.append('T');
                    continue block26;
                }
                case 'H': {
                    stringBuffer.append('G');
                    continue block26;
                }
                case 'D': {
                    stringBuffer.append('C');
                    continue block26;
                }
                case 'B': {
                    stringBuffer.append('A');
                    continue block26;
                }
                case 'a': {
                    stringBuffer.append('t');
                    continue block26;
                }
                case 'c': {
                    stringBuffer.append('g');
                    continue block26;
                }
                case 'g': {
                    stringBuffer.append('c');
                    continue block26;
                }
                case 't': {
                    stringBuffer.append('a');
                    continue block26;
                }
                case 'm': {
                    stringBuffer.append('k');
                    continue block26;
                }
                case 'r': {
                    stringBuffer.append('y');
                    continue block26;
                }
                case 'y': {
                    stringBuffer.append('r');
                    continue block26;
                }
                case 'k': {
                    stringBuffer.append('m');
                    continue block26;
                }
                case 'v': {
                    stringBuffer.append('t');
                    continue block26;
                }
                case 'h': {
                    stringBuffer.append('g');
                    continue block26;
                }
                case 'd': {
                    stringBuffer.append('c');
                    continue block26;
                }
                case 'b': {
                    stringBuffer.append('a');
                    continue block26;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        string2 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer = null;
        return string2;
    }

    public static boolean isBase(char c) {
        char c2 = Character.toUpperCase(c);
        return c2 == 'A' || c2 == 'C' || c2 == 'G' || c2 == 'T' || c2 == 'M' || c2 == 'R' || c2 == 'W' || c2 == 'S' || c2 == 'Y' || c2 == 'K' || c2 == 'V' || c2 == 'H' || c2 == 'D' || c2 == 'B' || c2 == 'N';
    }

    public static boolean isAmino(char c) {
        char c2 = Character.toUpperCase(c);
        return c2 == 'A' || c2 == 'R' || c2 == 'N' || c2 == 'D' || c2 == 'C' || c2 == 'Q' || c2 == 'E' || c2 == 'G' || c2 == 'H' || c2 == 'I' || c2 == 'L' || c2 == 'K' || c2 == 'M' || c2 == 'F' || c2 == 'P' || c2 == 'S' || c2 == 'T' || c2 == 'W' || c2 == 'Y' || c2 == 'V' || c2 == 'U' || c2 == 'B' || c2 == 'Z' || c2 == 'X';
    }

    public static ArrayList gcContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'G' && c != 'C') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 71 && n12 != 67) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList atContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'A' && c != 'T') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 65 && n12 != 84) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList aContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'A') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 65) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList cContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'C') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 67) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList gContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'G') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 71) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList tContent(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7;
                int n8;
                int n9 = i - n3 / 2;
                int n10 = i + n3 / 2;
                int n11 = 0;
                for (n8 = n9; n8 <= n10; ++n8) {
                    n7 = DnaTool.revicePos(n8, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n7 - 1));
                    if (c != 'T') continue;
                    ++n11;
                }
                n8 = i - n4 / 2;
                n7 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n8);
                content.setEnd(n7);
                content.setContent((double)n11 / (double)(n10 - n9 + 1));
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12;
                int n13;
                int n14 = i - n3 / 2;
                int n15 = i + n3 / 2;
                int n16 = 0;
                if (n14 >= 1 && n15 <= stringBuffer.length()) {
                    for (n13 = n14; n13 <= n15; ++n13) {
                        n12 = Character.toUpperCase(stringBuffer.charAt(n13 - 1));
                        if (n12 != 84) continue;
                        ++n16;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n13 = i - n4 / 2;
                n13 = n13 < 1 ? 1 : n13;
                n12 = i + n4 / 2;
                n12 = n12 > stringBuffer.length() ? stringBuffer.length() : n12;
                Content content = new Content();
                content.setStart(n13);
                content.setEnd(n12);
                content.setContent((double)n16 / (double)(n15 - n14 + 1));
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList gcSkew(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7 = i - n3 / 2;
                int n8 = i + n3 / 2;
                int n9 = 0;
                int n10 = 0;
                for (int j = n7; j <= n8; ++j) {
                    int n11 = DnaTool.revicePos(j, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n11 - 1));
                    if (c == 'G') {
                        ++n9;
                        continue;
                    }
                    if (c != 'C') continue;
                    ++n10;
                }
                n7 = i - n4 / 2;
                n8 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n7);
                content.setEnd(n8);
                if (n9 == 0 && n10 == 0) {
                    content.setContent(0.0);
                } else {
                    content.setContent((double)(n9 - n10) / (double)(n9 + n10));
                }
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12 = i - n3 / 2;
                int n13 = i + n3 / 2;
                int n14 = 0;
                int n15 = 0;
                if (n12 >= 1 && n13 <= stringBuffer.length()) {
                    for (int j = n12; j <= n13; ++j) {
                        char c = Character.toUpperCase(stringBuffer.charAt(j - 1));
                        if (c == 'G') {
                            ++n14;
                            continue;
                        }
                        if (c != 'C') continue;
                        ++n15;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n12 = i - n4 / 2;
                n12 = n12 < 1 ? 1 : n12;
                n13 = i + n4 / 2;
                n13 = n13 > stringBuffer.length() ? stringBuffer.length() : n13;
                Content content = new Content();
                content.setStart(n12);
                content.setEnd(n13);
                content.setEffective(bl2);
                if (n14 == 0 && n15 == 0) {
                    content.setContent(0.0);
                } else {
                    content.setContent((double)(n14 - n15) / (double)(n14 + n15));
                }
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList atSkew(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7 = i - n3 / 2;
                int n8 = i + n3 / 2;
                int n9 = 0;
                int n10 = 0;
                for (int j = n7; j <= n8; ++j) {
                    int n11 = DnaTool.revicePos(j, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n11 - 1));
                    if (c == 'A') {
                        ++n9;
                        continue;
                    }
                    if (c != 'T') continue;
                    ++n10;
                }
                n7 = i - n4 / 2;
                n8 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n7);
                content.setEnd(n8);
                if (n9 == 0 && n10 == 0) {
                    content.setContent(0.0);
                } else {
                    content.setContent((double)(n9 - n10) / (double)(n9 + n10));
                }
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12 = i - n3 / 2;
                int n13 = i + n3 / 2;
                int n14 = 0;
                int n15 = 0;
                if (n12 >= 1 && n13 <= stringBuffer.length()) {
                    for (int j = n12; j <= n13; ++j) {
                        char c = Character.toUpperCase(stringBuffer.charAt(j - 1));
                        if (c == 'A') {
                            ++n14;
                            continue;
                        }
                        if (c != 'T') continue;
                        ++n15;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n12 = i - n4 / 2;
                n12 = n12 < 1 ? 1 : n12;
                n13 = i + n4 / 2;
                n13 = n13 > stringBuffer.length() ? stringBuffer.length() : n13;
                Content content = new Content();
                content.setStart(n12);
                content.setEnd(n13);
                content.setEffective(bl2);
                if (n14 == 0 && n15 == 0) {
                    content.setContent(0.0);
                } else {
                    content.setContent((double)(n14 - n15) / (double)(n14 + n15));
                }
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList cumGcSkew(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        double d = 0.0;
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7 = i - n3 / 2;
                int n8 = i + n3 / 2;
                int n9 = 0;
                int n10 = 0;
                for (int j = n7; j <= n8; ++j) {
                    int n11 = DnaTool.revicePos(j, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n11 - 1));
                    if (c == 'G') {
                        ++n9;
                        continue;
                    }
                    if (c != 'C') continue;
                    ++n10;
                }
                n7 = i - n4 / 2;
                n8 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n7);
                content.setEnd(n8);
                d = n9 == 0 && n10 == 0 ? (d += 0.0) : (d += (double)(n9 - n10) / (double)(n9 + n10));
                content.setContent(d);
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12 = i - n3 / 2;
                int n13 = i + n3 / 2;
                int n14 = 0;
                int n15 = 0;
                if (n12 >= 1 && n13 <= stringBuffer.length()) {
                    for (int j = n12; j <= n13; ++j) {
                        char c = Character.toUpperCase(stringBuffer.charAt(j - 1));
                        if (c == 'G') {
                            ++n14;
                            continue;
                        }
                        if (c != 'C') continue;
                        ++n15;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n12 = i - n4 / 2;
                n12 = n12 < 1 ? 1 : n12;
                n13 = i + n4 / 2;
                n13 = n13 > stringBuffer.length() ? stringBuffer.length() : n13;
                Content content = new Content();
                content.setStart(n12);
                content.setEnd(n13);
                content.setEffective(bl2);
                d = n14 == 0 && n15 == 0 ? (d += 0.0) : (bl2 ? (d += (double)(n14 - n15) / (double)(n14 + n15)) : (d += 0.0));
                content.setContent(d);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList cumAtSkew(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        double d = 0.0;
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7 = i - n3 / 2;
                int n8 = i + n3 / 2;
                int n9 = 0;
                int n10 = 0;
                for (int j = n7; j <= n8; ++j) {
                    int n11 = DnaTool.revicePos(j, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n11 - 1));
                    if (c == 'A') {
                        ++n9;
                        continue;
                    }
                    if (c != 'T') continue;
                    ++n10;
                }
                n7 = i - n4 / 2;
                n8 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n7);
                content.setEnd(n8);
                d = n9 == 0 && n10 == 0 ? (d += 0.0) : (d += (double)(n9 - n10) / (double)(n9 + n10));
                content.setContent(d);
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                boolean bl2;
                int n12 = i - n3 / 2;
                int n13 = i + n3 / 2;
                int n14 = 0;
                int n15 = 0;
                if (n12 >= 1 && n13 <= stringBuffer.length()) {
                    for (int j = n12; j <= n13; ++j) {
                        char c = Character.toUpperCase(stringBuffer.charAt(j - 1));
                        if (c == 'A') {
                            ++n14;
                            continue;
                        }
                        if (c != 'T') continue;
                        ++n15;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                n12 = i - n4 / 2;
                n12 = n12 < 1 ? 1 : n12;
                n13 = i + n4 / 2;
                n13 = n13 > stringBuffer.length() ? stringBuffer.length() : n13;
                Content content = new Content();
                content.setStart(n12);
                content.setEnd(n13);
                content.setEffective(bl2);
                d = n14 == 0 && n15 == 0 ? (d += 0.0) : (bl2 ? (d += (double)(n14 - n15) / (double)(n14 + n15)) : (d += 0.0));
                content.setContent(d);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static ArrayList orfSearch(String string) {
        Pattern pattern = Pattern.compile("T[AG][AG]");
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find(n)) {
            n = matcher.start();
            if (!matcher.group().equals("TGG")) {
                if (n % 3 == 0) {
                    arrayList2.add(new Integer(n + 1));
                } else if (n % 3 == 1) {
                    arrayList3.add(new Integer(n + 1));
                } else {
                    arrayList4.add(new Integer(n + 1));
                }
            }
            ++n;
        }
        arrayList.add(arrayList2);
        arrayList.add(arrayList3);
        arrayList.add(arrayList4);
        String string2 = DnaTool.reverseComplement(string);
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        matcher = pattern.matcher(string2);
        n = 0;
        while (matcher.find(n)) {
            n = matcher.start();
            if (!matcher.group().equals("TGG")) {
                if (n % 3 == 0) {
                    arrayList5.add(new Integer(string.length() - n));
                } else if (n % 3 == 1) {
                    arrayList6.add(new Integer(string.length() - n));
                } else {
                    arrayList7.add(new Integer(string.length() - n));
                }
            }
            ++n;
        }
        arrayList.add(arrayList5);
        arrayList.add(arrayList6);
        arrayList.add(arrayList7);
        return arrayList;
    }

    public static ArrayList aminoAcidProfile(StringBuffer stringBuffer, int n, int n2, int n3, int n4, double d, HashMap hashMap) {
        ArrayList<Content> arrayList;
        block18: {
            double d2;
            double d3;
            block17: {
                int n5 = n % 2 == 0 ? n + 1 : n;
                double[] dArray = new double[n5];
                if (n4 == 0) {
                    for (int i = 0; i < n5; ++i) {
                        dArray[i] = 1.0;
                    }
                } else if (n5 == 1) {
                    dArray[0] = 1.0;
                } else {
                    int n6;
                    double d4 = (1.0 - d) / (double)(n5 / 2);
                    for (n6 = 0; n6 < n5 / 2; ++n6) {
                        dArray[n6] = d + d4 * (double)n6;
                    }
                    dArray[n5 / 2] = 1.0;
                    n6 = n5 - 1;
                    int n7 = 0;
                    while (n6 > n5 / 2) {
                        dArray[n6] = d + d4 * (double)n7;
                        --n6;
                        ++n7;
                    }
                }
                arrayList = new ArrayList<Content>();
                d3 = Double.MAX_VALUE;
                d2 = -2.147483648E9;
                for (int i = 1; i <= stringBuffer.length(); i += n2) {
                    int n8;
                    int n9;
                    int n10 = i - n / 2;
                    int n11 = i + n / 2;
                    double d5 = 0.0;
                    boolean bl = false;
                    if (n10 >= 1 && n11 <= stringBuffer.length()) {
                        n9 = n10;
                        n8 = 0;
                        while (n9 <= n11) {
                            char c = Character.toUpperCase(stringBuffer.charAt(n9 - 1));
                            Double d6 = (Double)hashMap.get("" + c);
                            if (d6 != null) {
                                d5 += d6 * dArray[n8];
                            }
                            ++n9;
                            ++n8;
                        }
                        Double d7 = (Double)hashMap.get("NH2");
                        if (d7 != null) {
                            d5 += d7.doubleValue();
                        }
                        if ((d7 = (Double)hashMap.get("COOH")) != null) {
                            d5 += d7.doubleValue();
                        }
                        d5 /= (double)n;
                        bl = true;
                    }
                    n9 = (n9 = i - n2 / 2) < 1 ? 1 : n9;
                    n8 = i + n2 / 2;
                    n8 = n8 > stringBuffer.length() ? stringBuffer.length() : n8;
                    Content content = new Content();
                    content.setStart(n9);
                    content.setEnd(n8);
                    content.setContent(d5);
                    content.setEffective(bl);
                    arrayList.add(content);
                    if (!bl) continue;
                    if (d3 > d5) {
                        d3 = d5;
                    }
                    if (!(d2 < d5)) continue;
                    d2 = d5;
                }
                if (n3 != 1) break block17;
                if (d3 == Double.MAX_VALUE) break block18;
                d2 -= d3;
                for (Content content : arrayList) {
                    content.setContent((content.getContent() - d3) / d2);
                }
                break block18;
            }
            if (n3 == 2 && d3 != Double.MAX_VALUE) {
                d2 -= d3;
                for (Content content : arrayList) {
                    content.setContent((content.getContent() - d3) / d2 * 2.0 - 1.0);
                }
            }
        }
        return arrayList;
    }

    public static ArrayList aminoAcidKSProfile(StringBuffer stringBuffer, int n, int n2, int n3, int n4, double d, HashMap hashMap) {
        ArrayList<Content> arrayList;
        block30: {
            double d2;
            double d3;
            block29: {
                HashMap hashMap2 = (HashMap)hashMap.get("Karplus-Schulz-1985-Chain-Flexibility(Flexible=0:Rigid=1)");
                HashMap hashMap3 = (HashMap)hashMap.get("Karplus-Schulz-1985-Chain Flexibility(B_norm0)");
                HashMap hashMap4 = (HashMap)hashMap.get("Karplus-Schulz-1985-Chain Flexibility(B_norm1)");
                HashMap hashMap5 = (HashMap)hashMap.get("Karplus-Schulz-1985-Chain Flexibility(B_norm2)");
                int n5 = n % 2 == 0 ? n + 1 : n;
                double[] dArray = new double[n5];
                if (n4 == 0) {
                    for (int i = 0; i < n5; ++i) {
                        dArray[i] = 1.0;
                    }
                } else if (n5 == 1) {
                    dArray[0] = 1.0;
                } else {
                    int n6;
                    double d4 = (1.0 - d) / (double)(n5 / 2);
                    for (n6 = 0; n6 < n5 / 2; ++n6) {
                        dArray[n6] = d + d4 * (double)n6;
                    }
                    dArray[n5 / 2] = 1.0;
                    n6 = n5 - 1;
                    int n7 = 0;
                    while (n6 > n5 / 2) {
                        dArray[n6] = d + d4 * (double)n7;
                        --n6;
                        ++n7;
                    }
                }
                arrayList = new ArrayList<Content>();
                d3 = Double.MAX_VALUE;
                d2 = -2.147483648E9;
                for (int i = 1; i <= stringBuffer.length(); i += n2) {
                    int n8;
                    int n9;
                    int n10 = i - n / 2;
                    int n11 = i + n / 2;
                    double d5 = 0.0;
                    boolean bl = false;
                    if (n10 >= 1 && n11 <= stringBuffer.length()) {
                        n9 = n10;
                        n8 = 0;
                        while (n9 <= n11) {
                            Double d6;
                            char c;
                            char c2;
                            if (n9 == 1) {
                                if (n9 + 1 <= n11) {
                                    c2 = Character.toUpperCase(stringBuffer.charAt(n9 - 1));
                                    c = Character.toUpperCase(stringBuffer.charAt(n9 + 1 - 1));
                                    Double d7 = (Double)hashMap2.get("" + c);
                                    if (d7 != null && (d6 = d7 == 0.0 ? (Double)hashMap3.get("" + c2) : (Double)hashMap5.get("" + c2)) != null) {
                                        d5 += d6 * dArray[n8];
                                    }
                                }
                            } else if (n9 == n11) {
                                if (n9 - 1 >= 1) {
                                    c2 = Character.toUpperCase(stringBuffer.charAt(n9 - 1));
                                    c = Character.toUpperCase(stringBuffer.charAt(n9 - 1 - 1));
                                    Double d8 = (Double)hashMap2.get("" + c);
                                    if (d8 != null && (d6 = d8 == 0.0 ? (Double)hashMap3.get("" + c2) : (Double)hashMap5.get("" + c2)) != null) {
                                        d5 += d6 * dArray[n8];
                                    }
                                }
                            } else {
                                Double d9;
                                c2 = Character.toUpperCase(stringBuffer.charAt(n9 - 1));
                                c = Character.toUpperCase(stringBuffer.charAt(n9 - 1 - 1));
                                char c3 = Character.toUpperCase(stringBuffer.charAt(n9 + 1 - 1));
                                d6 = (Double)hashMap2.get("" + c);
                                Double d10 = (Double)hashMap2.get("" + c3);
                                if (d6 != null && d10 != null) {
                                    d9 = d6 == 0.0 && d10 == 0.0 ? (Double)hashMap3.get("" + c2) : (d6 == 1.0 && d10 == 1.0 ? (Double)hashMap5.get("" + c2) : (Double)hashMap4.get("" + c2));
                                    if (d9 != null) {
                                        d5 += d9 * dArray[n8];
                                    }
                                } else if (d6 != null) {
                                    d9 = d6 == 0.0 ? (Double)hashMap3.get("" + c2) : (Double)hashMap5.get("" + c2);
                                    if (d9 != null) {
                                        d5 += d9 * dArray[n8];
                                    }
                                } else if (d10 != null && (d9 = d10 == 0.0 ? (Double)hashMap3.get("" + c2) : (Double)hashMap5.get("" + c2)) != null) {
                                    d5 += d9 * dArray[n8];
                                }
                            }
                            ++n9;
                            ++n8;
                        }
                        d5 /= (double)n;
                        bl = true;
                    }
                    n9 = (n9 = i - n2 / 2) < 1 ? 1 : n9;
                    n8 = i + n2 / 2;
                    n8 = n8 > stringBuffer.length() ? stringBuffer.length() : n8;
                    Content content = new Content();
                    content.setStart(n9);
                    content.setEnd(n8);
                    content.setContent(d5);
                    content.setEffective(bl);
                    arrayList.add(content);
                    if (!bl) continue;
                    if (d3 > d5) {
                        d3 = d5;
                    }
                    if (!(d2 < d5)) continue;
                    d2 = d5;
                }
                if (n3 != 1) break block29;
                if (d3 == Double.MAX_VALUE) break block30;
                d2 -= d3;
                for (Content content : arrayList) {
                    content.setContent((content.getContent() - d3) / d2);
                }
                break block30;
            }
            if (n3 == 2 && d3 != Double.MAX_VALUE) {
                d2 -= d3;
                for (Content content : arrayList) {
                    content.setContent((content.getContent() - d3) / d2 * 2.0 - 1.0);
                }
            }
        }
        return arrayList;
    }

    private static int revicePos(int n, int n2) {
        block3: {
            block2: {
                if (n >= 1) break block2;
                while ((n += n2) < 1) {
                }
                break block3;
            }
            if (n <= n2) break block3;
            while ((n -= n2) > n2) {
            }
        }
        return n;
    }

    public static ArrayList fickett(StringBuffer stringBuffer, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 < 1 ? 1 : (n3 = n3 > stringBuffer.length() ? stringBuffer.length() : n3);
        n4 = n4 < 1 ? 1 : (n4 > stringBuffer.length() ? stringBuffer.length() : n4);
        int n6 = n + n2 - 1;
        ArrayList<Content> arrayList = new ArrayList<Content>();
        if (bl) {
            for (int i = n; i <= n6; i += n4) {
                int n7 = i - n3 / 2;
                int n8 = i + n3 / 2;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                for (int j = n7; j <= n8; ++j) {
                    int n21 = DnaTool.revicePos(j, stringBuffer.length());
                    char c = Character.toUpperCase(stringBuffer.charAt(n21 - 1));
                    if (n21 % 3 == 1) {
                        if (c == 'A') {
                            ++n9;
                            continue;
                        }
                        if (c == 'C') {
                            ++n12;
                            continue;
                        }
                        if (c == 'G') {
                            ++n15;
                            continue;
                        }
                        if (c != 'T') continue;
                        ++n18;
                        continue;
                    }
                    if (n21 % 3 == 2) {
                        if (c == 'A') {
                            ++n10;
                            continue;
                        }
                        if (c == 'C') {
                            ++n13;
                            continue;
                        }
                        if (c == 'G') {
                            ++n16;
                            continue;
                        }
                        if (c != 'T') continue;
                        ++n19;
                        continue;
                    }
                    if (c == 'A') {
                        ++n11;
                        continue;
                    }
                    if (c == 'C') {
                        ++n14;
                        continue;
                    }
                    if (c == 'G') {
                        ++n17;
                        continue;
                    }
                    if (c != 'T') continue;
                    ++n20;
                }
                double d = (double)Math.max(Math.max(n9, n10), n11) / (double)(Math.min(Math.min(n9, n10), n11) + 1);
                double d2 = (double)(n9 + n10 + n11) / (double)(n8 - n7 - 1);
                double d3 = (double)Math.max(Math.max(n12, n13), n14) / (double)(Math.min(Math.min(n12, n13), n14) + 1);
                double d4 = (double)(n12 + n13 + n14) / (double)(n8 - n7 - 1);
                double d5 = (double)Math.max(Math.max(n15, n16), n17) / (double)(Math.min(Math.min(n15, n16), n17) + 1);
                double d6 = (double)(n15 + n16 + n17) / (double)(n8 - n7 - 1);
                double d7 = (double)Math.max(Math.max(n18, n19), n20) / (double)(Math.min(Math.min(n18, n19), n20) + 1);
                double d8 = (double)(n18 + n19 + n20) / (double)(n8 - n7 - 1);
                double d9 = 0.26 * d + 0.18 * d3 + 0.31 * d5 + 0.33 * d7 + 0.11 * d2 + 0.12 * d4 + 0.15 * d6 + 0.14 * d8;
                int n22 = i - n4 / 2;
                int n23 = i + n4 / 2;
                Content content = new Content();
                content.setStart(n22);
                content.setEnd(n23);
                content.setContent(d9);
                arrayList.add(content);
            }
        } else {
            for (int i = n; i <= n6; i += n4) {
                double d;
                boolean bl2;
                int n24 = i - n3 / 2;
                int n25 = i + n3 / 2;
                int n26 = 0;
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                int n32 = 0;
                int n33 = 0;
                int n34 = 0;
                int n35 = 0;
                int n36 = 0;
                int n37 = 0;
                if (n24 >= 1 && n25 <= stringBuffer.length()) {
                    for (int j = n24; j <= n25; ++j) {
                        char c = Character.toUpperCase(stringBuffer.charAt(j - 1));
                        if (j % 3 == 1) {
                            if (c == 'A') {
                                ++n26;
                                continue;
                            }
                            if (c == 'C') {
                                ++n29;
                                continue;
                            }
                            if (c == 'G') {
                                ++n32;
                                continue;
                            }
                            if (c != 'T') continue;
                            ++n35;
                            continue;
                        }
                        if (j % 3 == 2) {
                            if (c == 'A') {
                                ++n27;
                                continue;
                            }
                            if (c == 'C') {
                                ++n30;
                                continue;
                            }
                            if (c == 'G') {
                                ++n33;
                                continue;
                            }
                            if (c != 'T') continue;
                            ++n36;
                            continue;
                        }
                        if (c == 'A') {
                            ++n28;
                            continue;
                        }
                        if (c == 'C') {
                            ++n31;
                            continue;
                        }
                        if (c == 'G') {
                            ++n34;
                            continue;
                        }
                        if (c != 'T') continue;
                        ++n37;
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    double d10 = (double)Math.max(Math.max(n26, n27), n28) / (double)(Math.min(Math.min(n26, n27), n28) + 1);
                    double d11 = (double)(n26 + n27 + n28) / (double)(n25 - n24 - 1);
                    double d12 = (double)Math.max(Math.max(n29, n30), n31) / (double)(Math.min(Math.min(n29, n30), n31) + 1);
                    double d13 = (double)(n29 + n30 + n31) / (double)(n25 - n24 - 1);
                    double d14 = (double)Math.max(Math.max(n32, n33), n34) / (double)(Math.min(Math.min(n32, n33), n34) + 1);
                    double d15 = (double)(n32 + n33 + n34) / (double)(n25 - n24 - 1);
                    double d16 = (double)Math.max(Math.max(n35, n36), n37) / (double)(Math.min(Math.min(n35, n36), n37) + 1);
                    double d17 = (double)(n35 + n36 + n37) / (double)(n25 - n24 - 1);
                    d = 0.26 * d10 + 0.18 * d12 + 0.31 * d14 + 0.33 * d16 + 0.11 * d11 + 0.12 * d13 + 0.15 * d15 + 0.14 * d17;
                } else {
                    d = 0.0;
                }
                int n38 = i - n4 / 2;
                n38 = n38 < 1 ? 1 : n38;
                int n39 = i + n4 / 2;
                n39 = n39 > stringBuffer.length() ? stringBuffer.length() : n39;
                Content content = new Content();
                content.setStart(n38);
                content.setEnd(n39);
                content.setContent(d);
                content.setEffective(bl2);
                arrayList.add(content);
            }
        }
        return arrayList;
    }

    public static double orfFickett(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 1; i <= stringBuffer.length(); ++i) {
            char c = Character.toUpperCase(stringBuffer.charAt(i - 1));
            if (i % 3 == 1) {
                if (c == 'A') {
                    ++n;
                    continue;
                }
                if (c == 'C') {
                    ++n4;
                    continue;
                }
                if (c == 'G') {
                    ++n7;
                    continue;
                }
                if (c != 'T') continue;
                ++n10;
                continue;
            }
            if (i % 3 == 2) {
                if (c == 'A') {
                    ++n2;
                    continue;
                }
                if (c == 'C') {
                    ++n5;
                    continue;
                }
                if (c == 'G') {
                    ++n8;
                    continue;
                }
                if (c != 'T') continue;
                ++n11;
                continue;
            }
            if (c == 'A') {
                ++n3;
                continue;
            }
            if (c == 'C') {
                ++n6;
                continue;
            }
            if (c == 'G') {
                ++n9;
                continue;
            }
            if (c != 'T') continue;
            ++n12;
        }
        double d = (double)Math.max(Math.max(n, n2), n3) / (double)(Math.min(Math.min(n, n2), n3) + 1);
        double d2 = (double)(n + n2 + n3) / (double)stringBuffer.length();
        double d3 = (double)Math.max(Math.max(n4, n5), n6) / (double)(Math.min(Math.min(n4, n5), n6) + 1);
        double d4 = (double)(n4 + n5 + n6) / (double)stringBuffer.length();
        double d5 = (double)Math.max(Math.max(n7, n8), n9) / (double)(Math.min(Math.min(n7, n8), n9) + 1);
        double d6 = (double)(n7 + n8 + n9) / (double)stringBuffer.length();
        double d7 = (double)Math.max(Math.max(n10, n11), n12) / (double)(Math.min(Math.min(n10, n11), n12) + 1);
        double d8 = (double)(n10 + n11 + n12) / (double)stringBuffer.length();
        double d9 = 0.26 * d + 0.18 * d3 + 0.31 * d5 + 0.33 * d7 + 0.11 * d2 + 0.12 * d4 + 0.15 * d6 + 0.14 * d8;
        return d9;
    }
}

