/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.data.RankDif;
import java.util.HashSet;
import java.util.Set;

public class DefaultOptionValues {
    public static final int TAX_SETTING_TREE_TYPE = 1;
    public static final boolean TAX_SETTING_NORANK = false;
    public static final boolean TAX_SETTING_TOP_LEVEL = false;
    public static final boolean TAX_SETTING_SUPERKINGDOM = true;
    public static final boolean TAX_SETTING_KINGDOM = false;
    public static final boolean TAX_SETTING_SUPERPHYLUM = false;
    public static final boolean TAX_SETTING_PHYLUM = true;
    public static final boolean TAX_SETTING_SUBPHYLUM = false;
    public static final boolean TAX_SETTING_CLASS = true;
    public static final boolean TAX_SETTING_SUBCLASS = false;
    public static final boolean TAX_SETTING_ORDER = true;
    public static final boolean TAX_SETTING_SUBORDER = false;
    public static final boolean TAX_SETTING_FAMILY = true;
    public static final boolean TAX_SETTING_TRIBE = false;
    public static final boolean TAX_SETTING_GENUS = true;
    public static final boolean TAX_SETTING_SPCIESGROUP = false;
    public static final boolean TAX_SETTING_SPECIES = true;
    public static final String TAX_SETTING_RANK_ITEMS = "class, order, family, genus, species";
    public static final String TAX_SETTING_INGROUP_FONT_COLOR = "#0000ff";
    public static final String TAX_SETTING_OUTGROUP_FONT_COLOR = "#ff0000";
    public static final boolean PPM_SETTING_GENE_COUNT_COLOR_FLAG = false;
    public static final int PPM_SETTING_GENE_COUNT_COLOR_MIN_COUNT = 2;
    public static final String PPM_SETTING_GENE_COUNT_COLOR = "#ffa000";
    public static final boolean PPM_SETTING_GENE_NAME_VIEW = true;
    public static final boolean PPM_SETTING_BORDER_LINE_FLAG = true;
    public static final String PPM_SETTING_BORDER_LINE_COLOR = "#D3D3D3";
    public static final String PPM_SETTING_INGROUP_BACKGROUND_COLOR = "#008000";
    public static final String PPM_SETTING_OUTGROUP_BACKGROUND_COLOR = "#00FFFF";
    public static final String PPM_SETTING_OUTERGROUP_BACKGROUND_COLOR = "#9999FF";
    public static final boolean PPM_SETTING_OUTGROUP_AS_INGROUP_BACKGROUND_FLAG = false;
    public static final String PPM_SETTING_OUTGROUP_AS_INGROUP_BACKGROUND_COLOR = "#FF4500";
    public static final String PPM_SETTING_SELECT_LINE_COLOR1 = "#800000";
    public static final String PPM_SETTING_SELECT_LINE_COLOR2 = "#e06060";
    public static final String PPM_SETTING_SEARCH_RESULT_COLOR = "#ff66ff";
    public static final String CLUSTALW_SETTING_TYPE = "Use default";
    public static final String CLUSTALW_SETTING_OUTPUT = "clustal";
    public static final String CLUSTALW_SETTING_OUTORDER = "aligned";
    public static final String CLUSTALW_SETTING_MATRIX = "blosum";
    public static final String CLUSTALW_SETTING_SEQNO_RANGE = "OFF";
    public static final int CLUSTALW_SETTING_SEQNO_START = Integer.MIN_VALUE;
    public static final int CLUSTALW_SETTING_SEQNO_LENGTH = Integer.MIN_VALUE;
    public static final double CLUSTALW_SETTING_GAPOPEN = 10.0;
    public static final double CLUSTALW_SETTING_GAPEXT = 0.2;
    public static final int CLUSTALW_SETTING_GAPDIST = 8;
    public static final int CLUSTALW_SETTING_MAXDIV = 40;
    public static final String CLUSTALW_SETTING_ENDGAP = "OFF";
    public static final String CLUSTALW_SETTING_NOPGAP = "OFF";
    public static final String CLUSTALW_SETTING_NOHGAP = "OFF";
    public static final String CLUSTALW_SETTING_QUICKTREE = "OFF";
    public static final int CLUSTALW_SETTING_KTUPLE = 1;
    public static final int CLUSTALW_SETTING_WINDOW = 5;
    public static final String CLUSTALW_SETTING_SCORE = "percent";
    public static final int CLUSTALW_SETTING_TOPDIAGS = 5;
    public static final int CLUSTALW_SETTING_PAIRGAP = 3;
    public static final String CLUSTALW_SETTING_PWDNAMATRIX = "blosum";
    public static final double CLUSTALW_SETTING_PWGAPOPEN = 10.0;
    public static final double CLUSTALW_SETTING_PWGAPEXT = 0.1;
    public static final String CLUSTALW_SETTING_KIMURA = "ON";
    public static final String CLUSTALW_SETTING_TOSSGAPS = "ON";
    public static final String CLUSTALW_SETTING_OUTPUTTREE = "phylip";
    public static final String CLUSTALW_SETTING_BOOTSTRAP = "ON";
    public static final int CLUSTALW_SETTING_COUNT = 1000;
    public static final int CLUSTALW_SETTING_SEED = 111;
    public static final String GENE_ANNOTATION_URL = "/htbin/RECOG/RECOG_gene_info_frame.pl?spec=#1&name=#2&tabid=#3";
    public static final String CLUSTER_ANNOTATION_URL = "/htbin/RECOG/hcluster?prog=hcluster&clustid=#1&tabid=#2";
    public static final String SEQ_DOWNLOAD_URL = "/htbin/RECOG/hcluster";
    public static final String TAX_MAP_DOWNLOAD_URL = "/htbin/RECOG/view_taxmap.cgi";
    public static final int CALC_MULTI_GENE_TYPE = 1;
    public static final int CALC_MULTI_INFO_TYPE = 1;
    public static final int CALC_MULTI_CLUSTER_TYPE = 1;
    public static final boolean CALC_MULTI_GENE_AVE = false;
    public static final boolean CALC_MULTI_INFO_AVE = false;
    public static final boolean CALC_MULTI_CLUSTER_AVE = false;
    public static final int CALC_NA_INFO_TYPE = 2;
    public static final double CALC_NA_INFO_SPEC_VALUE = 0.0;
    public static final int CALC_NA_GENE_TYPE = 1;
    public static final double CALC_NA_GENE_SPEC_VALUE = 0.0;
    public static final boolean SHOW_VERSION_UP = true;
    public static final boolean SHOW_HIDDEN_MENU = false;
    public static final String PUBLIC_COLOR = "#8B0000";
    public static final Set ENABLE_DOMCLUST_PARAM = new HashSet();

    private DefaultOptionValues() {
    }

    public static boolean isDefaultTaxTreeRankSelected(String string) {
        if (RankDif.isSuperkingdom(string)) {
            return true;
        }
        if (RankDif.isKingdom(string)) {
            return false;
        }
        if (RankDif.isSuperphylum(string)) {
            return false;
        }
        if (RankDif.isPhylum(string)) {
            return true;
        }
        if (RankDif.isSubphylum(string)) {
            return false;
        }
        if (RankDif.isOrder(string)) {
            return true;
        }
        if (RankDif.isSuborder(string)) {
            return false;
        }
        if (RankDif.isClass(string)) {
            return true;
        }
        if (RankDif.isSubclass(string)) {
            return false;
        }
        if (RankDif.isFamily(string)) {
            return true;
        }
        if (RankDif.isGenus(string)) {
            return true;
        }
        if (RankDif.isSpeciesGroup(string)) {
            return false;
        }
        if (RankDif.isSpecies(string)) {
            return true;
        }
        if (RankDif.isNoRank(string)) {
            return false;
        }
        return false;
    }

    static {
        ENABLE_DOMCLUST_PARAM.add(new Integer(1));
        ENABLE_DOMCLUST_PARAM.add(new Integer(2));
        ENABLE_DOMCLUST_PARAM.add(new Integer(7));
        ENABLE_DOMCLUST_PARAM.add(new Integer(13));
    }
}

