/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.data.RankComparator;
import cgdp.recog.data.RankDif;
import cgdp.recog.neighbor.NeighborClustPPMColor;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.option.DefaultOptionValues;
import cgdp.recog.taxonomy.TaxTreeShowType;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class OptionValues
implements Serializable {
    private static final String DEFAULT_GET_DATA_URL = "/htbin/RECOG/getData";
    private static final String DEFAULT_DOMCLUST_URL = "/htbin/RECOG/domclust.cgi";
    private static final String DEFAULT_DOMCLUST_KILL_URL = "/htbin/RECOG/kill_cluster.cgi";
    private static final boolean DEFAULT_SHOW_TREE_DIST_FROM_UPGMA = false;
    private static final String DEFAULT_CORE_GENOME_URL = "/htbin/RECOG/CoreAligner";
    private static final String DEFAULT_UPGMA_URL = "/htbin/RECOG/phylopatCluster";
    private static final String DEFAULT_UPDATE_SITE_URL = "http://mbgd.genome.ad.jp/RECOG/";
    private static final String DEFAULT_SYS_INFO_URL = "/htbin/RECOG/sysinfo";
    private static final long DEFAULT_UPDATE_CHECK_INTERVAL = 86400000L;
    private static final String DEFAULT_ERROR_UPLOAD_URL = "http://mbgd.genome.ad.jp/htbin/RECOG/upload_error_report.cgi";
    private static final String DEFAULT_SERVER_LOG_DOWNLOAD_URL = "/htbin/RECOG/download_error_report.cgi";
    private static final String DEFAULT_GENOMEMAP_POSITIVE_COLOR = ColorUtil.color2Str(new Color(192, 192, 255));
    private static final String DEFAULT_GENOMEMAP_NEGATIVE_COLOR = ColorUtil.color2Str(new Color(255, 192, 192));
    private static final String DEFAULT_CLIENT_VERSION_URL = "/RECOG/dist/client/version";
    private static final String OLD_GENE_ANNOTATION_URL = "/htbin/RECOG/RECOG_gene_info_frame.pl?spec=%%%NAME%%%&name=%%%GENE%%%";
    private String userImportDir;
    private String userExportDir;
    private boolean intensive;
    private boolean clusterMode;
    String m_clusterTreeUrl;
    String m_geneInfoUrl;
    private String geneAnnotationUrl;
    private String clusterAnnotationUrl;
    String m_funcCatUrl;
    private String functionCategoryType;
    String m_naUrl;
    String m_aaUrl;
    String m_domainUrl;
    int m_mainWindowX;
    int m_mainWindowY;
    int m_mainWindowW;
    int m_mainWindowH;
    int m_dividerLocation1;
    int m_dividerLocation2;
    int m_dividerLocation3;
    int m_dividerLocation4;
    int m_dividerLocation5;
    String m_clusterFrom;
    String m_clusterTo;
    int m_clusterCount;
    int m_alignmentFrameX;
    int m_alignmentFrameY;
    int m_alignmentFrameW;
    int m_alignmentFrameH;
    String m_clustalW;
    int m_multiFrameX;
    int m_multiFrameY;
    int m_multiFrameW;
    int m_multiFrameH;
    boolean m_syncPPMFilter;
    private int m_treeType;
    private boolean m_noRank;
    private boolean m_top_level;
    private boolean m_superKingdom;
    private boolean m_kingdom;
    private boolean m_superPhylum;
    private boolean m_phylum;
    private boolean m_subPhylum;
    private boolean m_class_;
    private boolean m_subClass_;
    private boolean m_order;
    private boolean m_subOrder;
    private boolean m_family;
    private boolean m_tribe;
    private boolean m_genus;
    private boolean spciesGroup;
    private boolean m_species;
    private String rankItems;
    private String ingroupFontColor;
    private String outgroupFontColor;
    int m_genomeMapX;
    int m_genomeMapY;
    int m_genomeMapW;
    int m_genomeMapH;
    private String m_domClustUrl;
    private String domClustKillUrl;
    private String domClustConditionName;
    String m_clustalWOpt_TYPE;
    String m_clustalWOpt_OUTPUT;
    String m_clustalWOpt_ORDER;
    String m_clustalWOpt_MATRIX;
    String m_clustalWOpt_RANGE;
    int m_clustalWOpt_START;
    int m_clustalWOpt_LENGTH;
    double m_clustalWOpt_OPEN;
    double m_clustalWOpt_EXT;
    int m_clustalWOpt_DIST;
    int m_clustalWOpt_DIV;
    String m_clustalWOpt_END;
    String m_clustalWOpt_NOP;
    String m_clustalWOpt_NOH;
    String m_clustalWOpt_TREE;
    int m_clustalWOpt_KTUPLE;
    int m_clustalWOpt_WINDOW;
    String m_clustalWOpt_SCORE;
    int m_clustalWOpt_TOP;
    int m_clustalWOpt_PAIR;
    String m_clustalWOpt_PWM;
    double m_clustalWOpt_PWO;
    double m_clustalWOpt_PWE;
    String m_clustalWOpt_KIMURA;
    String m_clustalWOpt_TOSS;
    String m_clustalWOpt_OTREE;
    String m_clustalWOpt_BS;
    int m_clustalWOpt_COUNT;
    int m_clustalWOpt_SEED;
    int m_geneFrameX;
    int m_geneFrameY;
    int m_geneFrameW;
    int m_geneFrameH;
    String m_csvDir;
    private String m_getDataUrl;
    boolean m_expand;
    String m_zoomIn2;
    String m_zoomOut2;
    int m_minClusterH;
    int m_minClusterW;
    int m_prevMinClusterH;
    int m_prevMinClusterW;
    String m_movePrev;
    String m_moveNext;
    private boolean geneCountColorFlag = true;
    private int geneCountColorMinCount;
    private String geneCountColor;
    private boolean geneNameView;
    private boolean borderLineView;
    boolean m_taxonomyView;
    boolean m_functionView;
    int m_lastDividerLocation1;
    int m_lastDividerLocation2;
    private String borderLineColorString;
    private String outgroupColorString;
    private String ingroupColorString;
    private String outergroupColorString;
    private boolean outgroupAsIngroupFlag;
    private String outgroupIngroupColorString;
    private String selectLine1ColorString;
    private String selectLine2ColorString;
    private String searchResultColorString;
    private String updateSiteURL = "http://mbgd.genome.ad.jp/RECOG/";
    private String sysInfoURL = "/htbin/RECOG/sysinfo";
    private String errorUploadURL = "http://mbgd.genome.ad.jp/htbin/RECOG/upload_error_report.cgi";
    private String serverLogDownloadURL = "/htbin/RECOG/download_error_report.cgi";
    private long updateCheckInterval = 86400000L;
    private String upgmaUrl;
    private boolean showTreeDistFromUpgma;
    private String coreGenomeUrl;
    private CoreGenomeAlignmentCondition coreGenomeAlignmentCondition;
    private NeighboringClustCondition neighboringClustCondition;
    private List neighborColorPatternList;
    private String seqDownloadURL;
    private String taxMapDownloadURL;
    private String clientVersionUrl;
    private boolean showVersionUp;
    private static final int DEFAULT_CLUSTER_MAP_V_PAGE_STEP_SIZE = 6;
    private static final int DEFAULT_CLUSTER_MAP_V_SCROLL_STEP_SIZE = 1;
    private static final int DEFAULT_CLUSTER_MAP_H_SCROLL_STEP_SIZE = 1;
    private int m_clusterMapVPageStepSize = 6;
    private int m_clusterMapVScrollStepSize = 1;
    private int m_clusterMapHScrollStepSize = 1;
    private boolean showHiddenMenu;
    private String publicColor;
    private Set enableDomclustParam;

    public OptionValues() {
        this.clear();
    }

    private void clear() {
        this.userImportDir = "";
        this.userExportDir = "";
        this.intensive = true;
        this.clusterMode = true;
        this.m_clusterTreeUrl = "/htbin/hcluster?prog=hcluster&clustid=%%%CLUSTER_ID%%%&tabid=default";
        this.m_geneInfoUrl = "/htbin/RECOG/getData?table=gene&key=%%%NAME%%%:%%%GENE%%%";
        this.geneAnnotationUrl = "/htbin/RECOG/RECOG_gene_info_frame.pl?spec=#1&name=#2&tabid=#3";
        this.clusterAnnotationUrl = "/htbin/RECOG/hcluster?prog=hcluster&clustid=#1&tabid=#2";
        this.m_funcCatUrl = "/htbin/RECOG/getData?table=category&dbname=mbgd";
        this.functionCategoryType = "mbgd";
        this.m_syncPPMFilter = false;
        this.m_naUrl = "/htbin/RECOG/getData?table=geneseq&key=%%%NAME%%%:%%%GENE%%%";
        this.m_aaUrl = "/htbin/RECOG/getData?table=proteinseq&key=%%%NAME%%%:%%%GENE%%%";
        this.m_domainUrl = "/htbin/searchMotifByGene.pl?name=%%%NAME%%%:%%%GENE%%%";
        this.m_mainWindowX = 0;
        this.m_mainWindowY = 0;
        this.m_mainWindowW = 0;
        this.m_mainWindowH = 0;
        this.m_dividerLocation1 = Integer.MIN_VALUE;
        this.m_dividerLocation2 = Integer.MIN_VALUE;
        this.m_dividerLocation3 = Integer.MIN_VALUE;
        this.m_dividerLocation4 = Integer.MIN_VALUE;
        this.m_dividerLocation5 = Integer.MIN_VALUE;
        this.m_clusterFrom = "#0000ff";
        this.m_clusterTo = "#ff0000";
        this.m_clusterCount = 65536;
        this.m_alignmentFrameX = 0;
        this.m_alignmentFrameY = 0;
        this.m_alignmentFrameW = 0;
        this.m_alignmentFrameH = 0;
        this.m_clustalW = "";
        this.m_multiFrameX = 0;
        this.m_multiFrameY = 0;
        this.m_multiFrameW = 0;
        this.m_multiFrameH = 0;
        this.m_treeType = 1;
        this.m_top_level = false;
        this.m_superKingdom = true;
        this.m_noRank = false;
        this.m_kingdom = false;
        this.m_superPhylum = false;
        this.m_phylum = true;
        this.m_subPhylum = false;
        this.m_class_ = true;
        this.m_subClass_ = false;
        this.m_order = true;
        this.m_subOrder = false;
        this.m_family = true;
        this.m_tribe = false;
        this.m_genus = true;
        this.spciesGroup = false;
        this.m_species = true;
        this.ingroupFontColor = "#0000ff";
        this.outgroupFontColor = "#ff0000";
        this.rankItems = "class, order, family, genus, species";
        this.m_genomeMapX = 0;
        this.m_genomeMapY = 0;
        this.m_genomeMapW = 0;
        this.m_genomeMapH = 0;
        this.m_domClustUrl = DEFAULT_DOMCLUST_URL;
        this.domClustKillUrl = DEFAULT_DOMCLUST_KILL_URL;
        this.m_clustalWOpt_TYPE = "Use default";
        this.m_clustalWOpt_OUTPUT = "clustal";
        this.m_clustalWOpt_ORDER = "aligned";
        this.m_clustalWOpt_MATRIX = "blosum";
        this.m_clustalWOpt_RANGE = "OFF";
        this.m_clustalWOpt_START = Integer.MIN_VALUE;
        this.m_clustalWOpt_LENGTH = Integer.MIN_VALUE;
        this.m_clustalWOpt_OPEN = 10.0;
        this.m_clustalWOpt_EXT = 0.2;
        this.m_clustalWOpt_DIST = 8;
        this.m_clustalWOpt_DIV = 40;
        this.m_clustalWOpt_END = "OFF";
        this.m_clustalWOpt_NOP = "OFF";
        this.m_clustalWOpt_NOH = "OFF";
        this.m_clustalWOpt_TREE = "OFF";
        this.m_clustalWOpt_KTUPLE = 1;
        this.m_clustalWOpt_WINDOW = 5;
        this.m_clustalWOpt_SCORE = "percent";
        this.m_clustalWOpt_TOP = 5;
        this.m_clustalWOpt_PAIR = 3;
        this.m_clustalWOpt_PWM = "blosum";
        this.m_clustalWOpt_PWO = 10.0;
        this.m_clustalWOpt_PWE = 0.1;
        this.m_clustalWOpt_KIMURA = "ON";
        this.m_clustalWOpt_TOSS = "ON";
        this.m_clustalWOpt_OTREE = "phylip";
        this.m_clustalWOpt_BS = "ON";
        this.m_clustalWOpt_COUNT = 1000;
        this.m_clustalWOpt_SEED = 111;
        this.m_geneFrameX = 0;
        this.m_geneFrameY = 0;
        this.m_geneFrameW = 0;
        this.m_geneFrameH = 0;
        this.m_csvDir = "";
        this.m_getDataUrl = DEFAULT_GET_DATA_URL;
        this.m_expand = true;
        this.m_zoomIn2 = "X2";
        this.m_zoomOut2 = "X2";
        this.m_minClusterH = 5;
        this.m_minClusterW = 30;
        this.m_prevMinClusterH = this.m_minClusterH;
        this.m_prevMinClusterW = this.m_minClusterW;
        this.m_movePrev = "1/2";
        this.m_moveNext = "1/2";
        this.geneCountColorFlag = false;
        this.geneCountColorMinCount = 2;
        this.geneCountColor = "#ffa000";
        this.geneNameView = true;
        this.borderLineView = true;
        this.m_taxonomyView = true;
        this.m_functionView = true;
        this.m_lastDividerLocation1 = Integer.MIN_VALUE;
        this.m_lastDividerLocation2 = Integer.MIN_VALUE;
        this.borderLineColorString = "#D3D3D3";
        this.outgroupColorString = "#00FFFF";
        this.ingroupColorString = "#008000";
        this.outergroupColorString = "#9999FF";
        this.outgroupAsIngroupFlag = false;
        this.outgroupIngroupColorString = "#FF4500";
        this.selectLine1ColorString = "#800000";
        this.selectLine2ColorString = "#e06060";
        this.searchResultColorString = "#ff66ff";
        this.showTreeDistFromUpgma = false;
        this.coreGenomeUrl = DEFAULT_CORE_GENOME_URL;
        this.coreGenomeAlignmentCondition = new CoreGenomeAlignmentCondition();
        this.neighboringClustCondition = new NeighboringClustCondition();
        this.upgmaUrl = DEFAULT_UPGMA_URL;
        this.domClustConditionName = "<<Last Parameters>>";
        this.neighborColorPatternList = NeighborClustPPMColor.getDefaultColorStrPatternList();
        this.clientVersionUrl = DEFAULT_CLIENT_VERSION_URL;
        this.showVersionUp = true;
        this.seqDownloadURL = "/htbin/RECOG/hcluster";
        this.taxMapDownloadURL = "/htbin/RECOG/view_taxmap.cgi";
        this.showHiddenMenu = false;
        this.publicColor = "#8B0000";
        this.enableDomclustParam = DefaultOptionValues.ENABLE_DOMCLUST_PARAM;
    }

    public void setUserImportDir(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.userImportDir = string;
    }

    public void setIntensive(boolean bl) {
        this.intensive = bl;
    }

    public void setClusterMode(boolean bl) {
        this.clusterMode = bl;
    }

    public void setClusterTreeUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_clusterTreeUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_clusterTreeUrl = string;
        }
    }

    public void setGeneInfoUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_geneInfoUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_geneInfoUrl = string;
        }
        if (this.m_geneInfoUrl.indexOf("MBGD_gene_info") != -1) {
            this.m_geneInfoUrl = "/htbin/RECOG/getData?table=gene&key=%%%NAME%%%:%%%GENE%%%";
        }
    }

    public void setGeneAnnotationUrl(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        if (string.equals(OLD_GENE_ANNOTATION_URL)) {
            return;
        }
        this.geneAnnotationUrl = string;
    }

    public void setClusterAnnotationUrl(String string) {
        this.clusterAnnotationUrl = string;
    }

    public void setFuncCatUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_funcCatUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_funcCatUrl = string;
        }
        if (this.m_funcCatUrl.indexOf("funccat_univ") != -1) {
            this.m_funcCatUrl = "/htbin/RECOG/getData?table=category&dbname=mbgd";
        }
    }

    public void setFunctionCategoryType(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.functionCategoryType = string;
    }

    public void setSyncPPMFilter(boolean bl) {
        this.m_syncPPMFilter = bl;
    }

    public void setNaUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_naUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_naUrl = string;
        }
        if (this.m_naUrl.indexOf("hcluster") != -1) {
            this.m_naUrl = "/htbin/RECOG/getData?table=geneseq&key=%%%NAME%%%:%%%GENE%%%";
        }
    }

    public void setAaUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_aaUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_aaUrl = string;
        }
        if (this.m_aaUrl.indexOf("hcluster") != -1) {
            this.m_aaUrl = "/htbin/RECOG/getData?table=proteinseq&key=%%%NAME%%%:%%%GENE%%%";
        }
    }

    public void setDomainUrl(String string) {
        if (string.startsWith("http")) {
            try {
                this.m_domainUrl = new URL(string).getFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_domainUrl = string;
        }
    }

    public void setMainWindowX(int n) {
        this.m_mainWindowX = n;
    }

    public void setMainWindowY(int n) {
        this.m_mainWindowY = n;
    }

    public void setMainWindowW(int n) {
        this.m_mainWindowW = n;
    }

    public void setMainWindowH(int n) {
        this.m_mainWindowH = n;
    }

    public void setDividerLocation1(int n) {
        this.m_dividerLocation1 = n;
    }

    public void setDividerLocation2(int n) {
        this.m_dividerLocation2 = n;
    }

    public void setDividerLocation3(int n) {
        this.m_dividerLocation3 = n;
    }

    public void setDividerLocation4(int n) {
        this.m_dividerLocation4 = n;
    }

    public void setDividerLocation5(int n) {
        this.m_dividerLocation5 = n;
    }

    public void setClusterFrom(String string) {
        this.m_clusterFrom = string;
    }

    public void setClusterTo(String string) {
        this.m_clusterTo = string;
    }

    public void setClusterCount(int n) {
        this.m_clusterCount = n;
    }

    public void setAlignmentFrameX(int n) {
        this.m_alignmentFrameX = n;
    }

    public void setAlignmentFrameY(int n) {
        this.m_alignmentFrameY = n;
    }

    public void setAlignmentFrameW(int n) {
        this.m_alignmentFrameW = n;
    }

    public void setAlignmentFrameH(int n) {
        this.m_alignmentFrameH = n;
    }

    public void setClustalW(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.m_clustalW = string;
    }

    public void setMultiFrameX(int n) {
        this.m_multiFrameX = n;
    }

    public void setMultiFrameY(int n) {
        this.m_multiFrameY = n;
    }

    public void setMultiFrameW(int n) {
        this.m_multiFrameW = n;
    }

    public void setMultiFrameH(int n) {
        this.m_multiFrameH = n;
    }

    public void setTreeType(int n) {
        this.m_treeType = n;
    }

    public void setTopLevel(boolean bl) {
        this.m_top_level = bl;
    }

    public void setSuperKingdom(boolean bl) {
        this.m_superKingdom = bl;
    }

    public void setNoRank(boolean bl) {
        this.m_noRank = bl;
    }

    public void setKingdom(boolean bl) {
        this.m_kingdom = bl;
    }

    public void setSuperPhylum(boolean bl) {
        this.m_superPhylum = bl;
    }

    public void setPhylum(boolean bl) {
        this.m_phylum = bl;
    }

    public void setSubPhylum(boolean bl) {
        this.m_subPhylum = bl;
    }

    public void setClass(boolean bl) {
        this.m_class_ = bl;
    }

    public void setSubClass(boolean bl) {
        this.m_subClass_ = bl;
    }

    public void setOrder(boolean bl) {
        this.m_order = bl;
    }

    public void setSubOrder(boolean bl) {
        this.m_subOrder = bl;
    }

    public void setFamily(boolean bl) {
        this.m_family = bl;
    }

    public void setTribe(boolean bl) {
        this.m_tribe = bl;
    }

    public void setGenus(boolean bl) {
        this.m_genus = bl;
    }

    public void setSpeciesGroup(boolean bl) {
        this.spciesGroup = bl;
    }

    public void setSpecies(boolean bl) {
        this.m_species = bl;
    }

    public void setRankItems(String string) {
        this.rankItems = string;
    }

    public void setRankItemList(List list) {
        this.setRankItems(StringTool.conbineStrList(list));
    }

    public void setGenomeMapX(int n) {
        this.m_genomeMapX = n;
    }

    public void setGenomeMapY(int n) {
        this.m_genomeMapY = n;
    }

    public void setGenomeMapW(int n) {
        this.m_genomeMapW = n;
    }

    public void setGenomeMapH(int n) {
        this.m_genomeMapH = n;
    }

    public void setDomClustUrl(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.m_domClustUrl = string;
    }

    public void setDomClustKillUrl(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.domClustKillUrl = string;
    }

    public void setClustalWOpt_TYPE(String string) {
        this.m_clustalWOpt_TYPE = string;
    }

    public void setClustalWOpt_OUTPUT(String string) {
        this.m_clustalWOpt_OUTPUT = string;
    }

    public void setClustalWOpt_ORDER(String string) {
        this.m_clustalWOpt_ORDER = string;
    }

    public void setClustalWOpt_MATRIX(String string) {
        this.m_clustalWOpt_MATRIX = string;
    }

    public void setClustalWOpt_RANGE(String string) {
        this.m_clustalWOpt_RANGE = string;
    }

    public void setClustalWOpt_START(int n) {
        this.m_clustalWOpt_START = n;
    }

    public void setClustalWOpt_LENGTH(int n) {
        this.m_clustalWOpt_LENGTH = n;
    }

    public void setClustalWOpt_OPEN(double d) {
        this.m_clustalWOpt_OPEN = d;
    }

    public void setClustalWOpt_EXT(double d) {
        this.m_clustalWOpt_EXT = d;
    }

    public void setClustalWOpt_DIST(int n) {
        this.m_clustalWOpt_DIST = n;
    }

    public void setClustalWOpt_DIV(int n) {
        this.m_clustalWOpt_DIV = n;
    }

    public void setClustalWOpt_END(String string) {
        this.m_clustalWOpt_END = string;
    }

    public void setClustalWOpt_NOP(String string) {
        this.m_clustalWOpt_NOP = string;
    }

    public void setClustalWOpt_NOH(String string) {
        this.m_clustalWOpt_NOH = string;
    }

    public void setClustalWOpt_TREE(String string) {
        this.m_clustalWOpt_TREE = string;
    }

    public void setClustalWOpt_KTUPLE(int n) {
        this.m_clustalWOpt_KTUPLE = n;
    }

    public void setClustalWOpt_WINDOW(int n) {
        this.m_clustalWOpt_WINDOW = n;
    }

    public void setClustalWOpt_SCORE(String string) {
        this.m_clustalWOpt_SCORE = string;
    }

    public void setClustalWOpt_TOP(int n) {
        this.m_clustalWOpt_TOP = n;
    }

    public void setClustalWOpt_PAIR(int n) {
        this.m_clustalWOpt_PAIR = n;
    }

    public void setClustalWOpt_PWM(String string) {
        this.m_clustalWOpt_PWM = string;
    }

    public void setClustalWOpt_PWO(double d) {
        this.m_clustalWOpt_PWO = d;
    }

    public void setClustalWOpt_PWE(double d) {
        this.m_clustalWOpt_PWE = d;
    }

    public void setClustalWOpt_KIMURA(String string) {
        this.m_clustalWOpt_KIMURA = string;
    }

    public void setClustalWOpt_TOSS(String string) {
        this.m_clustalWOpt_TOSS = string;
    }

    public void setClustalWOpt_OTREE(String string) {
        this.m_clustalWOpt_OTREE = string;
    }

    public void setClustalWOpt_BS(String string) {
        this.m_clustalWOpt_BS = string;
    }

    public void setClustalWOpt_COUNT(int n) {
        this.m_clustalWOpt_COUNT = n;
    }

    public void setClustalWOpt_SEED(int n) {
        this.m_clustalWOpt_SEED = n;
    }

    public void setGeneFrameX(int n) {
        this.m_geneFrameX = n;
    }

    public void setGeneFrameY(int n) {
        this.m_geneFrameY = n;
    }

    public void setGeneFrameW(int n) {
        this.m_geneFrameW = n;
    }

    public void setGeneFrameH(int n) {
        this.m_geneFrameH = n;
    }

    public void setCsvDir(String string) {
        this.m_csvDir = string;
    }

    public void setGetDataUrl(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.m_getDataUrl = string;
    }

    public void setExpand(boolean bl) {
        this.m_expand = bl;
    }

    public void setZoomIn2(String string) {
        this.m_zoomIn2 = string;
    }

    public void setZoomOut2(String string) {
        this.m_zoomOut2 = string;
    }

    public void setMovePrev(String string) {
        this.m_movePrev = string;
    }

    public void setMoveNext(String string) {
        this.m_moveNext = string;
    }

    public void setGeneCountColorFlag(boolean bl) {
        this.geneCountColorFlag = bl;
    }

    public void setGeneCountColorMinCount(int n) {
        this.geneCountColorMinCount = n;
    }

    public void setGeneCountColor(String string) {
        this.geneCountColor = string;
    }

    public void setGeneNameView(boolean bl) {
        this.geneNameView = bl;
    }

    public void setBorderLineView(boolean bl) {
        this.borderLineView = bl;
    }

    public void setMinClusterH(int n) {
        this.m_prevMinClusterH = this.m_minClusterH;
        this.m_minClusterH = n > 100 ? 100 : (n < 2 ? 2 : n);
    }

    public void setMinClusterW(int n) {
        this.m_prevMinClusterW = this.m_minClusterW;
        this.m_minClusterW = n > 100 ? 100 : (n < 2 ? 2 : n);
    }

    public void setTaxonomyView(boolean bl) {
        this.m_taxonomyView = bl;
    }

    public void setFunctionView(boolean bl) {
        this.m_functionView = bl;
    }

    public void setLastDividerLocation1(int n) {
        this.m_lastDividerLocation1 = n;
    }

    public void setLastDividerLocation2(int n) {
        this.m_lastDividerLocation2 = n;
    }

    public void setBorderLineColorString(String string) {
        this.borderLineColorString = string;
    }

    public void setOutgroupColorString(String string) {
        this.outgroupColorString = string;
    }

    public void setIngroupColorString(String string) {
        this.ingroupColorString = string;
    }

    public void setOutergroupColorString(String string) {
        System.err.println("outergroupColorString" + string);
        this.outergroupColorString = string;
    }

    public void setOutgroupAsIngroupFlag(boolean bl) {
        this.outgroupAsIngroupFlag = bl;
    }

    public void setOutgroupIngroupColorString(String string) {
        this.outgroupIngroupColorString = string;
    }

    public void setSelectLine1ColorString(String string) {
        this.selectLine1ColorString = string;
    }

    public void setSelectLine2ColorString(String string) {
        this.selectLine2ColorString = string;
    }

    public void setSearchResultColorString(String string) {
        this.searchResultColorString = string;
    }

    public void setIngroupFontColor(String string) {
        this.ingroupFontColor = string;
    }

    public void setOutgroupFontColor(String string) {
        this.outgroupFontColor = string;
    }

    public String getUserImportDir() {
        return this.userImportDir;
    }

    public boolean isIntensive() {
        return this.intensive;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public String getClusterTreeUrl() {
        return this.m_clusterTreeUrl;
    }

    public String getGeneInfoUrl() {
        return this.m_geneInfoUrl;
    }

    public String getGeneAnnotationUrl() {
        return this.geneAnnotationUrl;
    }

    public String getClusterAnnotationUrl() {
        return this.clusterAnnotationUrl;
    }

    public String getFuncCatUrl() {
        return this.m_funcCatUrl;
    }

    public String getFunctionCategoryType() {
        return this.functionCategoryType;
    }

    public boolean getSyncPPMFilter() {
        return this.m_syncPPMFilter;
    }

    public String getNaUrl() {
        return this.m_naUrl;
    }

    public String getAaUrl() {
        return this.m_aaUrl;
    }

    public String getDomainUrl() {
        return this.m_domainUrl;
    }

    public int getMainWindowX() {
        return this.m_mainWindowX;
    }

    public int getMainWindowY() {
        return this.m_mainWindowY;
    }

    public int getMainWindowW() {
        return this.m_mainWindowW;
    }

    public int getMainWindowH() {
        return this.m_mainWindowH;
    }

    public int getDividerLocation1() {
        return this.m_dividerLocation1;
    }

    public int getDividerLocation2() {
        return this.m_dividerLocation2;
    }

    public int getDividerLocation3() {
        return this.m_dividerLocation3;
    }

    public int getDividerLocation4() {
        return this.m_dividerLocation4;
    }

    public int getDividerLocation5() {
        return this.m_dividerLocation5;
    }

    public String getClusterFrom() {
        return this.m_clusterFrom;
    }

    public String getClusterTo() {
        return this.m_clusterTo;
    }

    public int getClusterCount() {
        return this.m_clusterCount;
    }

    public int getAlignmentFrameX() {
        return this.m_alignmentFrameX;
    }

    public int getAlignmentFrameY() {
        return this.m_alignmentFrameY;
    }

    public int getAlignmentFrameW() {
        return this.m_alignmentFrameW;
    }

    public int getAlignmentFrameH() {
        return this.m_alignmentFrameH;
    }

    public String getClustalW() {
        return this.m_clustalW;
    }

    public int getMultiFrameX() {
        return this.m_multiFrameX;
    }

    public int getMultiFrameY() {
        return this.m_multiFrameY;
    }

    public int getMultiFrameW() {
        return this.m_multiFrameW;
    }

    public int getMultiFrameH() {
        return this.m_multiFrameH;
    }

    public int getTreeType() {
        return this.m_treeType;
    }

    public boolean isTopLevel() {
        return this.m_top_level;
    }

    public boolean isSuperKingdom() {
        return this.m_superKingdom;
    }

    public boolean isNoRank() {
        return this.m_noRank;
    }

    public boolean isKingdom() {
        return this.m_kingdom;
    }

    public boolean isSuperPhylum() {
        return this.m_superPhylum;
    }

    public boolean isPhylum() {
        return this.m_phylum;
    }

    public boolean isSubPhylum() {
        return this.m_subPhylum;
    }

    public boolean isClass() {
        return this.m_class_;
    }

    public boolean isSubClass() {
        return this.m_subClass_;
    }

    public boolean isOrder() {
        return this.m_order;
    }

    public boolean isSubOrder() {
        return this.m_subOrder;
    }

    public boolean isFamily() {
        return this.m_family;
    }

    public boolean isTribe() {
        return this.m_tribe;
    }

    public boolean isGenus() {
        return this.m_genus;
    }

    public boolean isSpeciesGroup() {
        return this.spciesGroup;
    }

    public boolean isSpecies() {
        return this.m_species;
    }

    public String getRankItems() {
        return this.rankItems;
    }

    public List getRankItemList() {
        return new ArrayList(StringTool.splitString(this.getRankItems()));
    }

    public boolean isSelectedRankForTaxTree(String string) {
        if (RankDif.isTopLevel(string)) {
            return this.isTopLevel();
        }
        if (RankDif.isSuperkingdom(string)) {
            return this.isSuperKingdom();
        }
        if (RankDif.isKingdom(string)) {
            return this.isKingdom();
        }
        if (RankDif.isSuperphylum(string)) {
            return this.isSuperPhylum();
        }
        if (RankDif.isPhylum(string)) {
            return this.isPhylum();
        }
        if (RankDif.isSubphylum(string)) {
            return this.isSubPhylum();
        }
        if (RankDif.isOrder(string)) {
            return this.isOrder();
        }
        if (RankDif.isSuborder(string)) {
            return this.isSubOrder();
        }
        if (RankDif.isClass(string)) {
            return this.isClass();
        }
        if (RankDif.isSubclass(string)) {
            return this.isSubClass();
        }
        if (RankDif.isFamily(string)) {
            return this.isFamily();
        }
        if (RankDif.isGenus(string)) {
            return this.isGenus();
        }
        if (RankDif.isSpeciesGroup(string)) {
            return this.isSpeciesGroup();
        }
        if (RankDif.isSpecies(string)) {
            return this.isSpecies();
        }
        if (RankDif.isNoRank(string)) {
            return this.isNoRank();
        }
        return false;
    }

    public void setSelectedRankForTaxTree(String string, boolean bl) {
        if (RankDif.isTopLevel(string)) {
            this.setTopLevel(bl);
        } else if (RankDif.isSuperkingdom(string)) {
            this.setSuperKingdom(bl);
        } else if (RankDif.isKingdom(string)) {
            this.setKingdom(bl);
        } else if (RankDif.isSuperphylum(string)) {
            this.setSuperPhylum(bl);
        } else if (RankDif.isPhylum(string)) {
            this.setPhylum(bl);
        } else if (RankDif.isSubphylum(string)) {
            this.setSubPhylum(bl);
        } else if (RankDif.isOrder(string)) {
            this.setOrder(bl);
        } else if (RankDif.isSuborder(string)) {
            this.setSubOrder(bl);
        } else if (RankDif.isClass(string)) {
            this.setClass(bl);
        } else if (RankDif.isSubclass(string)) {
            this.setSubClass(bl);
        } else if (RankDif.isFamily(string)) {
            this.setFamily(bl);
        } else if (RankDif.isGenus(string)) {
            this.setGenus(bl);
        } else if (RankDif.isSpeciesGroup(string)) {
            this.setSpeciesGroup(bl);
        } else if (RankDif.isSpecies(string)) {
            this.setSpecies(bl);
        } else if (RankDif.isNoRank(string)) {
            this.setNoRank(bl);
        }
    }

    public int getGenomeMapX() {
        return this.m_genomeMapX;
    }

    public int getGenomeMapY() {
        return this.m_genomeMapY;
    }

    public int getGenomeMapW() {
        return this.m_genomeMapW;
    }

    public int getGenomeMapH() {
        return this.m_genomeMapH;
    }

    public String getDomClustUrl() {
        return this.m_domClustUrl;
    }

    public String getDomClustKillUrl() {
        return this.domClustKillUrl;
    }

    public String getClustalWOpt_TYPE() {
        return this.m_clustalWOpt_TYPE;
    }

    public String getClustalWOpt_OUTPUT() {
        return this.m_clustalWOpt_OUTPUT;
    }

    public String getClustalWOpt_ORDER() {
        return this.m_clustalWOpt_ORDER;
    }

    public String getClustalWOpt_MATRIX() {
        return this.m_clustalWOpt_MATRIX;
    }

    public String getClustalWOpt_RANGE() {
        return this.m_clustalWOpt_RANGE;
    }

    public int getClustalWOpt_START() {
        return this.m_clustalWOpt_START;
    }

    public int getClustalWOpt_LENGTH() {
        return this.m_clustalWOpt_LENGTH;
    }

    public double getClustalWOpt_OPEN() {
        return this.m_clustalWOpt_OPEN;
    }

    public double getClustalWOpt_EXT() {
        return this.m_clustalWOpt_EXT;
    }

    public int getClustalWOpt_DIST() {
        return this.m_clustalWOpt_DIST;
    }

    public int getClustalWOpt_DIV() {
        return this.m_clustalWOpt_DIV;
    }

    public String getClustalWOpt_END() {
        return this.m_clustalWOpt_END;
    }

    public String getClustalWOpt_NOP() {
        return this.m_clustalWOpt_NOP;
    }

    public String getClustalWOpt_NOH() {
        return this.m_clustalWOpt_NOH;
    }

    public String getClustalWOpt_TREE() {
        return this.m_clustalWOpt_TREE;
    }

    public boolean isClustalWQuickTree() {
        return this.getClustalWOpt_TREE().equals("ON");
    }

    public int getClustalWOpt_KTUPLE() {
        return this.m_clustalWOpt_KTUPLE;
    }

    public int getClustalWOpt_WINDOW() {
        return this.m_clustalWOpt_WINDOW;
    }

    public String getClustalWOpt_SCORE() {
        return this.m_clustalWOpt_SCORE;
    }

    public int getClustalWOpt_TOP() {
        return this.m_clustalWOpt_TOP;
    }

    public int getClustalWOpt_PAIR() {
        return this.m_clustalWOpt_PAIR;
    }

    public String getClustalWOpt_PWM() {
        return this.m_clustalWOpt_PWM;
    }

    public double getClustalWOpt_PWO() {
        return this.m_clustalWOpt_PWO;
    }

    public double getClustalWOpt_PWE() {
        return this.m_clustalWOpt_PWE;
    }

    public String getClustalWOpt_KIMURA() {
        return this.m_clustalWOpt_KIMURA;
    }

    public String getClustalWOpt_TOSS() {
        return this.m_clustalWOpt_TOSS;
    }

    public String getClustalWOpt_OTREE() {
        return this.m_clustalWOpt_OTREE;
    }

    public String getClustalWOpt_BS() {
        return this.m_clustalWOpt_BS;
    }

    public boolean isClustalWBootstrap() {
        return this.getClustalWOpt_BS().equals("ON");
    }

    public int getClustalWOpt_COUNT() {
        return this.m_clustalWOpt_COUNT;
    }

    public int getClustalWOpt_SEED() {
        return this.m_clustalWOpt_SEED;
    }

    public int getGeneFrameX() {
        return this.m_geneFrameX;
    }

    public int getGeneFrameY() {
        return this.m_geneFrameY;
    }

    public int getGeneFrameW() {
        return this.m_geneFrameW;
    }

    public int getGeneFrameH() {
        return this.m_geneFrameH;
    }

    public String getCsvDir() {
        return this.m_csvDir;
    }

    public String getGetDataUrl() {
        return this.m_getDataUrl;
    }

    public boolean isExpand() {
        return this.m_expand;
    }

    public String getZoomIn2() {
        return this.m_zoomIn2;
    }

    public int getZoomIn2(int n) {
        if (this.m_zoomIn2.equals("X2")) {
            return (int)((double)n * 0.5);
        }
        if (this.m_zoomIn2.equals("X4")) {
            return (int)((double)n * 0.25);
        }
        return (int)((double)n * 0.15);
    }

    public String getZoomOut2() {
        return this.m_zoomOut2;
    }

    public int getZoomOut2(int n) {
        if (this.m_zoomOut2.equals("X2")) {
            return n * 2;
        }
        if (this.m_zoomOut2.equals("X4")) {
            return n * 4;
        }
        return n * 8;
    }

    public int getMinClusterH() {
        return this.m_minClusterH;
    }

    public int getMinClusterW() {
        return this.m_minClusterW;
    }

    public String getMovePrev() {
        return this.m_movePrev;
    }

    public int getMovePrev(int n) {
        if (this.m_movePrev.equals("1")) {
            return n;
        }
        if (this.m_movePrev.equals("1/2")) {
            return (int)((double)n * 0.5);
        }
        return (int)((double)n * 0.25);
    }

    public String getMoveNext() {
        return this.m_moveNext;
    }

    public boolean isGeneCountColorFlag() {
        return this.geneCountColorFlag;
    }

    public int getGeneCountColorMinCount() {
        return this.geneCountColorMinCount;
    }

    public String getGeneCountColor() {
        return this.geneCountColor;
    }

    public boolean isGeneNameView() {
        return this.geneNameView;
    }

    public boolean isBorderLineView() {
        return this.borderLineView;
    }

    public int getMoveNext(int n) {
        if (this.m_moveNext.equals("1")) {
            return n;
        }
        if (this.m_moveNext.equals("1/2")) {
            return (int)((double)n * 0.5);
        }
        return (int)((double)n * 0.25);
    }

    public void restoreClustalW() {
        this.m_clustalWOpt_TYPE = "Use default";
        this.m_clustalWOpt_OUTPUT = "clustal";
        this.m_clustalWOpt_ORDER = "aligned";
        this.m_clustalWOpt_MATRIX = "blosum";
        this.m_clustalWOpt_RANGE = "OFF";
        this.m_clustalWOpt_START = Integer.MIN_VALUE;
        this.m_clustalWOpt_LENGTH = Integer.MIN_VALUE;
        this.m_clustalWOpt_OPEN = 10.0;
        this.m_clustalWOpt_EXT = 0.2;
        this.m_clustalWOpt_DIST = 8;
        this.m_clustalWOpt_DIV = 40;
        this.m_clustalWOpt_END = "OFF";
        this.m_clustalWOpt_NOP = "OFF";
        this.m_clustalWOpt_NOH = "OFF";
        this.m_clustalWOpt_TREE = "OFF";
        this.m_clustalWOpt_KTUPLE = 1;
        this.m_clustalWOpt_WINDOW = 5;
        this.m_clustalWOpt_SCORE = "percent";
        this.m_clustalWOpt_TOP = 5;
        this.m_clustalWOpt_PAIR = 3;
        this.m_clustalWOpt_PWM = "blosum";
        this.m_clustalWOpt_PWO = 10.0;
        this.m_clustalWOpt_PWE = 0.1;
        this.m_clustalWOpt_KIMURA = "ON";
        this.m_clustalWOpt_TOSS = "ON";
        this.m_clustalWOpt_OTREE = "phylip";
        this.m_clustalWOpt_BS = "ON";
        this.m_clustalWOpt_COUNT = 1000;
        this.m_clustalWOpt_SEED = 111;
    }

    public List getClustalWOpts(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_clustalWOpt_TYPE.equals("Use default")) {
            return arrayList;
        }
        String string = bl ? "/" : "-";
        arrayList.add(string + "ALIGN=ON");
        arrayList.add(string + "TYPE=" + this.m_clustalWOpt_TYPE);
        arrayList.add(string + "OUTPUT=" + this.m_clustalWOpt_OUTPUT);
        arrayList.add(string + "MATRIX=" + this.m_clustalWOpt_MATRIX);
        arrayList.add(string + "SEQNO_RANGE=" + this.m_clustalWOpt_RANGE);
        if (this.m_clustalWOpt_RANGE.equals("ON")) {
            arrayList.add(string + "START=" + this.m_clustalWOpt_START);
            arrayList.add(string + "LENGTH=" + this.m_clustalWOpt_LENGTH);
        }
        arrayList.add(string + "GAPOPEN=" + this.m_clustalWOpt_OPEN);
        arrayList.add(string + "GAPEXT=" + this.m_clustalWOpt_EXT);
        arrayList.add(string + "GAPDIST=" + this.m_clustalWOpt_DIST);
        arrayList.add(string + "MAXDIV=" + this.m_clustalWOpt_DIV);
        arrayList.add(string + "ENDGAPS=" + this.m_clustalWOpt_END);
        arrayList.add(string + "NOPGAP=" + this.m_clustalWOpt_NOP);
        arrayList.add(string + "NOHGAP=" + this.m_clustalWOpt_NOH);
        arrayList.add(string + "QUICKTREE=" + this.m_clustalWOpt_TREE);
        if (this.m_clustalWOpt_TREE.equals("ON")) {
            arrayList.add(string + "KTUPLE=" + this.m_clustalWOpt_KTUPLE);
            arrayList.add(string + "WINDOW=" + this.m_clustalWOpt_WINDOW);
            arrayList.add(string + "TOPDIAGS=" + this.m_clustalWOpt_TOP);
            arrayList.add(string + "PAIRGAP=" + this.m_clustalWOpt_PAIR);
        } else {
            arrayList.add(string + "PWMATRIX=" + this.m_clustalWOpt_PWM);
            arrayList.add(string + "PWGAPOPEN=" + this.m_clustalWOpt_PWO);
            arrayList.add(string + "PWGAPEXT=" + this.m_clustalWOpt_PWE);
        }
        arrayList.add(string + "TREE=ON");
        arrayList.add(string + "KIMURA=" + this.m_clustalWOpt_KIMURA);
        arrayList.add(string + "TOSSGAPS=" + this.m_clustalWOpt_TOSS);
        arrayList.add(string + "OUTPUTTREE=" + this.m_clustalWOpt_OTREE);
        if (this.m_clustalWOpt_BS.equals("ON")) {
            arrayList.add(string + "BOOTSTRAP=" + this.m_clustalWOpt_COUNT);
            arrayList.add(string + "SEED=" + this.m_clustalWOpt_SEED);
        }
        return arrayList;
    }

    public List getClustalWAlignOpts(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "-";
        arrayList.add(string + "align");
        if (this.m_clustalWOpt_TYPE.equals("Use default")) {
            arrayList.add(string + "type=auto");
        } else {
            arrayList.add(string + "type=" + this.m_clustalWOpt_TYPE);
        }
        if (this.m_clustalWOpt_TYPE.equals("Use default")) {
            return arrayList;
        }
        arrayList.add(string + "output=" + this.m_clustalWOpt_OUTPUT);
        arrayList.add(string + "outorder=" + this.m_clustalWOpt_ORDER);
        arrayList.add(string + "matrix=" + this.m_clustalWOpt_MATRIX);
        if (this.m_clustalWOpt_RANGE.equals("ON")) {
            arrayList.add(string + "seqno_range=ON");
            arrayList.add(string + "range=" + this.m_clustalWOpt_START + "." + this.m_clustalWOpt_LENGTH);
        }
        arrayList.add(string + "gapopen=" + this.m_clustalWOpt_OPEN);
        arrayList.add(string + "gapext=" + this.m_clustalWOpt_EXT);
        arrayList.add(string + "gapdist=" + this.m_clustalWOpt_DIST);
        arrayList.add(string + "maxdiv=" + this.m_clustalWOpt_DIV);
        if (this.m_clustalWOpt_END.equals("ON")) {
            arrayList.add(string + "endgaps");
        }
        if (this.m_clustalWOpt_NOP.equals("ON")) {
            arrayList.add(string + "nopgap");
        }
        if (this.m_clustalWOpt_NOH.equals("ON")) {
            arrayList.add(string + "nohgap");
        }
        if (this.m_clustalWOpt_TREE.equals("ON")) {
            arrayList.add(string + "quicktree");
            arrayList.add(string + "ktuple=" + this.m_clustalWOpt_KTUPLE);
            arrayList.add(string + "window=" + this.m_clustalWOpt_WINDOW);
            arrayList.add(string + "score=" + this.m_clustalWOpt_SCORE);
            arrayList.add(string + "topdiags=" + this.m_clustalWOpt_TOP);
            arrayList.add(string + "pairgap=" + this.m_clustalWOpt_PAIR);
        } else {
            arrayList.add(string + "pwmatrix=" + this.m_clustalWOpt_PWM);
            arrayList.add(string + "pwgapopen=" + this.m_clustalWOpt_PWO);
            arrayList.add(string + "pwgapext=" + this.m_clustalWOpt_PWE);
        }
        return arrayList;
    }

    public List getClustalWTreeOpts(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "-";
        if (this.m_clustalWOpt_BS.equals("ON")) {
            arrayList.add(string + "bootstrap=" + this.m_clustalWOpt_COUNT);
        } else {
            arrayList.add(string + "tree");
        }
        if (this.m_clustalWOpt_BS.equals("ON")) {
            arrayList.add(string + "seed=" + this.m_clustalWOpt_SEED);
        }
        if (this.m_clustalWOpt_KIMURA.equals("ON")) {
            arrayList.add(string + "kimura");
        }
        if (this.m_clustalWOpt_TOSS.equals("ON")) {
            arrayList.add(string + "tossgaps");
        }
        arrayList.add(string + "outputtree=" + this.m_clustalWOpt_OTREE);
        return arrayList;
    }

    public boolean isTreeBootstrap() {
        return this.m_clustalWOpt_BS.equals("ON");
    }

    public boolean isTaxonomyView() {
        return this.m_taxonomyView;
    }

    public boolean isFunctionView() {
        return this.m_functionView;
    }

    public int getLastDividerLocation1() {
        return this.m_lastDividerLocation1;
    }

    public int getLastDividerLocation2() {
        return this.m_lastDividerLocation2;
    }

    public String getBorderLineColorString() {
        return this.borderLineColorString;
    }

    public String getOutgroupColorString() {
        return this.outgroupColorString;
    }

    public String getIngroupColorString() {
        return this.ingroupColorString;
    }

    public String getOutergroupColorString() {
        return this.outergroupColorString;
    }

    public boolean isOutgroupAsIngroupFlag() {
        return this.outgroupAsIngroupFlag;
    }

    public String getOutgroupIngroupColorString() {
        return this.outgroupIngroupColorString;
    }

    public String getSelectLine1ColorString() {
        return this.selectLine1ColorString;
    }

    public String getSelectLine2ColorString() {
        return this.selectLine2ColorString;
    }

    public String getSearchResultColorString() {
        return this.searchResultColorString;
    }

    public String getIngroupFontColor() {
        return this.ingroupFontColor;
    }

    public String getOutgroupFontColor() {
        return this.outgroupFontColor;
    }

    public String getUpdateSiteURL() {
        return this.updateSiteURL;
    }

    public void setUpdateSiteURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.updateSiteURL = string;
    }

    public String getSysInfoURL() {
        return this.sysInfoURL;
    }

    public void setSysInfoURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.sysInfoURL = string;
    }

    public String getErrorUploadURL() {
        return this.errorUploadURL;
    }

    public void setErrorUploadURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.errorUploadURL = string;
    }

    public String getServerLogDownloadURL() {
        return this.serverLogDownloadURL;
    }

    public void setServerLogDownloadURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.serverLogDownloadURL = string;
    }

    public long getUpdateCheckInterval() {
        return this.updateCheckInterval;
    }

    public void setUpdateCheckInterval(long l) {
        this.updateCheckInterval = l;
    }

    public boolean isShowTreeDistFromUpgma() {
        return this.showTreeDistFromUpgma;
    }

    public void setShowTreeDistFromUpgma(boolean bl) {
        this.showTreeDistFromUpgma = bl;
    }

    public String getCoreGenomeUrl() {
        return this.coreGenomeUrl;
    }

    public void setCoreGenomeUrl(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.coreGenomeUrl = string.endsWith("/htbin/RECOG/findcore") ? DEFAULT_CORE_GENOME_URL : string;
    }

    public CoreGenomeAlignmentCondition getCoreGenomeAlignmentCondition() {
        return this.coreGenomeAlignmentCondition;
    }

    public void setCoreGenomeAlignmentCondition(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        this.coreGenomeAlignmentCondition = coreGenomeAlignmentCondition;
    }

    public NeighboringClustCondition getNeighboringClustCondition() {
        return this.neighboringClustCondition;
    }

    public void setNeighboringClustCondition(NeighboringClustCondition neighboringClustCondition) {
        this.neighboringClustCondition = neighboringClustCondition;
    }

    public List getNeighborColorPatternList() {
        return this.neighborColorPatternList;
    }

    public void setNeighborColorPatternList(List list) {
        this.neighborColorPatternList = list;
    }

    public String getNeighborColorPatternStr() {
        if (this.neighborColorPatternList == null || this.neighborColorPatternList.isEmpty()) {
            return "";
        }
        return StringTool.conbineStrList(this.neighborColorPatternList, ",");
    }

    public void setNeighborColorPatternStr(String string) {
        Vector vector = StringTool.splitString(string, ",");
        if (vector != null) {
            this.neighborColorPatternList = new ArrayList(vector);
        }
    }

    public String getUpgmaUrl() {
        return this.upgmaUrl;
    }

    public void setUpgmaUrl(String string) {
        if (StringTool.isNull(this.upgmaUrl)) {
            return;
        }
        this.upgmaUrl = string;
    }

    public String getUserExportDir() {
        return this.userExportDir;
    }

    public void setUserExportDir(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.userExportDir = string;
    }

    public String getDomClustConditionName() {
        return this.domClustConditionName;
    }

    public void setDomClustConditionName(String string) {
        this.domClustConditionName = string;
    }

    public boolean isShowAllRankOnTree() {
        return TaxTreeShowType.isAllRank(this.m_treeType);
    }

    public boolean isShowSelectRankOnTree() {
        return TaxTreeShowType.isSpecRank(this.m_treeType);
    }

    public String getMinimumRankOnTree() {
        List list = this.getDisplayRankList();
        return (String)list.get(list.size() - 1);
    }

    public List getDisplayRankList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isShowAllRankOnTree()) {
            arrayList.add("top level");
            arrayList.add("superkingdom");
            arrayList.add("kingdom");
            arrayList.add("subkingdom");
            arrayList.add("superphylum");
            arrayList.add("phylum");
            arrayList.add("superphylum");
            arrayList.add("order");
            arrayList.add("suborder");
            arrayList.add("class");
            arrayList.add("subclass");
            arrayList.add("family");
            arrayList.add("genus");
            arrayList.add("species");
            arrayList.add("no rank");
        } else {
            if (this.isTopLevel()) {
                arrayList.add("top level");
            }
            if (this.isSuperKingdom()) {
                arrayList.add("superkingdom");
            }
            if (this.isKingdom()) {
                arrayList.add("kingdom");
            }
            if (this.isSuperPhylum()) {
                arrayList.add("superphylum");
            }
            if (this.isPhylum()) {
                arrayList.add("phylum");
            }
            if (this.isSubPhylum()) {
                arrayList.add("superphylum");
            }
            if (this.isOrder()) {
                arrayList.add("order");
            }
            if (this.isSubOrder()) {
                arrayList.add("suborder");
            }
            if (this.isClass()) {
                arrayList.add("class");
            }
            if (this.isSubClass()) {
                arrayList.add("subclass");
            }
            if (this.isFamily()) {
                arrayList.add("family");
            }
            if (this.isGenus()) {
                arrayList.add("genus");
            }
            if (this.isSpecies()) {
                arrayList.add("species");
            }
            if (this.isNoRank()) {
                arrayList.add("no rank");
            }
        }
        Collections.sort(arrayList, new RankComparator());
        return arrayList;
    }

    public String getClientVersionUrl() {
        return this.clientVersionUrl;
    }

    public void setClientVersionUrl(String string) {
        this.clientVersionUrl = string;
    }

    public boolean isShowVersionUp() {
        return this.showVersionUp;
    }

    public void setShowVersionUp(boolean bl) {
        this.showVersionUp = bl;
    }

    public String getSeqDownloadURL() {
        return this.seqDownloadURL;
    }

    public void setSeqDownloadURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.seqDownloadURL = string;
    }

    public String getTaxMapDownloadURL() {
        return this.taxMapDownloadURL;
    }

    public void setTaxMapDownloadURL(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.taxMapDownloadURL = string;
    }

    public int getClusterMapVPageStepSize() {
        return this.m_clusterMapVPageStepSize;
    }

    public void setClusterMapVPageStepSize(int n) {
        this.m_clusterMapVPageStepSize = n;
    }

    public int getClusterMapVScrollStepSize() {
        return this.m_clusterMapVScrollStepSize;
    }

    public void setClusterMapVScrollStepSize(int n) {
        this.m_clusterMapVScrollStepSize = n;
    }

    public int getClusterMapHScrollStepSize() {
        return this.m_clusterMapHScrollStepSize;
    }

    public void setClusterMapHScrollStepSize(int n) {
        this.m_clusterMapHScrollStepSize = n;
    }

    public int getPrevMinClusterH() {
        return this.m_prevMinClusterH;
    }

    public int getPrevMinClusterW() {
        return this.m_prevMinClusterW;
    }

    public void resetPrevMinClusterH() {
        this.m_prevMinClusterH = this.m_minClusterH;
    }

    public void resetPrevMinClusterW() {
        this.m_prevMinClusterW = this.m_minClusterW;
    }

    public boolean isShowHiddenMenu() {
        return this.showHiddenMenu;
    }

    public void setShowHiddenMenu(boolean bl) {
        this.showHiddenMenu = bl;
    }

    public String getPublicColor() {
        return this.publicColor;
    }

    public void setPublicColor(String string) {
        this.publicColor = string;
    }

    public Set getEnableDomclustParam() {
        return this.enableDomclustParam;
    }

    public String getEnableDomclustParamString() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Integer n : this.enableDomclustParam) {
            hashSet.add(n.toString());
        }
        return StringTool.conbineStrList(hashSet);
    }

    public void setEnableDomclustParam(Set set) {
        this.enableDomclustParam = set;
    }
}

