/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.RankDif;
import cgdp.recog.option.DefaultOptionValues;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.taxonomy.TaxTreeShowType;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class TaxonomyTreeSettingPanel
extends TabPanel
implements ActionListener {
    private MediatorImpl mediator;
    private JRadioButton allButton;
    private JRadioButton simpleButton;
    private Map taxRankCheckBoxMap = new LinkedHashMap();
    private Map rankItemCheckBoxMap = new LinkedHashMap();
    private ColorLegendPanel ingroupColorPanel;
    private ColorLegendPanel outgroupColorPanel;

    TaxonomyTreeSettingPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createDisplayRankPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.createRankItemPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.createInOutColorPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(3, 10, 10, 3), 0, 0));
        this.initValue();
    }

    private JPanel createInOutColorPanel() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        JLabel jLabel = new JLabel("Font Color");
        JLabel jLabel2 = new JLabel("INGROUP:");
        this.ingroupColorPanel = new ColorLegendPanel(optionTbl.getOptionValues().getIngroupFontColor());
        JLabel jLabel3 = new JLabel("OUTGROUP:");
        this.outgroupColorPanel = new ColorLegendPanel(optionTbl.getOptionValues().getOutgroupFontColor());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 10), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.ingroupColorPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.outgroupColorPanel, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    private JPanel createDisplayRankPanel() {
        JCheckBox jCheckBox;
        int n;
        this.allButton = new JRadioButton("All");
        this.allButton.addActionListener(this);
        this.simpleButton = new JRadioButton("Simple");
        this.simpleButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allButton);
        buttonGroup.add(this.simpleButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.allButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.simpleButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        String[] stringArray = RankDif.RANKS;
        for (n = 0; n < stringArray.length; ++n) {
            jCheckBox = new JCheckBox(stringArray[n]);
            this.taxRankCheckBoxMap.put(stringArray[n], jCheckBox);
        }
        for (n = 0; n < stringArray.length; ++n) {
            jCheckBox = new JCheckBox(stringArray[n]);
            this.rankItemCheckBoxMap.put(stringArray[n], jCheckBox);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Display Rank"));
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        int n2 = 1;
        int n3 = 0;
        for (JCheckBox jCheckBox2 : this.taxRankCheckBoxMap.values()) {
            jPanel2.add((Component)jCheckBox2, new GridBagConstraints(n3, n2, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            if (++n3 % 5 != 0) continue;
            n3 = 0;
            ++n2;
        }
        return jPanel2;
    }

    private JPanel createRankItemPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Rank Item"));
        jPanel.setLayout(new GridBagLayout());
        int n = 1;
        int n2 = 0;
        for (JCheckBox jCheckBox : this.rankItemCheckBoxMap.values()) {
            jPanel.add((Component)jCheckBox, new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            if (++n2 % 5 != 0) continue;
            n2 = 0;
            ++n;
        }
        return jPanel;
    }

    private void initValue() {
        Object object;
        Object object22;
        OptionTbl optionTbl = OptionTbl.getInstance();
        this.setTreeType(optionTbl.getOptionValues().getTreeType());
        for (Object object22 : this.taxRankCheckBoxMap.keySet()) {
            object = (JCheckBox)this.taxRankCheckBoxMap.get(object22);
            ((AbstractButton)object).setSelected(this.isSelectedRankFromOptionTbl((String)object22));
        }
        List list = optionTbl.getOptionValues().getRankItemList();
        object22 = list.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            JCheckBox jCheckBox = (JCheckBox)this.rankItemCheckBoxMap.get(object);
            jCheckBox.setSelected(true);
        }
        this.setIngroupColor(optionTbl.getOptionValues().getIngroupFontColor());
        this.setOutgroupColor(optionTbl.getOptionValues().getOutgroupFontColor());
    }

    @Override
    protected void changeDefault() {
        Object object;
        Object object22;
        this.setTreeType(1);
        for (Object object22 : this.taxRankCheckBoxMap.keySet()) {
            object = (JCheckBox)this.taxRankCheckBoxMap.get(object22);
            ((AbstractButton)object).setSelected(DefaultOptionValues.isDefaultTaxTreeRankSelected((String)object22));
        }
        this.clearSelectionRankItem();
        Vector vector = StringTool.splitString("class, order, family, genus, species");
        object22 = vector.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            JCheckBox jCheckBox = (JCheckBox)this.rankItemCheckBoxMap.get(object);
            jCheckBox.setSelected(true);
        }
        this.setIngroupColor("#0000ff");
        this.setOutgroupColor("#ff0000");
    }

    private void clearSelectionRankItem() {
        for (JCheckBox jCheckBox : this.rankItemCheckBoxMap.values()) {
            jCheckBox.setSelected(false);
        }
    }

    private void setTreeType(int n) {
        if (TaxTreeShowType.isAllRank(n)) {
            this.allButton.setSelected(true);
            this.setRankCheckBoxEnabled(false);
        } else if (TaxTreeShowType.isSpecRank(n)) {
            this.simpleButton.setSelected(true);
            this.setRankCheckBoxEnabled(true);
        }
    }

    private void setIngroupColor(String string) {
        this.ingroupColorPanel.setColor(string);
    }

    private void setOutgroupColor(String string) {
        this.outgroupColorPanel.setColor(string);
    }

    @Override
    public boolean check() {
        if (!this.isExistSelectRankItem()) {
            String string = "Select at least one or more rank item.";
            MessageManager.showErrorMessage((Component)this, string);
            return false;
        }
        return true;
    }

    private boolean isExistSelectRankItem() {
        boolean bl = false;
        for (JCheckBox jCheckBox : this.rankItemCheckBoxMap.values()) {
            if (!jCheckBox.isSelected()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected void updateParameters() {
        boolean bl = this.isUpdateOption();
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        optionValues.setTreeType(this.getTreeType());
        for (Object object : this.taxRankCheckBoxMap.keySet()) {
            this.setSelectedRankToOptionTbl((String)object);
        }
        ArrayList arrayList = new ArrayList();
        for (String string : this.rankItemCheckBoxMap.keySet()) {
            JCheckBox jCheckBox = (JCheckBox)this.rankItemCheckBoxMap.get(string);
            if (!jCheckBox.isSelected()) continue;
            arrayList.add(string);
        }
        optionValues.setRankItemList(arrayList);
        optionValues.setIngroupFontColor(this.getIngroupColor());
        optionValues.setOutgroupFontColor(this.getOutgroupColor());
        this.mediator.updateForTaxonomySetting(bl);
        this.mediator.updateRankSelectPanel();
    }

    private boolean isUpdateOption() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        if (optionTbl.getOptionValues().getTreeType() != this.getTreeType()) {
            return true;
        }
        if (TaxTreeShowType.isSpecRank(this.getTreeType())) {
            for (String string : this.taxRankCheckBoxMap.keySet()) {
                if (this.isSelectedRankFromOptionTbl(string) == this.isSelectedRankFromGui(string)) continue;
                return true;
            }
        }
        return false;
    }

    private int getTreeType() {
        return this.allButton.isSelected() ? 0 : 1;
    }

    private String getIngroupColor() {
        return ColorUtil.color2Str(this.ingroupColorPanel.getBackground());
    }

    private String getOutgroupColor() {
        return ColorUtil.color2Str(this.outgroupColorPanel.getBackground());
    }

    private boolean isSelectedRankFromGui(String string) {
        JCheckBox jCheckBox = (JCheckBox)this.taxRankCheckBoxMap.get(string);
        return jCheckBox.isSelected();
    }

    private boolean isSelectedRankFromOptionTbl(String string) {
        OptionTbl optionTbl = OptionTbl.getInstance();
        return optionTbl.getOptionValues().isSelectedRankForTaxTree(string);
    }

    private void setSelectedRankToOptionTbl(String string) {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        optionValues.setSelectedRankForTaxTree(string, this.isSelectedRankFromGui(string));
    }

    private void setRankCheckBoxEnabled(boolean bl) {
        for (JCheckBox jCheckBox : this.taxRankCheckBoxMap.values()) {
            jCheckBox.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.allButton) {
            this.setRankCheckBoxEnabled(false);
        } else if (actionEvent.getSource() == this.simpleButton) {
            this.setRankCheckBoxEnabled(true);
        }
    }
}

