/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.organism.AbstractMultiOrganism;
import cgdp.recog.organism.MergeOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismFactory;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.organism.SplitOrganism;
import cgdp.recog.organism.SplitOrganismComparator;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ModifiedOrganismManager
implements ApplicationPropertyAccessable {
    private static final ModifiedOrganismManager MODIFIED_ORGANISM_MANAGER = new ModifiedOrganismManager();
    private static final String DELIMITER = ";";
    private static final String DELIMITER_SP = ",";
    private static final String DELIMITER_MOD_SP = ":";
    private String domClustId;
    private Map mergeOrganismMap = new HashMap();
    private Map splitOrganismMap = new HashMap();
    private List tmpMergeOrganismList = new ArrayList();
    private List tmpSplitOrganismList = new ArrayList();

    public static ModifiedOrganismManager getInstance() {
        return MODIFIED_ORGANISM_MANAGER;
    }

    public void clear() {
        this.domClustId = null;
        this.mergeOrganismMap.clear();
        this.splitOrganismMap.clear();
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public void addMergeOrganism(MergeOrganism mergeOrganism) {
        this.mergeOrganismMap.put(mergeOrganism.getOrganismCode(), mergeOrganism);
    }

    public void removeMergeOrganism(MergeOrganism mergeOrganism) {
        this.mergeOrganismMap.remove(mergeOrganism.getOrganismCode());
    }

    public List getMergeOrganismList() {
        ArrayList arrayList = new ArrayList(this.mergeOrganismMap.values());
        return arrayList;
    }

    private boolean isExistMergeOrganism() {
        return !MapUtil.isNull(this.mergeOrganismMap);
    }

    private void addSplitOrganism(SplitOrganism splitOrganism) {
        this.splitOrganismMap.put(splitOrganism.getOrganismCode(), splitOrganism);
    }

    public void addAllSplitOrganism(Collection collection) {
        for (SplitOrganism splitOrganism : collection) {
            this.addSplitOrganism(splitOrganism);
        }
    }

    public List getSplitOrganismList() {
        ArrayList arrayList = new ArrayList(this.splitOrganismMap.values());
        return arrayList;
    }

    public boolean isExistSplitOrganism() {
        return !MapUtil.isNull(this.splitOrganismMap);
    }

    public void removeSplitOrganism(Collection collection) {
        for (SplitOrganism splitOrganism : collection) {
            this.splitOrganismMap.remove(splitOrganism.getOrganismCode());
        }
    }

    public void removeModifiedOrganismFile(String string, Organism organism) {
        HashSet<Organism> hashSet = new HashSet<Organism>();
        hashSet.add(organism);
        this.removeModifiedOrganismFile(string, hashSet);
    }

    public void removeModifiedOrganismFile(String string, Collection collection) {
        for (Organism organism : collection) {
            String string2 = DataManager.getDomClustChromosomeFilePath(string, organism.getOrganismCode());
            FileUtil.delete(string2);
            string2 = DataManager.getDomClustGeneFilePath(string, organism.getOrganismCode());
            FileUtil.delete(string2);
        }
    }

    public boolean isModifiledOrganismCode(String string) {
        return this.getModifiedOrganism(string) != null;
    }

    private SplitOrganism getSplitOrganism(String string) {
        return (SplitOrganism)this.splitOrganismMap.get(string);
    }

    public List convertSystemOrganismCodeList(Collection collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            Organism organism = this.getModifiedOrganism(string);
            if (organism != null) {
                for (String string2 : organism.getSystemOrganismCodeList()) {
                    arrayList.add(string2);
                }
                continue;
            }
            if (organism != null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List convertModifiedOrganismCodeList(Collection collection) {
        if (collection == null) {
            return null;
        }
        Map map = this.createSystemMergeOrganismMap();
        Map map2 = this.createSystemSplitOrganismMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            String string2 = (String)map.get(string);
            List list = (List)map2.get(string);
            if (!StringTool.isNull(string2)) {
                arrayList.add(string2);
                continue;
            }
            if (!CollectionUtil.isNull(list)) {
                arrayList.addAll(list);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private Map createSystemMergeOrganismMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MergeOrganism mergeOrganism : this.getMergeOrganismList()) {
            List list = mergeOrganism.getSystemOrganismCodeList();
            for (String string : list) {
                hashMap.put(string, mergeOrganism.getOrganismCode());
            }
        }
        return hashMap;
    }

    private Map createSystemSplitOrganismMap() {
        Map map = OrganismUtil.createSplitOrganismListMap(this.getSplitOrganismList());
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (Organism organism : map.keySet()) {
            List list = (List)map.get(organism);
            List list2 = OrganismUtil.getOrganismCodeList(list);
            hashMap.put(organism.getOrganismCode(), list2);
        }
        return hashMap;
    }

    public List getSystemOrganismCodeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Organism organism = ModifiedOrganismManager.getInstance().getModifiedOrganism(string);
        if (organism != null) {
            arrayList = new ArrayList(organism.getSystemOrganismCodeList());
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    public Organism getModifiedOrganism(String string) {
        Organism organism = this.getSplitOrganism(string);
        if (organism != null) {
            return organism;
        }
        organism = this.getMergeOrganism(string);
        if (organism != null) {
            return organism;
        }
        return null;
    }

    public Set getSplitOrganismSet(String string) {
        HashSet<SplitOrganism> hashSet = new HashSet<SplitOrganism>();
        for (SplitOrganism splitOrganism : this.splitOrganismMap.values()) {
            if (!splitOrganism.equalsParentOrganismCode(string)) continue;
            hashSet.add(splitOrganism);
        }
        return hashSet;
    }

    private List getSplitOrganismList(String string) {
        ArrayList arrayList = new ArrayList(this.getSplitOrganismSet(string));
        Collections.sort(arrayList, new SplitOrganismComparator());
        return arrayList;
    }

    private MergeOrganism getMergeOrganismByParent(String string) {
        for (MergeOrganism mergeOrganism : this.mergeOrganismMap.values()) {
            if (!mergeOrganism.containsParentOrganismCode(string)) continue;
            return mergeOrganism;
        }
        return null;
    }

    public MergeOrganism getMergeOrganism(String string) {
        return (MergeOrganism)this.mergeOrganismMap.get(string);
    }

    public List modifyTaxonomyTreeNodeList(List list) {
        Object object;
        TaxonomyTreeNode taxonomyTreeNode;
        int n;
        ArrayList<TaxonomyTreeNode> arrayList = new ArrayList<TaxonomyTreeNode>(list);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (n = 0; n < list.size(); ++n) {
            int n2;
            TaxonomyTreeNode taxonomyTreeNode2;
            taxonomyTreeNode = (TaxonomyTreeNode)list.get(n);
            if (!taxonomyTreeNode.isGenome()) continue;
            String string = taxonomyTreeNode.getAbbreviation();
            Object object2 = this.getSplitOrganismList(string);
            if (!CollectionUtil.isNull((Collection)object2)) {
                object = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    SplitOrganism splitOrganism = (SplitOrganism)iterator.next();
                    taxonomyTreeNode2 = new TaxonomyTreeNode(taxonomyTreeNode.getLevel(), splitOrganism.getNameForTaxonomy(), splitOrganism.getOrganismCode(), taxonomyTreeNode.getRank(), taxonomyTreeNode.getNo1(), taxonomyTreeNode.getNo2(), taxonomyTreeNode.getSpecWeight());
                    object.add(taxonomyTreeNode2);
                    arrayList2.add(splitOrganism.getOrganismCode());
                }
                n2 = arrayList.indexOf(taxonomyTreeNode);
                arrayList.remove(taxonomyTreeNode);
                arrayList.addAll(n2, (Collection<TaxonomyTreeNode>)object);
                hashMap.put(taxonomyTreeNode.getAbbreviation(), StringTool.conbineStrList(arrayList2, DELIMITER_SP));
                continue;
            }
            object = this.getMergeOrganismByParent(string);
            if (object == null) continue;
            if (!hashSet.contains(object)) {
                TaxonomyTreeNode taxonomyTreeNode3 = new TaxonomyTreeNode(taxonomyTreeNode.getLevel(), ((MergeOrganism)object).getNameForTaxonomy(), ((Organism)object).getOrganismCode(), taxonomyTreeNode.getRank(), taxonomyTreeNode.getNo1(), taxonomyTreeNode.getNo2(), taxonomyTreeNode.getSpecWeight());
                n2 = arrayList.indexOf(taxonomyTreeNode);
                arrayList.add(n2, taxonomyTreeNode3);
                arrayList.remove(taxonomyTreeNode);
                hashSet.add(object);
                hashMap.put(taxonomyTreeNode.getAbbreviation(), ((Organism)object).getOrganismCode());
                continue;
            }
            int n3 = 0;
            if (n < list.size() - 1) {
                TaxonomyTreeNode taxonomyTreeNode4 = (TaxonomyTreeNode)list.get(n + 1);
                n3 = taxonomyTreeNode4.getLevel();
            }
            n2 = Integer.MAX_VALUE;
            int n4 = arrayList.indexOf(taxonomyTreeNode);
            taxonomyTreeNode2 = taxonomyTreeNode;
            while (taxonomyTreeNode2.getLevel() >= n3 && taxonomyTreeNode2.getLevel() < n2) {
                arrayList.remove(taxonomyTreeNode2);
                n2 = taxonomyTreeNode2.getLevel();
                taxonomyTreeNode2 = (TaxonomyTreeNode)list.get(--n4);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            taxonomyTreeNode = (TaxonomyTreeNode)arrayList.get(n);
            if (taxonomyTreeNode.isGenome()) continue;
            for (Object object2 : hashMap.keySet()) {
                object = (String)hashMap.get(object2);
                taxonomyTreeNode.setAbbreviation(taxonomyTreeNode.getAbbreviation().replaceAll((String)object2, (String)object));
            }
        }
        return arrayList;
    }

    @Override
    public String getCategory() {
        return "ModifiedOrganism";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ModifiedOrganismMergeOrganism", this.createMergeOrganismLine()));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "ModifiedOrganismSplitOrganism", this.createSplitOrganismLine()));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2;
        if (map.containsKey("ModifiedOrganismMergeOrganism")) {
            string2 = (String)map.get("ModifiedOrganismMergeOrganism");
            this.tmpMergeOrganismList = this.createTmpMergeOrganism(string2);
        }
        if (map.containsKey("ModifiedOrganismSplitOrganism")) {
            string2 = (String)map.get("ModifiedOrganismSplitOrganism");
            this.tmpSplitOrganismList = this.createTmpSplitOrganism(string2);
        }
    }

    private String createMergeOrganismLine() {
        if (!this.isExistMergeOrganism()) {
            return "";
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getMergeOrganismList();
        for (MergeOrganism mergeOrganism : list) {
            stringBuffer.append(mergeOrganism.getOrganismCode());
            stringBuffer.append(DELIMITER_MOD_SP);
            int n2 = 0;
            for (String string : mergeOrganism.getOrganismCodeList()) {
                stringBuffer.append(string);
                if (n2 != mergeOrganism.getOrganismCount() - 1) {
                    stringBuffer.append(DELIMITER_SP);
                }
                ++n2;
            }
            if (n != list.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String createSplitOrganismLine() {
        if (!this.isExistSplitOrganism()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getSplitOrganismList();
        Map map = OrganismUtil.createSplitOrganismListMap(list);
        int n = 0;
        for (Organism organism : map.keySet()) {
            List list2 = (List)map.get(organism);
            stringBuffer.append(organism.getOrganismCode());
            stringBuffer.append(DELIMITER_MOD_SP);
            stringBuffer.append(StringTool.conbineStrList(OrganismUtil.getOrganismCodeList(list2), DELIMITER_SP));
            if (n != map.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private List createTmpMergeOrganism(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        ArrayList<MergeOrganism> arrayList = new ArrayList<MergeOrganism>();
        for (String string2 : vector) {
            Vector vector2 = StringTool.splitString(string2, DELIMITER_MOD_SP);
            String string3 = (String)vector2.get(0);
            Vector vector3 = StringTool.splitString((String)vector2.get(1), DELIMITER_SP);
            List list = OrganismUtil.getOrganismList(vector3);
            MergeOrganism mergeOrganism = OrganismFactory.createMergeOrganism(list);
            arrayList.add(mergeOrganism);
        }
        return arrayList;
    }

    private List createTmpSplitOrganism(String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        ArrayList<SplitOrganism> arrayList = new ArrayList<SplitOrganism>();
        for (String string2 : vector) {
            Vector vector2 = StringTool.splitString(string2, DELIMITER_MOD_SP);
            String string3 = (String)vector2.get(0);
            Vector vector3 = StringTool.splitString((String)vector2.get(1), DELIMITER_SP);
            Organism organism = OrganismUtil.getOrganism(string3);
            for (String string4 : vector3) {
                Vector vector4 = StringTool.splitString(string4, "-");
                int n = Integer.parseInt((String)vector4.get(1));
                SplitOrganism splitOrganism = new SplitOrganism(organism, n);
                arrayList.add(splitOrganism);
            }
        }
        return arrayList;
    }

    public void replaceOriginalOrganism(ClusterTbl clusterTbl) {
        Object object;
        Object object2;
        for (Organism organism : this.tmpMergeOrganismList) {
            object2 = ((AbstractMultiOrganism)organism).getOrganismCodeList();
            object = clusterTbl.getOrganismList((Collection)object2);
            ((MergeOrganism)organism).setOrganismList((List)object);
            this.addMergeOrganism((MergeOrganism)organism);
        }
        this.tmpMergeOrganismList.clear();
        for (Organism organism : this.tmpSplitOrganismList) {
            object2 = ((SplitOrganism)organism).getParentOrganism().getOrganismCode();
            object = clusterTbl.getOrganism((String)object2);
            ((SplitOrganism)organism).setParentOrganism((Organism)object);
            this.addSplitOrganism((SplitOrganism)organism);
        }
        this.tmpSplitOrganismList.clear();
    }
}

