/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.Chromosome;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Organism {
    public static final int NORMAL = 1;
    public static final int INGROUP = 2;
    public static final int OUTGROUP = 3;
    protected static final int TYPE_ORGANISM = 1;
    protected static final int TYPE_MERGE_ORGANISM = 2;
    protected static final int TYPE_SPLIT_ORGANISM = 3;
    protected static final int TYPE_SET_ORGANISM = 4;
    private int type;
    private String organismCode;
    private String orgname;
    private String abbrev;
    private String strain;
    private int groupType;
    private Map chromosomeShapeMap;

    public Organism() {
        this.setType(1);
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public boolean isTypeOrganism() {
        return this.getType() == 1;
    }

    public boolean isTypeMergeOrganism() {
        return this.getType() == 2;
    }

    public boolean isTypeSplitOrganism() {
        return this.getType() == 3;
    }

    public boolean isTypeSetOrganism() {
        return this.getType() == 4;
    }

    public String getOrganismCode() {
        return this.organismCode;
    }

    public void setOrganismCode(String string) {
        this.organismCode = string;
    }

    public List getSystemOrganismCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getOrganismCode());
        return arrayList;
    }

    public String getName() {
        return this.orgname;
    }

    public void setName(String string) {
        this.orgname = string;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String string) {
        this.abbrev = string;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String string) {
        this.strain = string;
    }

    public String getNameForTaxonomy() {
        return this.getName() + " " + this.getStrain();
    }

    public String getChromosomeShape(int n) {
        return (String)this.chromosomeShapeMap.get(new Integer(n));
    }

    Map getChromosomeShapeMap() {
        return this.chromosomeShapeMap;
    }

    public void setChromosomeShapeMap(Map map) {
        this.chromosomeShapeMap = map;
    }

    public boolean isCircular(int n) {
        return Chromosome.isCircular(this.getChromosomeShape(n));
    }

    public void setNormal() {
        this.groupType = 1;
    }

    public void setIngroup() {
        this.groupType = 2;
    }

    public void setOutgroup() {
        this.groupType = 3;
    }

    public boolean isNormal() {
        return this.groupType == 1;
    }

    public boolean isIngroup() {
        return this.groupType == 2;
    }

    public boolean isOutgroup() {
        return this.groupType == 3;
    }

    void setGroupType(int n) {
        this.groupType = n;
    }

    int getGroupType() {
        return this.groupType;
    }

    public String getDisplayOrganismName() {
        return this.getAbbrev() + " " + this.getStrain();
    }

    public String getToolTipString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append(this.getNameForTaxonomy());
        stringBuffer.append("(" + this.getOrganismCode() + ")");
        stringBuffer.append("</HTML>");
        return stringBuffer.toString();
    }

    public boolean equalsOrganism(Organism organism) {
        if (organism == null) {
            return false;
        }
        return this.organismCode.equals(organism.getOrganismCode());
    }

    public boolean equalsOrganismCode(String string) {
        if (string == null) {
            return false;
        }
        return this.organismCode.equals(string);
    }
}

