/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.MultiOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.MapUtil;
import java.util.Comparator;
import java.util.Map;

public class OrganismComparator
implements Comparator {
    private Map organismCodeIndexMap;

    public OrganismComparator() {
    }

    public OrganismComparator(Map map) {
        this.organismCodeIndexMap = map;
    }

    public int compare(Object object, Object object2) {
        Organism organism = (Organism)object;
        Organism organism2 = (Organism)object2;
        if (organism instanceof MultiOrganism && !(organism2 instanceof MultiOrganism)) {
            return -1;
        }
        if (!(organism instanceof MultiOrganism) && organism2 instanceof MultiOrganism) {
            return 1;
        }
        if (organism instanceof MultiOrganism && organism2 instanceof MultiOrganism) {
            return organism.getDisplayOrganismName().compareTo(organism2.getDisplayOrganismName());
        }
        if (organism.isIngroup() && organism2.isOutgroup()) {
            return -1;
        }
        if (organism.isOutgroup() && organism2.isIngroup()) {
            return 1;
        }
        if (!MapUtil.isNull(this.organismCodeIndexMap)) {
            Integer n = (Integer)this.organismCodeIndexMap.get(organism.getOrganismCode());
            Integer n2 = (Integer)this.organismCodeIndexMap.get(organism2.getOrganismCode());
            if (n != null && n2 != null) {
                return n.compareTo(n2);
            }
            if (n == null && n2 != null) {
                return -1;
            }
            if (n != null && n2 == null) {
                return 1;
            }
        }
        return organism.getName().compareTo(organism2.getName());
    }
}

