/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterMenuFactory;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismDeleteItem;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetDeleteItem;
import cgdp.recog.organism.OrganismSetEditItem;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.organism.OrganismSetTreeNode;
import cgdp.recog.organism.OrganismTreeNode;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.OrganismColorMenu;
import cgdp.recog.tree.AbstractTreeController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class OrganismSetTreeController
extends AbstractTreeController
implements ActionListener {
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public OrganismSetTreeController(Component component, MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        Object object;
        Object object2;
        if (this.clusterTbl == null) {
            return null;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowOrganismSetMenu(treePathArray)) {
            object2 = this.getOrganismSetList(treePathArray);
            object = (OrganismSet)object2.get(0);
            HashSet hashSet = new HashSet(((OrganismSet)object).getOrganismCodeList());
            Map map = OrganismUtil.createOrganismNameMap(hashSet);
            FilterMenuFactory.createTaxonomyMenu(this, this.mediator, this.clusterTbl, ((OrganismSet)object).getName(), hashSet, map, jPopupMenu);
            jPopupMenu.add(new OrganismColorMenu(actionListener, this.mediator, this.getOrganismCodeSet((Collection)object2)));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new OrganismSetEditItem(actionListener, this.mediator, (OrganismSet)object));
            jPopupMenu.add(new OrganismSetDeleteItem(actionListener, this.mediator, (Collection)object2));
        }
        if (this.isShowOrganismMenu(treePathArray)) {
            object2 = this.getOrganismSet(treePathArray[0]);
            object = this.getOrganismList(treePathArray);
            jPopupMenu.add(new OrganismColorMenu(actionListener, this.mediator, new HashSet(OrganismUtil.getOrganismCodeList((Collection)object))));
            jPopupMenu.add(new OrganismSetEditItem(actionListener, this.mediator, (OrganismSet)object2));
            jPopupMenu.add(new OrganismDeleteItem(actionListener, this.mediator, (OrganismSet)object2, (Collection)object));
        }
        return jPopupMenu;
    }

    private Set getOrganismCodeSet(Collection collection) {
        HashSet hashSet = new HashSet();
        for (OrganismSet organismSet : collection) {
            hashSet.addAll(organismSet.getOrganismCodeList());
        }
        return hashSet;
    }

    private List getOrganismSetList(TreePath[] treePathArray) {
        ArrayList<OrganismSet> arrayList = new ArrayList<OrganismSet>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof OrganismSetTreeNode)) continue;
            OrganismSetTreeNode organismSetTreeNode = (OrganismSetTreeNode)defaultMutableTreeNode;
            arrayList.add(organismSetTreeNode.getOrganismSet());
        }
        return arrayList;
    }

    private OrganismSet getOrganismSet(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode instanceof OrganismSetTreeNode) {
            OrganismSetTreeNode organismSetTreeNode = (OrganismSetTreeNode)defaultMutableTreeNode;
            return organismSetTreeNode.getOrganismSet();
        }
        if (defaultMutableTreeNode instanceof OrganismTreeNode) {
            OrganismSetTreeNode organismSetTreeNode = (OrganismSetTreeNode)defaultMutableTreeNode.getParent();
            return organismSetTreeNode.getOrganismSet();
        }
        return null;
    }

    private List getOrganismList(TreePath[] treePathArray) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)defaultMutableTreeNode;
            arrayList.add(organismTreeNode.getOrganism());
        }
        return arrayList;
    }

    @Override
    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
        for (OrganismSet organismSet : organismSetGroup.getOrganismSetList()) {
            OrganismSetTreeNode organismSetTreeNode = new OrganismSetTreeNode(organismSet);
            defaultMutableTreeNode.add(organismSetTreeNode);
        }
    }

    private boolean isShowOrganismSetMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(1);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(2);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            if (!(defaultMutableTreeNode2 instanceof OrganismSetTreeNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (ControlTitleType.isOrganismSet(controlTitleNode.getControlTitleType())) continue;
            return false;
        }
        return true;
    }

    private boolean isShowOrganismMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 4) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(1);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[i].getPathComponent(3);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            if (!(defaultMutableTreeNode2 instanceof OrganismTreeNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (ControlTitleType.isOrganismSet(controlTitleNode.getControlTitleType())) continue;
            return false;
        }
        return true;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!(defaultMutableTreeNode instanceof OrganismSetTreeNode)) {
            return;
        }
        OrganismSetTreeNode organismSetTreeNode = (OrganismSetTreeNode)defaultMutableTreeNode;
        OrganismSet organismSet = organismSetTreeNode.getOrganismSet();
        this.mediator.showOrganismSetDialog(organismSet);
    }

    public void actionAfterClick(List list) {
        Set set = this.getOrganismCodeSetFromNodeList(list);
        this.mediator.setSelectedOrganism(set, this);
    }

    private Set getOrganismCodeSetFromNodeList(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            if (defaultMutableTreeNode instanceof OrganismSetTreeNode) {
                defaultMutableTreeNode2 = (OrganismSetTreeNode)defaultMutableTreeNode;
                OrganismSet organismSet = ((OrganismSetTreeNode)defaultMutableTreeNode2).getOrganismSet();
                hashSet.addAll(organismSet.getOrganismCodeList());
                continue;
            }
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            defaultMutableTreeNode2 = (OrganismTreeNode)defaultMutableTreeNode;
            hashSet.add(((OrganismTreeNode)defaultMutableTreeNode2).getOrganism().getOrganismCode());
        }
        return hashSet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

