/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.organism.Organism;
import cgdp.recog.search.GeneSearchCondition;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AbstractListSelectTableModel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ListControlTableModel;
import cgdp.recog.util.ListSelectPanel;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class OrganismSplitDialog2
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(OrganismSplitDialog2.class);
    private static final String OTHER_ITEM = "##OTHER";
    private static final String OTHER_NAME = "Other";
    private static final String TITLE = "Split Organism";
    private static final String[] EXCLUDE_GENE_INFO_KEYS = new String[]{"aalen", "protid", "chrid", "descr", "to1", "gene", "locustag", "name", "sp", "gi", "geneid", "type", "from1"};
    private List clusterList;
    private JLabel organismLabel;
    private Organism organism;
    private InfoTitleComboBox infoTitleComboBox;
    private ListSelectPanel valueSelectPanel;
    private SourceValueTableModel sourceValueTableModel;
    private TargetValueTableModel targetValueTableModel;
    private List valueList;

    public OrganismSplitDialog2(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        JLabel jLabel = new JLabel("Organism");
        this.organismLabel = new JLabel();
        JLabel jLabel2 = new JLabel("Property");
        this.infoTitleComboBox = new InfoTitleComboBox();
        this.infoTitleComboBox.addItemListener(this);
        this.sourceValueTableModel = new SourceValueTableModel();
        this.targetValueTableModel = new TargetValueTableModel();
        this.valueSelectPanel = new ListSelectPanel(this.sourceValueTableModel, this.targetValueTableModel, true);
        this.valueSelectPanel.setSelectColumnWidth(0, 60);
        this.valueSelectPanel.setSelectSize(300, 200);
        this.valueSelectPanel.setCandidateSize(300, 200);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.organismLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.infoTitleComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.valueSelectPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(Organism organism, List list, List list2) {
        this.clusterList = new ArrayList(list2);
        this.organism = organism;
        this.organismLabel.setText(organism.getNameForTaxonomy());
        this.infoTitleComboBox.removeItemListener(this);
        this.updateInfoTitle(organism.getOrganismCode());
        this.infoTitleComboBox.addItemListener(this);
        this.updateValueList();
    }

    private void updateInfoTitle(String string) {
        List list = GeneInfoFacade.getGeneInfoTitleList(string);
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        for (AbstractInfoTitle abstractInfoTitle : list) {
            if (!this.isIncludeTitle(abstractInfoTitle)) continue;
            arrayList.add(abstractInfoTitle);
        }
        this.infoTitleComboBox.updateInfoTitleItems(arrayList);
    }

    private boolean isIncludeTitle(AbstractInfoTitle abstractInfoTitle) {
        for (int i = 0; i < EXCLUDE_GENE_INFO_KEYS.length; ++i) {
            if (!EXCLUDE_GENE_INFO_KEYS[i].equals(abstractInfoTitle.getKey())) continue;
            return false;
        }
        return true;
    }

    private void updateValueList() {
        try {
            this.valueList = new ArrayList(new HashSet(GeneInfoFacade.createValueList(this.clusterList, this.getOrganism().getOrganismCode(), (GeneInfoTitle)this.getInfoTitle())));
            Map map = this.createValueCountMap(this.valueList);
            Collections.sort(this.valueList, new ValueCountComparator(map));
            this.targetValueTableModel.setDataList(this.valueList);
            this.sourceValueTableModel.setDataList(new ArrayList());
        }
        catch (Exception exception) {
            String string = "Fail to load gene property. " + this.getInfoTitle().getName();
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    private Map createValueCountMap(List list) {
        HashMap hashMap = new HashMap();
        for (Object e : list) {
            int n = 0;
            Integer n2 = (Integer)hashMap.get(e);
            if (n2 != null) {
                n = n2;
            }
            hashMap.put(e, new Integer(++n));
        }
        return hashMap;
    }

    private Organism getOrganism() {
        return this.organism;
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.infoTitleComboBox.getSelectedInfoTitle();
    }

    public List getSearchConditionList() {
        ArrayList<GeneSearchCondition> arrayList = new ArrayList<GeneSearchCondition>();
        List list = this.getValueList();
        for (Object e : list) {
            SearchConditionItem searchConditionItem = new SearchConditionItem();
            searchConditionItem.setJoinKey("or");
            searchConditionItem.setInfoTitle(this.getInfoTitle());
            searchConditionItem.setValue(String.valueOf(e));
            searchConditionItem.setMultiInfoType(6);
            ArrayList<SearchConditionItem> arrayList2 = new ArrayList<SearchConditionItem>();
            arrayList2.add(searchConditionItem);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.getOrganism().getOrganismCode());
            GeneSearchCondition geneSearchCondition = new GeneSearchCondition();
            geneSearchCondition.setOrganismCodeSet(hashSet);
            geneSearchCondition.setExecServer(false);
            geneSearchCondition.setConditionItemList(arrayList2);
            arrayList.add(geneSearchCondition);
        }
        return arrayList;
    }

    private List getValueList() {
        List list = this.targetValueTableModel.getDataList();
        return list;
    }

    @Override
    protected boolean check() {
        if (this.getValueList().size() <= 1) {
            String string = "Input value.";
            MessageManager.showErrorMessage((Component)this, string);
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.infoTitleComboBox) {
            this.updateValueList();
        }
    }

    private class ValueCountComparator
    implements Comparator {
        private Map valueCountMap = new HashMap();

        public ValueCountComparator(Map map) {
            this.valueCountMap = map;
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)this.valueCountMap.get(object);
            Integer n2 = (Integer)this.valueCountMap.get(object2);
            int n3 = 0;
            if (n != null) {
                n3 = n;
            }
            int n4 = 0;
            if (n2 != null) {
                n4 = n2;
            }
            return n4 - n3;
        }
    }

    private class TargetValueTableModel
    extends AbstractListSelectTableModel
    implements ListControlTableModel {
        private List valueList = new ArrayList();

        private TargetValueTableModel() {
        }

        @Override
        public int indexOf(Object object) {
            return this.valueList.indexOf(object);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = this.getData(n);
            if (n2 == 0) {
                return OrganismSplitDialog2.this.getOrganism().getOrganismCode() + "-" + n;
            }
            if (n2 == 1) {
                if (object != null && object.equals(OrganismSplitDialog2.OTHER_ITEM)) {
                    return OrganismSplitDialog2.OTHER_NAME;
                }
                return object;
            }
            return null;
        }

        @Override
        protected void removeAfter() {
        }

        @Override
        protected void selectAfter() {
        }
    }

    private class SourceValueTableModel
    extends AbstractListSelectTableModel {
        private List valueList = new ArrayList();

        private SourceValueTableModel() {
        }

        @Override
        public int indexOf(Object object) {
            return this.valueList.indexOf(object);
        }

        @Override
        protected void removeAfter() {
        }

        @Override
        protected void selectAfter() {
        }
    }
}

