/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismNameType;
import cgdp.recog.organism.OrganismUtil;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class OrganismViewModel {
    public static final int DEFAULT_ORGANISM_NAME_TYPE = 2;
    public static final boolean DEFAULT_ADD_STRAIN_TO_NAME = true;
    private int organismNameType = 2;
    private boolean addStrainToName = true;
    private List viewOrganismList = new ArrayList();

    public List getViewOrganismList() {
        return this.viewOrganismList;
    }

    public Organism getOrganism(String string) {
        Organism organism = null;
        for (Organism organism2 : this.viewOrganismList) {
            if (!organism2.equalsOrganismCode(string)) continue;
            organism = organism2;
            break;
        }
        return organism;
    }

    public int indexOfOrganismCode(String string) {
        int n = -1;
        int n2 = 0;
        for (Organism organism : this.viewOrganismList) {
            if (organism.equalsOrganismCode(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public int getViewOrganismCount() {
        return this.viewOrganismList.size();
    }

    public void setViewOrganismList(List list) {
        this.viewOrganismList = list;
    }

    public int getOrganismNameType() {
        return this.organismNameType;
    }

    public boolean isOrganismNameTypeNormal() {
        return OrganismNameType.isOrganismNameTypeNormal(this.getOrganismNameType());
    }

    public boolean isOrganismNameTypeAbbrev() {
        return OrganismNameType.isOrganismNameTypeAbbrev(this.getOrganismNameType());
    }

    public void setOrganismNameType(int n) {
        this.organismNameType = n;
    }

    public boolean isAddStrainToName() {
        return this.addStrainToName;
    }

    public void setAddStrainToName(boolean bl) {
        this.addStrainToName = bl;
    }

    public List getViewOrganismNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : this.viewOrganismList) {
            arrayList.add(this.getDisplayOrganisnName(organism));
        }
        return arrayList;
    }

    public List getViewOrganismCodeList() {
        return OrganismUtil.getOrganismCodeList(this.viewOrganismList);
    }

    public String getViewOrganismCode(int n) {
        if (n < 0 || n >= this.getViewOrganismCount()) {
            return null;
        }
        Organism organism = (Organism)this.viewOrganismList.get(n);
        return organism.getOrganismCode();
    }

    public String getDisplayOrganisnName(Organism organism) {
        String string = "";
        string = this.isOrganismNameTypeNormal() ? organism.getName() : organism.getAbbrev();
        if (this.isAddStrainToName()) {
            string = string + " " + organism.getStrain();
        }
        return string;
    }

    public double calcOrganismNameWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (String string : this.getViewOrganismNameList()) {
            int n2 = fontMetrics.stringWidth(string);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public int indexOfOrganism(String string) {
        for (int i = 0; i < this.getViewOrganismCount(); ++i) {
            Organism organism = (Organism)this.getViewOrganismList().get(i);
            if (!organism.equalsOrganismCode(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isViewOrganism(Organism organism) {
        return this.indexOfOrganism(organism.getOrganismCode()) != -1;
    }
}

