/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.Organism;
import cgdp.recog.util.AbstractListSelectTableModel;
import java.util.Iterator;
import java.util.List;

public class TargetOrganismTableModel
extends AbstractListSelectTableModel {
    private Organism referenceOrganism;
    private int columnCount = 3;

    public TargetOrganismTableModel(List list, Organism organism) {
        super(list);
        this.referenceOrganism = organism;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 2) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Organism organism = (Organism)this.dataList.get(n);
        switch (n2) {
            case 0: {
                if (organism.isIngroup()) {
                    return "IN";
                }
                if (organism.isOutgroup()) {
                    return "OUT";
                }
                return "";
            }
            case 1: {
                return organism.getAbbrev() + " " + organism.getStrain();
            }
            case 2: {
                return new Boolean(organism.equalsOrganism(this.referenceOrganism));
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 2) {
            return;
        }
        Organism organism = (Organism)this.dataList.get(n);
        boolean bl = (Boolean)object;
        if (bl) {
            this.referenceOrganism = organism;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    @Override
    public int indexOf(Object object) {
        Organism organism;
        Organism organism2 = (Organism)object;
        int n = 0;
        Iterator iterator = this.dataList.iterator();
        while (iterator.hasNext() && !(organism = (Organism)iterator.next()).equalsOrganism(organism2)) {
            ++n;
        }
        return n;
    }

    @Override
    protected void selectAfter() {
        if (this.referenceOrganism == null && this.getRowCount() != 0) {
            this.referenceOrganism = (Organism)this.dataList.get(0);
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }
    }

    @Override
    protected void removeAfter() {
        if (!this.containsOrganism(this.referenceOrganism)) {
            if (this.getRowCount() == 0) {
                this.referenceOrganism = null;
            } else {
                this.referenceOrganism = (Organism)this.dataList.get(0);
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }
    }

    private boolean containsOrganism(Organism organism) {
        for (Organism organism2 : this.dataList) {
            if (!organism2.equalsOrganism(organism)) continue;
            return true;
        }
        return false;
    }

    public Organism getReferenceOrganism() {
        return this.referenceOrganism;
    }

    public void setReferenceOrganism(Organism organism) {
        this.referenceOrganism = organism;
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void setShowReferenceGenome(boolean bl) {
        this.columnCount = bl ? 3 : 2;
    }
}

