/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.patch;

import cgdp.recog.bean.Const;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.InfoTitleKeyComparator;
import cgdp.recog.info.cluster.ClusterInfoConfExporter;
import cgdp.recog.info.cluster.ClusterInfoConfImporter;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.patch.AbstractPatch;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserGeneInfoAddConfPatch
extends AbstractPatch {
    private static final ApplicationLogger logger = new ApplicationLogger(UserGeneInfoAddConfPatch.class);

    @Override
    protected String getPatchReleaseDateString() {
        return "2009/9/25";
    }

    @Override
    public void execute() {
        List list = UserGeneInfoAddConfPatch.getAllGeneInfoTitleList();
        Collections.sort(list, new InfoTitleKeyComparator(GeneInfoTitle.getSystemGeneInfoTitleKeyList()));
        try {
            GeneInfoFacade.exportTitleList(list);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save gene properties to gene_info file.", iOException);
        }
        List list2 = UserGeneInfoAddConfPatch.getClusterInfoTitleList();
        try {
            this.exportTitleList(list2);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save cluster properties to gene_info file.", iOException);
        }
    }

    public static List getAllGeneInfoTitleList() {
        try {
            ArrayList arrayList;
            File[] fileArray2;
            HashMap<String, File[]> hashMap = new HashMap<String, File[]>();
            List list = GeneInfoFacade.getGeneInfoTitleList();
            for (File[] fileArray2 : list) {
                String string = UserGeneInfoAddConfPatch.createKey((GeneInfoTitle)fileArray2);
                hashMap.put(string, fileArray2);
            }
            File file = new File(DataManager.getUserDefDataGeneInfoDirpath());
            fileArray2 = file.listFiles();
            if (file != null) {
                for (int i = 0; i < fileArray2.length; ++i) {
                    arrayList = UserGeneInfoAddConfPatch.getOrganismCodeFromFileName(fileArray2[i].getName());
                    Object object = GeneInfoFacade.importUserDefGeneInfoTitleList(fileArray2[i].getAbsolutePath(), "Global");
                    UserGeneInfoAddConfPatch.putGeneInfoTitleMap(arrayList, (List)object, hashMap);
                }
            }
            List list2 = ProjectAccesser.loadProject();
            for (Object object : list2) {
                File file2 = new File(DataManager.getUserDefProjectGeneInfoDirpath((Project)object));
                File[] fileArray3 = file2.listFiles();
                if (fileArray3 == null) continue;
                for (int i = 0; i < fileArray3.length; ++i) {
                    String string = UserGeneInfoAddConfPatch.getOrganismCodeFromFileName(fileArray3[i].getName());
                    List list3 = GeneInfoFacade.importUserDefGeneInfoTitleList(fileArray3[i].getAbsolutePath(), ((Project)object).getProjectName());
                    UserGeneInfoAddConfPatch.putGeneInfoTitleMap(string, list3, hashMap);
                }
            }
            arrayList = new ArrayList();
            arrayList.addAll(hashMap.values());
            return arrayList;
        }
        catch (Exception exception) {
            logger.warn("Fail to load gene propety files.", exception);
            return new ArrayList();
        }
    }

    private static String getOrganismCodeFromFileName(String string) {
        return string.replaceAll(".dat", "");
    }

    private static String createKey(GeneInfoTitle geneInfoTitle) {
        return geneInfoTitle.getKey() + geneInfoTitle.getLocationName();
    }

    private static void putGeneInfoTitleMap(String string, List list, Map map) {
        for (GeneInfoTitle geneInfoTitle : list) {
            String string2 = UserGeneInfoAddConfPatch.createKey(geneInfoTitle);
            GeneInfoTitle geneInfoTitle2 = (GeneInfoTitle)map.get(string2);
            if (geneInfoTitle2 != null && geneInfoTitle2.equalsLocation(geneInfoTitle.getLocationName())) {
                geneInfoTitle = geneInfoTitle2;
                if (!geneInfoTitle.isEditable()) {
                    continue;
                }
            } else {
                map.put(string2, geneInfoTitle);
            }
            geneInfoTitle.addOrganismCode(string);
        }
    }

    private static List getClusterInfoTitleList() {
        try {
            String string = Const.BASE_CLUSTER_INFO_PATH;
            ClusterInfoConfImporter clusterInfoConfImporter = new ClusterInfoConfImporter(string);
            clusterInfoConfImporter.execute();
            List list = clusterInfoConfImporter.getInfoTitleList();
            return list;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load cluster_info.", iOException);
            return new ArrayList();
        }
    }

    public void exportTitleList(List list) throws IOException {
        ClusterInfoConfExporter clusterInfoConfExporter = new ClusterInfoConfExporter(list);
        clusterInfoConfExporter.execute();
    }
}

