/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetComboBox;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternFacade;
import cgdp.recog.pattern.PatternTableCellRenderer;
import cgdp.recog.pattern.PatternTableModel;
import cgdp.recog.pattern.PatternUtil;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class PatternEditDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(PatternEditDialog.class);
    private static PatternEditDialog PATTERN_EDIT_DIALOG;
    private static final String TITLE = "Register Phylogenetic Pattern";
    private FocusTextField nameTextField;
    private OrganismSetComboBox organismSetComboBox;
    private JTable patternTable;
    private PatternTableCellRenderer patternTableCellRenderer;
    private JRadioButton valueButton;
    private JRadioButton ignoreButton;
    private RestrictTextField valueTextField;
    private JButton setButton;
    private Pattern basePattern;
    private String domClustId;

    public PatternEditDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void createInstance(Frame frame) {
        PATTERN_EDIT_DIALOG = new PatternEditDialog(frame);
    }

    public static PatternEditDialog getInstance() {
        return PATTERN_EDIT_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.organismSetComboBox = new OrganismSetComboBox();
        this.organismSetComboBox.addItemListener(this);
        this.organismSetComboBox.addActionListener(this);
        this.patternTableCellRenderer = new PatternTableCellRenderer();
        this.patternTable = new JTable(new PatternTableModel());
        this.patternTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PatternEditDialog.this.setEnableParts();
                PatternEditDialog.this.setValue();
            }
        });
        TableColumn tableColumn = this.patternTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        TableColumn tableColumn2 = this.patternTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(50);
        tableColumn2.setCellRenderer(this.patternTableCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.patternTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(300, 200));
        JPanel jPanel = this.createControlPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Setting Value"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createNamePanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(15, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.organismSetComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 15, 5, 5), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 15, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(15, 5, 15, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNamePanel() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        return jPanel;
    }

    private JPanel createControlPanel() {
        this.setButton = new JButton("Set value");
        this.setButton.addActionListener(this);
        this.valueButton = new JRadioButton("Value");
        this.ignoreButton = new JRadioButton("Ignore");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.valueButton);
        buttonGroup.add(this.ignoreButton);
        this.valueButton.setSelected(true);
        this.valueTextField = new RestrictTextField(5);
        this.valueTextField.setDecimal(true);
        this.valueTextField.setNegative(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.valueButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        jPanel.add((Component)this.valueTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.ignoreButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        jPanel.add((Component)this.setButton, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 20, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(Pattern pattern, List list, String string) {
        this.basePattern = pattern;
        this.domClustId = string;
        this.nameTextField.setText(pattern.getName());
        Pattern pattern2 = (Pattern)pattern.clone();
        this.getPatternTableModel().updatePattern(pattern2, list);
        List list2 = OrganismUtil.getOrganismCodeList(list);
        this.patternTableCellRenderer.setOrganismCodeList(list2);
        this.organismSetComboBox.removeItemListener(this);
        this.organismSetComboBox.removeActionListener(this);
        this.organismSetComboBox.updateOrganismSetItem();
        this.organismSetComboBox.addItemListener(this);
        this.organismSetComboBox.addActionListener(this);
    }

    private PatternTableModel getPatternTableModel() {
        return (PatternTableModel)this.patternTable.getModel();
    }

    private void setEnableParts() {
        boolean bl = this.patternTable.getSelectedRowCount() != 0;
        this.valueButton.setEnabled(bl);
        this.ignoreButton.setEnabled(bl);
        this.setButton.setEnabled(bl);
        this.valueTextField.setEditable(bl);
        this.valueTextField.setEnabled(bl);
    }

    private String getPatternName() {
        return this.nameTextField.getText();
    }

    private double getValue() {
        return Double.parseDouble(this.valueTextField.getText());
    }

    private boolean isValue() {
        return this.valueButton.isSelected();
    }

    private boolean isIgnore() {
        return this.ignoreButton.isSelected();
    }

    private void setValue() {
        int n = this.patternTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        double d = this.getPatternTableModel().getValue(n);
        this.valueTextField.setText(String.valueOf(d));
        boolean bl = this.getPatternTableModel().isIgnore(n);
        if (bl) {
            this.ignoreButton.setSelected(true);
        } else {
            this.valueButton.setSelected(true);
        }
    }

    private void updateValue() {
        int[] nArray = this.patternTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Set set = this.getPatternTableModel().getOrganismCode(nArray);
        if (this.isValue()) {
            double d = 1.0;
            try {
                d = this.getValue();
            }
            catch (NumberFormatException numberFormatException) {
                String string = "Input value.";
                MessageManager.showErrorMessage((Component)this, string);
                return;
            }
            this.getPatternTableModel().setValue(set, d);
        } else if (this.isIgnore()) {
            this.getPatternTableModel().setIgnore(set, true);
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.patternTable.addRowSelectionInterval(nArray[i], nArray[i]);
        }
    }

    private void selectedOrganismByOrganismSet() {
        OrganismSet organismSet = this.organismSetComboBox.getOrganismSet();
        this.patternTable.clearSelection();
        List list = this.getPatternTableModel().getOrganismCodeList();
        for (String string : organismSet.getOrganismCodeList()) {
            int n = list.indexOf(string);
            if (n == -1) continue;
            this.patternTable.addRowSelectionInterval(n, n);
        }
    }

    public Pattern getPattern() {
        Pattern pattern = this.getPatternTableModel().getPattern();
        pattern.setName(this.getPatternName());
        return pattern;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.setButton) {
            this.updateValue();
        } else if (actionEvent.getSource() == this.organismSetComboBox) {
            this.selectedOrganismByOrganismSet();
        }
    }

    @Override
    protected boolean check() {
        if (StringTool.isNull(this.getPatternName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        try {
            Pattern pattern = this.getPattern();
            List list = PatternFacade.getPatternList(this.domClustId);
            if (PatternUtil.containsPatternName(pattern, list) && (this.basePattern == null || this.basePattern != null && !this.basePattern.equalsName(pattern))) {
                String[] stringArray = new String[]{"This name is overlapping with other pattern name.", "Input another name."};
                MessageManager.showErrorMessage((Component)this, stringArray);
                return false;
            }
        }
        catch (IOException iOException) {
            String string = "Fail to load pattern file";
            logger.warn(string, iOException);
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismSetComboBox) {
            this.selectedOrganismByOrganismSet();
        }
    }
}

