/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.pattern.Pattern;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import java.util.List;

public class PatternExporter
extends FileExporter {
    private static final String TITLE_PATTERN = "Pattern";
    private static final String PREFIX_NAME = "#NAME";
    private static final String DELIMITER_PARAM = "\t";
    private static final String DELIMITER_SP = ":";
    private static final String DELIMITER_PATTERN = "//";
    private List patternList;
    private String filepath;

    public PatternExporter(List list, String string) {
        this.filepath = string;
        this.patternList = list;
    }

    @Override
    protected String getContents() {
        return PatternExporter.condition2Str(this.patternList);
    }

    public static String condition2Str(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Pattern pattern : list) {
            stringBuffer.append(TITLE_PATTERN);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(PatternExporter.createParameterString(PREFIX_NAME, pattern.getName()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(PatternExporter.createPatternString(pattern));
            stringBuffer.append(DELIMITER_PATTERN);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String createParameterString(String string, String string2) {
        return string + DELIMITER_PARAM + string2;
    }

    private static String createPatternString(Pattern pattern) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (String string : pattern.getOrganismCodeList()) {
            stringBuffer.append(string);
            stringBuffer.append(DELIMITER_SP);
            stringBuffer.append(pattern.getValue(string));
            stringBuffer.append(DELIMITER_SP);
            stringBuffer.append(pattern.isIgnore(string));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

