/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.data.DataManager;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternExporter;
import cgdp.recog.pattern.PatternGroup;
import cgdp.recog.pattern.PatternImporter;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PatternFacade {
    private PatternFacade() {
    }

    public static List getPatternList(String string, Set set) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        return PatternFacade.getPatternList(project, string, set);
    }

    public static List getPatternList(Project project, String string, Set set) throws IOException {
        List list = PatternFacade.getPatternList(project, string);
        return PatternFacade.filterPatternList(list, set);
    }

    private static List filterPatternList(List list, Set set) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (Pattern pattern : list) {
            if (!set.containsAll(pattern.getOrganismCodeSet())) continue;
            arrayList.add(pattern);
        }
        return arrayList;
    }

    public static List getPatternList(String string) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        return PatternFacade.getPatternList(project, string);
    }

    public static List getPatternList(Project project, String string) throws IOException {
        String string2 = DataManager.getPatternFilepath(project, string);
        if (!new File(string2).isFile()) {
            return new ArrayList();
        }
        PatternImporter patternImporter = new PatternImporter(string2);
        patternImporter.execute();
        List list = patternImporter.getPatternList();
        return list;
    }

    static void savePatternList(PatternGroup patternGroup) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        PatternFacade.savePatternList(project, patternGroup);
    }

    private static void savePatternList(Project project, PatternGroup patternGroup) throws IOException {
        List list = PatternFacade.getPatternList(project, patternGroup.getDomClustId());
        List list2 = PatternFacade.filterPatternList(list, patternGroup.getOrganismCodeSet());
        list.removeAll(list2);
        list.addAll(patternGroup.getPatternList());
        String string = DataManager.getPatternFilepath(project, patternGroup.getDomClustId());
        PatternExporter patternExporter = new PatternExporter(list, string);
        patternExporter.execute();
    }
}

