/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.calc.AbstractCalcCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.cell.CellInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.LocusTagComparator;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternException;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatternFactory {
    private static final double NO_VALUE = Double.MAX_VALUE;

    private PatternFactory() {
    }

    public static Pattern createNumericPattern(List list, Cluster cluster, AbstractCalcCondition abstractCalcCondition) {
        return PatternFactory.createNumericPattern(list, list, cluster, abstractCalcCondition, null);
    }

    public static Pattern createNumericPattern(Pattern pattern, List list, Cluster cluster, AbstractCalcCondition abstractCalcCondition) {
        List list2 = pattern.getOrganismCodeListWithoutIgnore();
        Set set = pattern.getIgnoreOrganismCodeSet();
        return PatternFactory.createNumericPattern(list2, list2, cluster, abstractCalcCondition, set);
    }

    private static Pattern createNumericPattern(List list, List list2, Cluster cluster, AbstractCalcCondition abstractCalcCondition, Set set) {
        double d = 0.0;
        if (abstractCalcCondition.isAverage() || abstractCalcCondition.isAverageGene()) {
            try {
                d = PatternFactory.calcAverage(list, cluster, abstractCalcCondition);
            }
            catch (PatternException patternException) {
                return null;
            }
        }
        Pattern pattern = new Pattern();
        for (String string : list2) {
            if (!CollectionUtil.isNull(set) && set.contains(string)) {
                pattern.addOrganism(string, Double.NaN, true);
                continue;
            }
            if (cluster.containsSp(string)) {
                Float f = PatternFactory.getValue(string, cluster, abstractCalcCondition);
                if (f != null) {
                    pattern.addOrganism(string, f.doubleValue(), f.isNaN());
                    continue;
                }
                PatternFactory.addOrganismForNoValue(pattern, string, abstractCalcCondition, d);
                continue;
            }
            PatternFactory.addOrganismForNoGeneValue(pattern, string, abstractCalcCondition, d);
        }
        return pattern;
    }

    private static void addOrganismForNoValue(Pattern pattern, String string, AbstractCalcCondition abstractCalcCondition, double d) {
        double d2 = 0.0;
        boolean bl = false;
        if (abstractCalcCondition.isAverage()) {
            d2 = d;
        } else if (abstractCalcCondition.isSpec()) {
            d2 = abstractCalcCondition.getNaInfoSpecValue();
        } else {
            bl = true;
            d2 = Double.NaN;
        }
        pattern.addOrganism(string, d2, bl);
    }

    private static void addOrganismForNoGeneValue(Pattern pattern, String string, AbstractCalcCondition abstractCalcCondition, double d) {
        double d2 = 0.0;
        boolean bl = false;
        if (abstractCalcCondition.isAverageGene()) {
            d2 = d;
        } else if (abstractCalcCondition.isSpecGene()) {
            d2 = abstractCalcCondition.getNaElementSpecValue();
        } else {
            bl = true;
            d2 = Double.NaN;
        }
        pattern.addOrganism(string, d2, bl);
    }

    public static boolean isExistProperty(List list, Cluster cluster, AbstractCalcCondition abstractCalcCondition) {
        try {
            PatternFactory.calcAverage(list, cluster, abstractCalcCondition);
            return true;
        }
        catch (PatternException patternException) {
            return false;
        }
    }

    private static double calcAverage(List list, Cluster cluster, AbstractCalcCondition abstractCalcCondition) throws PatternException {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        ArrayList<Cluster> arrayList2 = new ArrayList<Cluster>();
        if (cluster instanceof SuperCluster) {
            arrayList2.addAll(((SuperCluster)cluster).getSubClusterList());
        } else {
            arrayList2.add(cluster);
        }
        for (Cluster cluster2 : arrayList2) {
            for (String string : list) {
                List list2 = abstractCalcCondition.getInfoValueList(string, cluster2);
                if (CollectionUtil.isNull(list2)) continue;
                for (Float f : list2) {
                    arrayList.add(f);
                }
            }
        }
        if (CollectionUtil.isNull(arrayList)) {
            String string = "Can't calculate the average value.";
            throw new PatternException(string);
        }
        return CollectionUtil.average(arrayList);
    }

    private static void coverNAValue(String string, Cluster cluster, AbstractCalcCondition abstractCalcCondition, double d) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        if (cluster instanceof SuperCluster) {
            arrayList.addAll(((SuperCluster)cluster).getSubClusterList());
        } else {
            arrayList.add(cluster);
        }
        for (Cluster cluster2 : arrayList) {
            if (abstractCalcCondition.isGene()) {
                List list = cluster2.getLocusTagWithoutDomainList(string);
                PatternFactory.coverNAValueByGene(string, list, abstractCalcCondition, d);
                continue;
            }
            if (!abstractCalcCondition.isCell()) continue;
            PatternFactory.coverNAValueByCellInfo(string, cluster2, abstractCalcCondition, d);
        }
    }

    private static void coverNAValueByGene(String string, List list, AbstractCalcCondition abstractCalcCondition, double d) {
        if (CollectionUtil.isNull(list)) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d2;
            String string2 = GeneUtil.removeDomainNo((String)iterator.next());
            if (abstractCalcCondition.containsLocusTag(string, string2) || (d2 = PatternFactory.getReplacedNAValue(abstractCalcCondition, d)) == Double.MAX_VALUE) continue;
            abstractCalcCondition.setGeneInfoValue(string, string2, d2);
        }
    }

    private static void coverNAValueByCellInfo(String string, Cluster cluster, AbstractCalcCondition abstractCalcCondition, double d) {
        double d2;
        if (!abstractCalcCondition.containsOrganismInCellInfo(string, cluster) && (d2 = PatternFactory.getReplacedNAValue(abstractCalcCondition, d)) != Double.MAX_VALUE) {
            abstractCalcCondition.setCellInfoValue(string, cluster, d2);
        }
    }

    private static List removeNoValueLocusTag(String string, List list, AbstractCalcCondition abstractCalcCondition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (!abstractCalcCondition.containsLocusTag(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static Float getValue(String string, Cluster cluster, AbstractCalcCondition abstractCalcCondition) {
        if (abstractCalcCondition.isGene()) {
            List list = cluster.getLocusTagWithoutDomainList(string);
            if (CollectionUtil.isNull(list)) {
                return null;
            }
            list = PatternFactory.removeNoValueLocusTag(string, list, abstractCalcCondition);
            LocusTagComparator locusTagComparator = new LocusTagComparator(abstractCalcCondition, (GeneInfoTitle)abstractCalcCondition.getInfoTitle(), abstractCalcCondition.getGeneInfoMap(string));
            Float f = (Float)GeneInfoMultiInfoManager.getRepresentativeValue(abstractCalcCondition, abstractCalcCondition.getInfoTitle(), list, locusTagComparator, abstractCalcCondition.getGeneInfoMap(string));
            return f;
        }
        if (abstractCalcCondition.isCell()) {
            Float f = (Float)CellInfoMultiInfoManager.getRepresentativeValue(abstractCalcCondition, cluster, abstractCalcCondition.getCellInfoMap(string));
            return f;
        }
        return null;
    }

    private static double getReplacedNAValue(AbstractCalcCondition abstractCalcCondition, double d) {
        double d2 = abstractCalcCondition.isAverage() ? d : (abstractCalcCondition.isSpec() ? abstractCalcCondition.getNaInfoSpecValue() : Double.NaN);
        return d2;
    }

    public static Pattern createBasePattern(Collection collection, Object object) {
        Pattern pattern = null;
        if (object instanceof Cluster) {
            pattern = new Pattern(collection, ((Cluster)object).getPatternMap().keySet());
        } else if (object instanceof Map) {
            pattern = new Pattern(collection, ((Map)object).keySet());
        }
        return pattern;
    }

    public static Pattern createBasePattern(Collection collection, Cluster cluster) {
        Pattern pattern = new Pattern(collection, cluster.getPatternMap().keySet());
        return pattern;
    }

    public static void updateBasePatternForProperty(Pattern pattern, List list, Cluster cluster, AbstractCalcCondition abstractCalcCondition) {
        double d = 0.0;
        if (abstractCalcCondition.isAverage() || abstractCalcCondition.isAverageGene()) {
            try {
                d = PatternFactory.calcAverage(list, cluster, abstractCalcCondition);
            }
            catch (PatternException patternException) {
                return;
            }
        }
        for (String string : pattern.getOrganismCodeList()) {
            Float f = PatternFactory.getValue(string, cluster, abstractCalcCondition);
            if (f != null) {
                pattern.setValue(string, f.doubleValue());
                continue;
            }
            if (cluster.containsSp(string)) {
                PatternFactory.addOrganismForNoValue(pattern, string, abstractCalcCondition, d);
                continue;
            }
            PatternFactory.addOrganismForNoGeneValue(pattern, string, abstractCalcCondition, d);
        }
    }
}

