/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.pattern;

import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.pattern.Pattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

class PatternTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Organism", "Value"};
    private Pattern pattern;
    private List organismList = new ArrayList();

    PatternTableModel() {
    }

    public void updatePattern(Pattern pattern, List list) {
        this.setPattern(pattern);
        this.organismList.clear();
        for (Organism organism : list) {
            this.organismList.add(organism);
        }
        this.fireTableDataChanged();
    }

    private void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        if (this.pattern == null) {
            return 0;
        }
        return this.pattern.getOrganismSize();
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return Pattern.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.pattern == null) {
            return null;
        }
        Organism organism = (Organism)this.organismList.get(n);
        if (n2 == 0) {
            return organism.getNameForTaxonomy();
        }
        if (n2 == 1) {
            return this.pattern;
        }
        return null;
    }

    public Set getOrganismCode(int[] nArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < nArray.length; ++i) {
            Organism organism = (Organism)this.organismList.get(nArray[i]);
            hashSet.add(organism.getOrganismCode());
        }
        return hashSet;
    }

    public String getOrganismCode(int n) {
        Organism organism = (Organism)this.organismList.get(n);
        return organism.getOrganismCode();
    }

    public List getOrganismCodeList() {
        return OrganismUtil.getOrganismCodeList(this.organismList);
    }

    public void setValue(Set set, double d) {
        for (String string : set) {
            this.pattern.setValue(string, d);
            this.pattern.setIgnore(string, false);
        }
        this.fireTableDataChanged();
    }

    public void setIgnore(Set set, boolean bl) {
        for (String string : set) {
            this.pattern.setIgnore(string, bl);
        }
        this.fireTableDataChanged();
    }

    public double getValue(int n) {
        String string = this.getOrganismCode(n);
        return this.pattern.getValue(string);
    }

    public boolean isIgnore(int n) {
        String string = this.getOrganismCode(n);
        return this.pattern.isIgnore(string);
    }
}

