/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelType;
import java.util.List;

public class PPMLabelConditionFactory {
    private PPMLabelConditionFactory() {
    }

    public static PPMLabelCondition createClusterIdLabelCondition(List list, boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(1);
        pPMLabelCondition.setName("Cluster ID");
        if (bl) {
            pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("clusterid"));
            ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("combine_clusterid");
            pPMLabelCondition.setLoadSubCluster(2);
            pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle);
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("homclusterid"));
        } else {
            ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("clusterid");
            pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle);
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("homclusterid"));
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createFunctionCategoryNoLabelCondition(List list, boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(9);
        pPMLabelCondition.setName("Function Category No");
        String string = FuncCatTbl.getInstance().getFunctionCategoryType();
        if (bl) {
            ClusterInfoTitle clusterInfoTitle = FunctionCategoryType.getClusterInfoTitle(string);
            pPMLabelCondition.setLoadCluster(2);
            pPMLabelCondition.setClusterInfoTitle(clusterInfoTitle);
            ClusterInfoTitle clusterInfoTitle2 = FunctionCategoryType.getSubClusterInfoTitle(string);
            pPMLabelCondition.setLoadSubCluster(2);
            pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle2);
        } else {
            ClusterInfoTitle clusterInfoTitle = FunctionCategoryType.getClusterInfoTitle(string);
            pPMLabelCondition.setLoadSubCluster(2);
            pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle);
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createGeneNameLabelCondition(boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(2);
        pPMLabelCondition.setName("Gene name");
        if (bl) {
            pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CGene"));
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("SCGene"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("homclusterid"));
        } else {
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CGene"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("homclusterid"));
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createScoreLabelCondition(boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(5);
        pPMLabelCondition.setName("Cluster score");
        if (bl) {
            pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CScore"));
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("SCScore"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("HCScore"));
        } else {
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CScore"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("HCScore"));
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createDistLabelCondition(boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(6);
        pPMLabelCondition.setName("Cluster dist");
        if (bl) {
            pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CDist"));
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("SCDist"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("HCDist"));
        } else {
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CDist"));
            pPMLabelCondition.setHomClusterInfoTitle(ClusterInfoFacade.getInfoTitle("HCDist"));
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createGeneCountLabelCondition(boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(9);
        pPMLabelCondition.setName("Gene count");
        if (bl) {
            pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CGeneCount"));
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("SCGeneCount"));
            pPMLabelCondition.setLoadCluster(2);
            pPMLabelCondition.setLoadSubCluster(2);
        } else {
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CGeneCount"));
            pPMLabelCondition.setLoadSubCluster(2);
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createPatternCoefLabelCondition(boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(7);
        pPMLabelCondition.setName("Phylogenetic Pattern Coefficient");
        if (bl) {
            if (ClusterMode.isClusterMode()) {
                pPMLabelCondition.setLoadCluster(2);
                pPMLabelCondition.setClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CPatternCoef"));
            } else {
                pPMLabelCondition.setLoadSubCluster(2);
                pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("SCPatternCoef"));
            }
        } else {
            pPMLabelCondition.setLoadSubCluster(2);
            pPMLabelCondition.setSubClusterInfoTitle(ClusterInfoFacade.getInfoTitle("CPatternCoef"));
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createRegClusterInfoLabelCondition(ClusterInfoTitle clusterInfoTitle, boolean bl) {
        PPMLabelCondition pPMLabelCondition = new PPMLabelCondition();
        pPMLabelCondition.setPpmLabelType(8);
        pPMLabelCondition.setName(clusterInfoTitle.getName());
        if (ClusterInfoType.isHomCluster(clusterInfoTitle.getInfoType())) {
            pPMLabelCondition.setLoadHomCluster(2);
            pPMLabelCondition.setHomClusterInfoTitle(clusterInfoTitle);
        } else if (ClusterInfoType.isCluster(clusterInfoTitle.getInfoType())) {
            if (bl) {
                pPMLabelCondition.setLoadCluster(2);
                pPMLabelCondition.setClusterInfoTitle(clusterInfoTitle);
            } else {
                pPMLabelCondition.setLoadSubCluster(2);
                pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle);
            }
        } else if (ClusterInfoType.isSubCluster(clusterInfoTitle.getInfoType())) {
            pPMLabelCondition.setLoadSubCluster(2);
            pPMLabelCondition.setSubClusterInfoTitle(clusterInfoTitle);
        }
        return pPMLabelCondition;
    }

    public static PPMLabelCondition createPpmLabelCondition(int n, List list, boolean bl) {
        PPMLabelCondition pPMLabelCondition = null;
        if (PPMLabelType.isClusterId(n)) {
            pPMLabelCondition = PPMLabelConditionFactory.createClusterIdLabelCondition(list, bl);
        } else if (PPMLabelType.isFuncNo(n)) {
            pPMLabelCondition = PPMLabelConditionFactory.createFunctionCategoryNoLabelCondition(list, bl);
        } else if (PPMLabelType.isClusterGeneName(n)) {
            pPMLabelCondition = PPMLabelConditionFactory.createGeneNameLabelCondition(bl);
        } else if (PPMLabelType.isClusterScore(n)) {
            pPMLabelCondition = PPMLabelConditionFactory.createScoreLabelCondition(bl);
        } else if (PPMLabelType.isClusterDist(n)) {
            pPMLabelCondition = PPMLabelConditionFactory.createDistLabelCondition(bl);
        }
        return pPMLabelCondition;
    }
}

