/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelConditionFactory;
import cgdp.recog.ppm.PPMLabelType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PPMLabelConditionGroup {
    private List conditionList = new ArrayList();
    private List baseConditionList = new ArrayList();
    private List registerConditionList = new ArrayList();
    private PPMLabelCondition selectedCondition;

    public void initCondition(ClusterTbl clusterTbl) {
        this.clearSelectCondition();
        this.baseConditionList.clear();
        this.baseConditionList.add(PPMLabelConditionFactory.createClusterIdLabelCondition(clusterTbl.getClusterList(), clusterTbl.isOutgroup()));
        this.baseConditionList.add(PPMLabelConditionFactory.createFunctionCategoryNoLabelCondition(clusterTbl.getClusterList(), clusterTbl.isOutgroup()));
        this.baseConditionList.add(PPMLabelConditionFactory.createGeneNameLabelCondition(clusterTbl.isOutgroup()));
        this.baseConditionList.add(PPMLabelConditionFactory.createScoreLabelCondition(clusterTbl.isOutgroup()));
        this.baseConditionList.add(PPMLabelConditionFactory.createDistLabelCondition(clusterTbl.isOutgroup()));
        this.baseConditionList.add(PPMLabelConditionFactory.createGeneCountLabelCondition(clusterTbl.isOutgroup()));
        this.updateCondition(clusterTbl);
    }

    private void updateRegisteredConditionList(ClusterTbl clusterTbl) {
        this.registerConditionList.clear();
        List list = ClusterInfoFacade.getInfoTitleListByAnalysisKey("UsePPMLabel", clusterTbl);
        for (ClusterInfoTitle clusterInfoTitle : list) {
            PPMLabelCondition pPMLabelCondition = PPMLabelConditionFactory.createRegClusterInfoLabelCondition(clusterInfoTitle, clusterTbl.isOutgroup());
            this.registerConditionList.add(pPMLabelCondition);
        }
    }

    public void clearSelectCondition() {
        this.setSelectedCondition(null);
    }

    public void updateCondition(ClusterTbl clusterTbl) {
        this.conditionList.clear();
        this.updateRegisteredConditionList(clusterTbl);
        this.conditionList.addAll(this.baseConditionList);
        this.conditionList.addAll(this.getRegisterConditionList());
        if (this.getSelectedCondition() == null) {
            this.setSelectedCondition((PPMLabelCondition)this.conditionList.get(2));
        }
    }

    private void addCondition(PPMLabelCondition pPMLabelCondition, ClusterTbl clusterTbl) {
        this.registerConditionList.add(pPMLabelCondition);
        this.updateCondition(clusterTbl);
    }

    public void setCondition(PPMLabelCondition pPMLabelCondition, ClusterTbl clusterTbl) {
        this.removeCondition(pPMLabelCondition.getPpmLabelType());
        if (this.getSelectedCondition() == null) {
            this.setSelectedCondition(pPMLabelCondition);
        }
        this.addCondition(pPMLabelCondition, clusterTbl);
    }

    private void removeCondition(int n) {
        HashSet<PPMLabelCondition> hashSet = new HashSet<PPMLabelCondition>();
        for (PPMLabelCondition pPMLabelCondition : this.getRegisterConditionList()) {
            if (!pPMLabelCondition.equalsType(n)) continue;
            hashSet.add(pPMLabelCondition);
        }
        this.registerConditionList.removeAll(hashSet);
        if (hashSet.contains(this.getSelectedCondition())) {
            this.setSelectedCondition(null);
        }
    }

    public List getConditionList() {
        return this.conditionList;
    }

    private List getRegisterConditionList() {
        return this.registerConditionList;
    }

    public PPMLabelCondition getSelectedCondition() {
        return this.selectedCondition;
    }

    public void setSelectedCondition(PPMLabelCondition pPMLabelCondition) {
        this.selectedCondition = pPMLabelCondition;
    }

    public boolean equalsSelectedPPMLabelCondition(PPMLabelCondition pPMLabelCondition) {
        return this.selectedCondition == pPMLabelCondition;
    }

    public boolean isExistPatternCoef() {
        return this.getPatternCoefCondition() != null;
    }

    private PPMLabelCondition getPatternCoefCondition() {
        for (PPMLabelCondition pPMLabelCondition : this.getConditionList()) {
            if (!PPMLabelType.isPatternCoef(pPMLabelCondition.getPpmLabelType())) continue;
            return pPMLabelCondition;
        }
        return null;
    }

    public ClusterInfoTitle getPatternCoefTitle() {
        PPMLabelCondition pPMLabelCondition = this.getPatternCoefCondition();
        if (pPMLabelCondition == null) {
            return null;
        }
        if (pPMLabelCondition.getClusterInfoTitle() != null) {
            return pPMLabelCondition.getClusterInfoTitle();
        }
        return pPMLabelCondition.getSubClusterInfoTitle();
    }

    public boolean constainsInfoTitleInSelectedPPPMLabel(AbstractInfoTitle abstractInfoTitle) {
        if (this.getSelectedCondition() == null) {
            return false;
        }
        return this.getSelectedCondition().containsInfoTitle(abstractInfoTitle);
    }
}

