/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.ppm.PPMLabelDisplayItem;
import cgdp.recog.ppm.PPMLabelItem;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class PPMLabelMenu
extends JMenu
implements MenuListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private ActionListener actionListener;
    private ButtonGroup bg = new ButtonGroup();

    public PPMLabelMenu(ActionListener actionListener, MediatorImpl mediatorImpl) {
        super("PPM Label");
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.actionListener = actionListener;
        this.addMenuListener(this);
        this.setEnabled(false);
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.clusterTbl == null) {
            return;
        }
        this.updateMenuItem();
        this.setSelectedMenuItem();
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    private void updateMenuItem() {
        this.removeAll();
        HashSet<AbstractButton> hashSet = new HashSet<AbstractButton>();
        Object object = this.bg.getElements();
        while (object.hasMoreElements()) {
            hashSet.add(object.nextElement());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.bg.remove((AbstractButton)object.next());
        }
        object = this.clusterTbl.getPpmLabelConditionList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PPMLabelCondition pPMLabelCondition = (PPMLabelCondition)iterator.next();
            PPMLabelItem pPMLabelItem = new PPMLabelItem(this.actionListener, this.mediator, pPMLabelCondition);
            this.add(pPMLabelItem);
            this.bg.add(pPMLabelItem);
        }
        this.addSeparator();
        this.add(new PPMLabelDisplayItem(this.actionListener, this.mediator));
    }

    private void setSelectedMenuItem() {
        if (this.clusterTbl == null) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            PPMLabelItem pPMLabelItem;
            PPMLabelCondition pPMLabelCondition;
            if (!(this.getItem(i) instanceof PPMLabelItem) || !this.clusterTbl.equalsSelectedPPMLabelCondition(pPMLabelCondition = (pPMLabelItem = (PPMLabelItem)this.getItem(i)).getPpmLabelCondition())) continue;
            pPMLabelItem.setSelected(true);
            break;
        }
    }
}

