/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.CollectionUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PPMSelectionManager {
    private String selectedOrganismCode;
    private Set selectedOrganismSet = new HashSet();
    private Set selectedRowIndexSet = new HashSet();
    private Set subSelectedRowIndexSet = new HashSet();
    private int baseRowIndex = -1;

    public void setBaseRowIndex(int n) {
        this.baseRowIndex = n;
    }

    public int getBaseRowIndex() {
        return this.baseRowIndex;
    }

    public void setSelectedOrganismCode(String string) {
        this.selectedOrganismCode = string;
    }

    public String getSelectedOrganismCode() {
        return this.selectedOrganismCode;
    }

    public Set getSelectedRowIndexSet() {
        return this.selectedRowIndexSet;
    }

    public Set getSubSelectedRowIndexSet() {
        return this.subSelectedRowIndexSet;
    }

    public void clearSelection() {
        this.selectedOrganismCode = null;
        this.selectedRowIndexSet.clear();
        this.subSelectedRowIndexSet.clear();
    }

    private void addSelectedSubCluster(int n, ClusterTbl clusterTbl) {
        Cluster cluster = clusterTbl.getViewCluster(n);
        if (!OptionTbl.getInstance().getOptionValues().isIntensive() && clusterTbl.isOutgroup()) {
            Cluster cluster2;
            int n2;
            List list = clusterTbl.getViewClusterList();
            for (n2 = n - 1; n2 >= 0 && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); --n2) {
                this.subSelectedRowIndexSet.add(new Integer(n2));
            }
            for (n2 = n + 1; n2 < list.size() && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); ++n2) {
                this.subSelectedRowIndexSet.add(new Integer(n2));
            }
        }
    }

    private void clearSelectedSubCluster(int n, ClusterTbl clusterTbl) {
        Cluster cluster = clusterTbl.getViewCluster(n);
        if (!OptionTbl.getInstance().getOptionValues().isIntensive() && clusterTbl.isOutgroup()) {
            Cluster cluster2;
            int n2;
            List list = clusterTbl.getViewClusterList();
            for (n2 = n - 1; n2 >= 0 && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); --n2) {
                this.subSelectedRowIndexSet.remove(new Integer(n2));
            }
            for (n2 = n + 1; n2 < list.size() && cluster.equalsClusterId(cluster2 = (Cluster)list.get(n2)); ++n2) {
                this.subSelectedRowIndexSet.remove(new Integer(n2));
            }
        }
    }

    public List getSelectedClusterList(ClusterTbl clusterTbl) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            Iterator iterator = this.selectedRowIndexSet.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                List list = clusterTbl.getViewClusterListInPattern(n);
                arrayList.addAll(list);
            }
        } else {
            if (clusterTbl.isOutgroup(this.getSelectedOrganismCode())) {
                Iterator iterator = this.subSelectedRowIndexSet.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    Cluster cluster = clusterTbl.getViewCluster(n);
                    arrayList.add(cluster);
                }
            } else {
                Iterator iterator = this.selectedRowIndexSet.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    Cluster cluster = clusterTbl.getViewCluster(n);
                    arrayList.add(cluster);
                }
            }
            Collections.sort(arrayList, new ClusterComparator(6));
        }
        return arrayList;
    }

    public boolean isSelectedSubCluster(int n) {
        return this.containsSelectedIndex(n);
    }

    public boolean containsSelectedIndex(int n) {
        return this.selectedRowIndexSet.contains(new Integer(n));
    }

    public boolean containsSelctedRange(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            if (!this.selectedRowIndexSet.contains(new Integer(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isExistSelectedCluster() {
        return !CollectionUtil.isNull(this.selectedRowIndexSet);
    }

    public boolean containsSubSelectedCluster(int n) {
        return this.subSelectedRowIndexSet.contains(new Integer(n));
    }

    public int getSelectedRow() {
        int n = -1;
        if (!CollectionUtil.isNull(this.selectedRowIndexSet)) {
            n = (Integer)Collections.min(this.getSelectedRowIndexSet());
        }
        return n;
    }

    public void setSelectedCluster(String string, Collection collection, ClusterTbl clusterTbl) {
        this.clearSelection();
        this.addSelectedCluster(string, collection, clusterTbl);
    }

    public void addSelectedCluster(String string, Collection collection, ClusterTbl clusterTbl) {
        this.setSelectedOrganismCode(string);
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Cluster cluster : collection) {
                Object object;
                Map map = cluster.getPatternMap();
                if (hashSet.contains(map) || !(object = new HashSet(clusterTbl.getViewClusterList(map))).contains(cluster)) continue;
                hashSet.add(map);
            }
            Map map = clusterTbl.createPatternMapRowIndexMap();
            boolean bl = true;
            for (Object object : hashSet) {
                Integer n = (Integer)map.get(object);
                if (n == null) continue;
                int n2 = n;
                if (bl) {
                    this.setBaseRowIndex(n2);
                    bl = false;
                }
                this.addSelectedIndex(n2);
            }
        } else {
            Map map = clusterTbl.createViewClusterRowIndexMap();
            boolean bl = true;
            for (Cluster cluster : collection) {
                Integer n;
                if (cluster == null || (n = (Integer)map.get(cluster)) == null) continue;
                int n3 = n;
                if (bl) {
                    this.setBaseRowIndex(n3);
                    bl = false;
                }
                this.addSelectedIndex(n3);
                this.addSelectedSubCluster(n3, clusterTbl);
            }
        }
    }

    public void flipSelectedCluster(String string, Collection collection, ClusterTbl clusterTbl) {
        this.setSelectedOrganismCode(string);
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            Set set = ClusterUtil.getPatternMapSet(collection);
            boolean bl = true;
            for (Map map : set) {
                int n = clusterTbl.getViewPatternIndex(map);
                if (this.containsSelectedIndex(n)) {
                    this.clearSelectedIndex(n);
                    continue;
                }
                if (bl) {
                    this.setBaseRowIndex(n);
                    bl = false;
                }
                this.addSelectedIndex(n);
            }
        } else {
            boolean bl = true;
            for (Cluster cluster : collection) {
                if (cluster == null) continue;
                int n = clusterTbl.getViewClusterIndex(cluster);
                if (bl) {
                    this.setBaseRowIndex(n);
                    bl = false;
                }
                if (this.containsSelectedIndex(n)) {
                    this.clearSelectedIndex(n);
                    this.clearSelectedSubCluster(n, clusterTbl);
                    continue;
                }
                this.addSelectedIndex(n);
                this.addSelectedSubCluster(n, clusterTbl);
            }
        }
    }

    private void addSelectedIndex(int n) {
        this.selectedRowIndexSet.add(new Integer(n));
        this.subSelectedRowIndexSet.add(new Integer(n));
    }

    private void clearSelectedIndex(int n) {
        this.selectedRowIndexSet.remove(new Integer(n));
        this.subSelectedRowIndexSet.remove(new Integer(n));
    }

    public boolean isSelectedCluster(int n) {
        return this.containsSubSelectedCluster(n);
    }

    public void clearSelectedOrganismSet() {
        this.selectedOrganismSet.clear();
    }

    public void setSelectedOrganismSet(Set set) {
        if (set == null) {
            this.clearSelectedOrganismSet();
        } else {
            this.selectedOrganismSet.addAll(set);
        }
    }

    public Set getSelectedOrganismSet() {
        return this.selectedOrganismSet;
    }

    public boolean isExistSelectedOrganism() {
        return !CollectionUtil.isNull(this.selectedOrganismSet);
    }

    public boolean containsSelectedOrganism(String string) {
        return this.selectedOrganismSet.contains(string);
    }
}

