/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustQuery;
import cgdp.recog.project.Project;
import cgdp.recog.project.ServerAnalysis;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ReadOnlyTextArea;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class BaseClusterListDialog
extends AbstractApplyDialog
implements MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(BaseClusterListDialog.class);
    private static BaseClusterListDialog BASE_CLUSTER_LISTDIALOG;
    private static final String TITLE = "Base Clustering List";
    private static final Dimension DIALOG_SIZE;
    private MediatorImpl mediator;
    private Project project;
    private JTextField projectNameText;
    private JTable baseClusterTable;
    private ReadOnlyTextArea propertyArea;
    private JButton clearButton;
    private List baseClusterList = new ArrayList();

    public BaseClusterListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createBaseClusterListDialog(Frame frame, MediatorImpl mediatorImpl) {
        BASE_CLUSTER_LISTDIALOG = new BaseClusterListDialog(frame, mediatorImpl);
    }

    public static BaseClusterListDialog getInstance() {
        return BASE_CLUSTER_LISTDIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        JLabel jLabel = new JLabel("Project");
        this.projectNameText = new JTextField();
        this.projectNameText.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.projectNameText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.baseClusterTable = this.createBaseClusterTable();
        JScrollPane jScrollPane = new JScrollPane(this.baseClusterTable, 20, 30);
        this.baseClusterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    DomClustAnalysis domClustAnalysis = BaseClusterListDialog.this.getSelectedBaseCluster();
                    if (domClustAnalysis != null) {
                        BaseClusterListDialog.this.updatePropertyPanel(domClustAnalysis);
                    }
                    BaseClusterListDialog.this.setEnableButton();
                }
            }
        });
        this.propertyArea = new ReadOnlyTextArea();
        this.propertyArea.setLineWrap(true);
        this.propertyArea.setColumns(50);
        JScrollPane jScrollPane2 = new JScrollPane(this.propertyArea, 20, 31);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setApplyButtonName("Apply");
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this.clearButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel3.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.setEnableButton();
        this.setSize(DIALOG_SIZE);
        this.setLocationRelativeTo(this.getParent());
    }

    private JTable createBaseClusterTable() {
        BaseClusterTableModel baseClusterTableModel = new BaseClusterTableModel();
        JTable jTable = new JTable(baseClusterTableModel);
        jTable.setRowHeight(20);
        jTable.setSelectionMode(0);
        return jTable;
    }

    private BaseClusterTableModel getBaseClusterTableModel() {
        return (BaseClusterTableModel)this.baseClusterTable.getModel();
    }

    public void updateValue(Project project, List list) {
        this.project = project;
        this.projectNameText.setText(this.project.getProjectName());
        this.baseClusterList = list != null ? list : new ArrayList();
        this.updateTable();
    }

    private void setEnableButton() {
        int n = this.baseClusterTable.getSelectedRow();
        this.applyButton.setEnabled(n != -1);
    }

    private void updateTable() {
        this.getBaseClusterTableModel().setBaseClusterList(this.baseClusterList);
    }

    private void updatePropertyPanel(ServerAnalysis serverAnalysis) {
        DomClustAnalysis domClustAnalysis = (DomClustAnalysis)serverAnalysis;
        String string = domClustAnalysis.getCommand();
        DomClustCondition domClustCondition = DomClustQuery.createDomClustCondition(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cluster ID:");
        stringBuffer.append(domClustAnalysis.getDomClustId());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        String string2 = DomClustQuery.createDisplayOptions(string);
        stringBuffer.append("Options:");
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(string2);
        ArrayList arrayList = new ArrayList(domClustCondition.getIngroupOrganismCodeSet());
        Collections.sort(arrayList);
        stringBuffer.append("Ingroup(");
        stringBuffer.append(arrayList.size());
        stringBuffer.append("):");
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(" " + StringTool.conbineStrList(arrayList, ","));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        ArrayList arrayList2 = new ArrayList(domClustCondition.getOutgroupOrganismCodeSet());
        Collections.sort(arrayList2);
        stringBuffer.append("Outgroup(");
        stringBuffer.append(arrayList2.size());
        stringBuffer.append("):");
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(" " + StringTool.conbineStrList(arrayList2, ","));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        this.propertyArea.setText(stringBuffer.toString());
        this.propertyArea.repaint();
        this.propertyArea.setCaretPosition(0);
    }

    public DomClustAnalysis getSelectedBaseCluster() {
        int n = this.baseClusterTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        ServerAnalysis serverAnalysis = this.getBaseClusterTableModel().getBaseCluster(n);
        return (DomClustAnalysis)serverAnalysis;
    }

    public void clearSelectedBaseCluster() {
        this.baseClusterTable.clearSelection();
    }

    @Override
    protected boolean check() {
        DomClustAnalysis domClustAnalysis = this.getSelectedBaseCluster();
        if (domClustAnalysis == null) {
            MessageManager.showErrorMessage((Component)this, "Select base cluster.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.clearButton) {
            this.clearSelectedBaseCluster();
            this.setVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.applyButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        DIALOG_SIZE = new Dimension(600, 400);
    }

    private class BaseClusterTableModel
    extends AbstractTableModel {
        private String[] COLUMN_NAMES = new String[]{"Name", "Description", "Created On"};
        private List baseClusterList = new ArrayList();

        private BaseClusterTableModel() {
        }

        public void setBaseClusterList(List list) {
            this.baseClusterList = list;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.baseClusterList.size();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ServerAnalysis serverAnalysis = (ServerAnalysis)this.baseClusterList.get(n);
            if (n2 == 0) {
                return serverAnalysis.getName();
            }
            if (n2 == 1) {
                return StringTool.getOneLine(serverAnalysis.getDescription());
            }
            if (n2 == 2) {
                return serverAnalysis.getCreateOn();
            }
            return null;
        }

        public ServerAnalysis getBaseCluster(int n) {
            return (ServerAnalysis)this.baseClusterList.get(n);
        }
    }
}

