/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.project.OldProjectImporter;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectComparator;
import cgdp.recog.project.ProjectExporter;
import cgdp.recog.project.ProjectImporter;
import cgdp.recog.project.ProjectListDownloader;
import cgdp.recog.project.ProjectManager;
import cgdp.recog.project.ProjectUtil;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProjectAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(ProjectAccesser.class);

    public static boolean isSameSelectedProject(List list) {
        Project project = ProjectAccesser.getSelectedProject();
        Project project2 = ProjectAccesser.findSelectedProject(list);
        return project.equalsProject(project2);
    }

    public static void updateProjectInfo(List list) {
        Object object;
        Object object22;
        Object object32;
        Map map = ProjectAccesser.createProjectMap();
        ArrayList arrayList = new ArrayList();
        for (Object object32 : list) {
            object22 = (Project)map.get(((Project)object32).getProjectId());
            if (object22 == null) {
                if (ProjectUtil.createProjectDir((Project)object32)) continue;
                arrayList.add(object32);
                continue;
            }
            ((Project)object32).setProjectId(((Project)object22).getProjectId());
            if (((Project)object22).equalsDirectoryPath((Project)object32)) continue;
            object = new File(((Project)object22).getDirectoryPath());
            ((File)object).renameTo(new File(((Project)object32).getDirectoryPath()));
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        for (Object object22 : list) {
            hashSet.remove(((Project)object22).getProjectId());
        }
        object32 = hashSet.iterator();
        while (object32.hasNext()) {
            object22 = (String)object32.next();
            object = (Project)map.get(object22);
            FileUtil.delete(((Project)object).getDirectoryPath());
        }
        try {
            object32 = new ArrayList(list);
            object32 = ProjectAccesser.removeAllProject((List)object32, arrayList);
            object22 = new ProjectExporter((List)object32);
            ((ProjectExporter)object22).execute();
        }
        catch (IOException iOException) {
            logger.warn("Fail to save project info.", iOException);
        }
    }

    public static void updateProjectInfo(Project project) throws IOException {
        Object object;
        List list = ProjectAccesser.loadProject();
        Project project2 = null;
        for (Object object2 : list) {
            if (!((Project)object2).equalsProject(project)) continue;
            project2 = object2;
            break;
        }
        if (project2 != null) {
            ProjectAccesser.removeProject(list, project2);
            list.add(project);
            Collections.sort(list, new ProjectComparator());
            object = new ProjectExporter(list);
            ((ProjectExporter)object).execute();
        } else if (ProjectUtil.createProjectDir(project)) {
            list.add(project);
            Collections.sort(list, new ProjectComparator());
            object = new ProjectExporter(list);
            ((ProjectExporter)object).execute();
        } else {
            Object object2;
            object = "Fail to create project directory. " + project.getProjectName();
            object2 = new IOException((String)object);
            logger.warn((String)object, (Throwable)object2);
            throw object2;
        }
    }

    public static void updateProjectInfo(Project project, Project project2) throws IOException {
        List list = ProjectAccesser.loadProject();
        if (project != null) {
            ProjectAccesser.removeProject(list, project);
            list.add(project2);
            Collections.sort(list, new ProjectComparator());
            ProjectExporter projectExporter = new ProjectExporter(list);
            projectExporter.execute();
        } else if (ProjectUtil.createProjectDir(project2)) {
            list.add(project2);
            Collections.sort(list, new ProjectComparator());
            ProjectExporter projectExporter = new ProjectExporter(list);
            projectExporter.execute();
        } else {
            String string = "Fail to create project directory. " + project2.getProjectName();
            IOException iOException = new IOException(string);
            logger.warn(string, iOException);
            throw iOException;
        }
    }

    public static void updateSelectProject(Project project) {
        ProjectManager.getInstance().setSelectProject(project);
    }

    public static void saveSelectProject() {
        try {
            List list = ProjectAccesser.loadProject();
            for (Project project : list) {
                project.setSelect(project.equalsProject(ProjectManager.getInstance().getSelectProject()));
            }
            ProjectExporter projectExporter = new ProjectExporter(list);
            projectExporter.execute();
            MapFacade.upateMappingSelectState();
        }
        catch (IOException iOException) {
            logger.warn("Fail to update project info.", iOException);
        }
    }

    private static Map createProjectMap() {
        HashMap<String, Project> hashMap = new HashMap<String, Project>();
        List list = ProjectAccesser.loadProject();
        for (Project project : list) {
            hashMap.put(project.getProjectId(), project);
        }
        return hashMap;
    }

    public static List loadProject() {
        try {
            ProjectImporter projectImporter = new ProjectImporter();
            projectImporter.execute();
            List list = projectImporter.getProjectList();
            Collections.sort(list, new ProjectComparator());
            return list;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load project info file.", iOException);
            return new ArrayList();
        }
    }

    public static Map createNameProjectMap() {
        List list = ProjectAccesser.loadProject();
        HashMap<String, Project> hashMap = new HashMap<String, Project>();
        for (Project project : list) {
            hashMap.put(project.getProjectName(), project);
        }
        return hashMap;
    }

    public static boolean createDefaultProject() throws IOException {
        File file = new File(ProjectUtil.getDefaultProjectDirpath());
        File file2 = ProjectUtil.getProjectInfoFile("default");
        if (file.isDirectory() && file2.isFile()) {
            return false;
        }
        if (!FileUtil.createDirectory(ProjectUtil.getDefaultProjectDirpath())) {
            return false;
        }
        Project project = Project.createDefaultProject();
        project.setSelect(true);
        ProjectExporter projectExporter = new ProjectExporter(project);
        projectExporter.execute();
        return true;
    }

    public static void registerProjectFromOldProjectInfo() throws IOException {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        File file = ProjectUtil.getProjectHomeDir();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            if (!fileArray[i].isDirectory() || !(file2 = ProjectUtil.getProjectInfoFile(fileArray[i].getName())).isFile()) continue;
            try {
                OldProjectImporter oldProjectImporter = new OldProjectImporter(fileArray[i].getName());
                oldProjectImporter.execute();
                Project project = oldProjectImporter.getProject();
                project.setDirectoryPath(ProjectUtil.getProjectDirpath(project.getProjectName()));
                project.setServerUrl(ServerTbl.getDefaultServerHost());
                arrayList.add(project);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collections.sort(arrayList, new ProjectComparator());
        ProjectExporter projectExporter = new ProjectExporter(arrayList);
        projectExporter.execute();
    }

    public static void adjustServerInfo() {
        Set set = ProjectAccesser.getServerUrlListIncludeProject();
        HashSet<String> hashSet = new HashSet<String>();
        ServerTbl serverTbl = ServerTbl.getInstance();
        List list = serverTbl.getServerUrlList();
        for (String string : set) {
            if (list.contains(string)) continue;
            hashSet.add(string);
        }
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                serverTbl.addServer(string);
            }
        }
    }

    private static Set getServerUrlListIncludeProject() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = ProjectAccesser.loadProject();
        for (Project project : list) {
            hashSet.add(project.getServerUrl());
        }
        return hashSet;
    }

    public static Project getSelectedProject() {
        return ProjectManager.getInstance().getSelectProject();
    }

    public static Project loadSelectProject() {
        List list = ProjectAccesser.loadProject();
        return ProjectAccesser.findSelectedProject(list);
    }

    private static Project findSelectedProject(Collection collection) {
        for (Project project : collection) {
            if (!project.isSelect()) continue;
            return project;
        }
        return null;
    }

    public static Project getProject(String string) {
        List list = ProjectAccesser.loadProject();
        Project project = null;
        for (Project project2 : list) {
            if (!project2.equalsName(string)) continue;
            project = project2;
            break;
        }
        return project;
    }

    public static Project getProjectById(String string) {
        List list = ProjectAccesser.loadProject();
        Project project = null;
        for (Project project2 : list) {
            if (!project2.equalsId(string)) continue;
            project = project2;
            break;
        }
        return project;
    }

    public static Project getProjectByServerId(String string) {
        List list = ProjectAccesser.loadProject();
        Project project = null;
        for (Project project2 : list) {
            if (!project2.equalsServerId(string)) continue;
            project = project2;
            break;
        }
        return project;
    }

    public static File getProjectDir() {
        Project project = ProjectAccesser.getSelectedProject();
        return ProjectUtil.getProjectDir(project.getProjectName());
    }

    public static String getProjectDirpath() {
        Project project = ProjectAccesser.getSelectedProject();
        return project.getDirectoryPath();
    }

    public static String searchDomClustFileByClsterViewId(String string) {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(fileArray[i].getAbsolutePath());
                abstractDomClustImporter.setParameterOnly(true);
                abstractDomClustImporter.execute();
                String string2 = abstractDomClustImporter.getClusterViewId();
                if (StringTool.isNull(string2) || !string2.equals(string)) continue;
                return fileArray[i].getAbsolutePath();
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust file.", iOException);
            }
        }
        return null;
    }

    public static String searchDomClustFileByDomClustId(String string) {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(fileArray[i].getAbsolutePath());
                abstractDomClustImporter.setParameterOnly(true);
                abstractDomClustImporter.execute();
                String string2 = abstractDomClustImporter.getDomClustId();
                if (!string2.equals(string)) continue;
                return fileArray[i].getAbsolutePath();
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust file.", iOException);
            }
        }
        return null;
    }

    public static String getSelectProjectServerUrl() {
        Project project = ProjectAccesser.getSelectedProject();
        if (project == null) {
            return null;
        }
        return project.getServerUrl();
    }

    public static String getGeneAnnotationUrl(String string, String string2) {
        String string3 = AccessServer.getInstance().getServerUrl();
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        string3 = string3 + OptionTbl.getInstance().getOptionValues().getGeneAnnotationUrl();
        string3 = string3.replaceAll("%%%NAME%%%", string);
        string3 = string3.replaceAll("%%%GENE%%%", string2);
        return string3;
    }

    public static List getProjectListUsedServer(Server server) {
        return ProjectAccesser.getProjectListUsedServer(server.getUrl());
    }

    public static List getProjectListUsedServer(String string) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        List list = ProjectAccesser.loadProject();
        for (Project project : list) {
            if (!project.equalsServerUrl(string)) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    public static boolean containsServer(Server server) {
        return ProjectAccesser.containsServer(server.getUrl());
    }

    public static boolean containsServer(String string) {
        List list = ProjectAccesser.loadProject();
        for (Project project : list) {
            if (!project.equalsServerUrl(string)) continue;
            return true;
        }
        return false;
    }

    public static List downloadProjectList() throws Exception {
        ProjectListDownloader projectListDownloader = new ProjectListDownloader();
        projectListDownloader.execute();
        return projectListDownloader.getProjectList();
    }

    private static List removeProject(List list, Project project) {
        for (int i = 0; i < list.size(); ++i) {
            Project project2 = (Project)list.get(i);
            if (!project2.equalsProject(project)) continue;
            list.remove(i);
            break;
        }
        return list;
    }

    private static List removeAllProject(List list, List list2) {
        for (int i = 0; i < list2.size(); ++i) {
            list = ProjectAccesser.removeProject(list, (Project)list2.get(i));
        }
        return list;
    }
}

