/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectEditDialog;
import cgdp.recog.project.ProjectTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RadioButtonCellEditor;
import cgdp.recog.util.RadioButtonCellRenderer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ProjectListDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Project List";
    private static final int COLUMN_WIDTH_SELECT = 50;
    private MediatorImpl mediator;
    private List projectList;
    private JTable projectTable;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;

    public ProjectListDialog(Frame frame, MediatorImpl mediatorImpl, List list) {
        super(frame);
        this.mediator = mediatorImpl;
        this.projectList = new ArrayList(list);
        this.createComponents();
    }

    public ProjectListDialog(Dialog dialog, MediatorImpl mediatorImpl, List list) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.projectList = new ArrayList(list);
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.projectTable = new JTable(new ProjectTableModel(this.projectList));
        this.projectTable.setRowHeight(20);
        this.projectTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.projectTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProjectListDialog.this.updateButtonState();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.projectTable, 20, 31);
        TableColumn tableColumn = this.projectTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new RadioButtonCellRenderer());
        tableColumn.setCellEditor(new RadioButtonCellEditor());
        tableColumn.setMinWidth(50);
        tableColumn.setMaxWidth(50);
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(this);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.editButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateButtonState();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected boolean apply() {
        return true;
    }

    public List getProjectList() {
        return this.projectList;
    }

    private Project getSelectedProject() {
        int n = this.projectTable.getSelectedRow();
        return this.getProjectTableModel().getProject(n);
    }

    private List getSelectedProjectList() {
        int[] nArray = this.projectTable.getSelectedRows();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (int i = 0; i < nArray.length; ++i) {
            Project project = this.getProjectTableModel().getProject(nArray[i]);
            if (project == null) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    private ProjectTableModel getProjectTableModel() {
        return (ProjectTableModel)this.projectTable.getModel();
    }

    private void add() {
        Project project = Project.createClientProject();
        ProjectEditDialog projectEditDialog = new ProjectEditDialog(this, this.mediator, project, this.getProjectList(), true);
        projectEditDialog.setVisible(true);
        if (!projectEditDialog.isCanceled()) {
            project.setProjectName(projectEditDialog.getProjectName());
            project.setDirectoryPath(projectEditDialog.getDirectoryPath());
            project.setServerUrl(projectEditDialog.getServerUrl());
            this.getProjectTableModel().addProject(project);
            this.updateButtonState();
        }
    }

    private void edit() {
        Project project = this.getSelectedProject();
        ProjectEditDialog projectEditDialog = new ProjectEditDialog(this, this.mediator, project, this.getProjectList(), false);
        projectEditDialog.setVisible(true);
        if (!projectEditDialog.isCanceled()) {
            project.setProjectName(projectEditDialog.getProjectName());
            project.setDirectoryPath(projectEditDialog.getDirectoryPath());
            project.setServerUrl(projectEditDialog.getServerUrl());
            this.getProjectTableModel().fireTableDataChanged();
            this.updateButtonState();
        }
    }

    private void delete() {
        if (!this.validateDelete()) {
            return;
        }
        Project project = this.getSelectedProject();
        if (!MessageManager.showConfirmMessage((Component)this, "Delete project [" + project.getProjectName() + "]?")) {
            return;
        }
        this.getProjectTableModel().removeProject(project);
        if (project.isSelect()) {
            Project project2 = (Project)this.projectList.get(0);
            project2.setSelect(true);
        }
        this.updateButtonState();
    }

    private boolean validateDelete() {
        Project project;
        if (this.projectList.size() == 1) {
            MessageManager.showErrorMessage((Component)this, "Can't delete the opened project.");
            return false;
        }
        Project project2 = this.getSelectedProject();
        if (project2.equalsProject(project = ProjectAccesser.getSelectedProject())) {
            MessageManager.showErrorMessage((Component)this, "Can't delete the opened project.");
            return false;
        }
        return true;
    }

    private void updateButtonState() {
        if (this.projectTable.getSelectedRowCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.editButton) {
            this.edit();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }
}

