/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.bean.Const;
import cgdp.recog.project.Project;
import cgdp.recog.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectUtil {
    static final String PROJECT_INFO_FILE_NAME = "project_info";
    static final String DEFAULT_PROJECT_NAME = "default";
    static final String COLUMN_NAME_PROJECT_ID = "id";
    static final String COLUMN_NAME_PROJECT_NAME = "name";
    static final String COLUMN_NAME_SERVER_URL = "url";
    static final String COLUMN_NAME_DIRECTORY_PATH = "directory_path";
    static final String COLUMN_NAME_DOWNLOAD_SERVER_URL = "download_server_url";
    static final String COLUMN_NAME_DOWNLOAD_SERVER_PROJECT_NAME = "download_server_project_name";
    static final String COLUMN_NAME_SELECT = "select";
    public static final String COLUMN_NAME_ORGANISM = "organism";
    public static final String DELIMITER = "\t";
    public static final String DELIMITER_SP = ",";

    static String getProjectDirpath(String string) {
        return Const.USER_PROJECT_PATH + File.separator + string;
    }

    static String getDefaultProjectDirpath() {
        return Const.USER_PROJECT_PATH + File.separator + DEFAULT_PROJECT_NAME;
    }

    static String getDefaultRootProjectDirpath() {
        return Const.USER_PROJECT_PATH + File.separator;
    }

    static File getProjectDir(String string) {
        return new File(ProjectUtil.getProjectDirpath(string));
    }

    static String getProjectInfoFilepath(String string) {
        return ProjectUtil.getProjectDirpath(string) + File.separator + PROJECT_INFO_FILE_NAME;
    }

    public static String getProjectInfoFilepath() {
        return Const.USER_CONF_DIR + File.separator + PROJECT_INFO_FILE_NAME;
    }

    static File getProjectInfoFile(String string) {
        return new File(ProjectUtil.getProjectInfoFilepath(string));
    }

    private static String getProjectHomeDirpath() {
        return Const.USER_PROJECT_PATH;
    }

    static File getProjectHomeDir() {
        return new File(ProjectUtil.getProjectHomeDirpath());
    }

    static boolean createProjectDir(Project project) {
        return FileUtil.createDirectory(project.getDirectoryPath());
    }

    static Map createProjectMap(List list) {
        HashMap<String, Project> hashMap = new HashMap<String, Project>();
        for (Project project : list) {
            hashMap.put(project.getProjectId(), project);
        }
        return hashMap;
    }

    public static String getProjectNameString(List list) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (Project project : list) {
            stringBuffer.append(project.getProjectName());
            if (n == list.size() - 1) continue;
            stringBuffer.append(DELIMITER_SP);
        }
        return stringBuffer.toString();
    }
}

