/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.organism.OrganismTableModel;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectUtil;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ReadOnlyTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerProjectListDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerProjectListDialog.class);
    private static final String TITLE = "Project List";
    private JTable projectTable;
    private JLabel projectIdLable;
    private JLabel projectNameLable;
    private ReadOnlyTextArea descriptionArea;
    private JLabel organismCountLabel;
    private JTable organismNameTable;

    public ServerProjectListDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    private void createComponents() {
        this.setModal(true);
        this.projectTable = new JTable(new ServerProjectTabelModel());
        this.projectTable.setRowHeight(20);
        this.projectTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.projectTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ServerProjectListDialog.this.updateButtonState();
                ServerProjectListDialog.this.updateInfo();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.projectTable, 20, 31);
        jScrollPane.getViewport().setPreferredSize(new Dimension(500, 200));
        JPanel jPanel = this.createInfoPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Information"));
        this.setApplyButtonName("Download");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 10, 15), 0, 0));
        this.updateButtonState();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createInfoPanel() {
        JLabel jLabel = new JLabel("#Id");
        this.projectIdLable = new JLabel();
        JLabel jLabel2 = new JLabel("Name");
        this.projectNameLable = new JLabel();
        JLabel jLabel3 = new JLabel("Description");
        this.descriptionArea = new ReadOnlyTextArea(3, 30);
        this.descriptionArea.setOpaque(false);
        JLabel jLabel4 = new JLabel("Organism");
        this.organismCountLabel = new JLabel();
        this.organismNameTable = new JTable(new OrganismTableModel());
        this.organismNameTable.setTableHeader(null);
        JScrollPane jScrollPane = new JScrollPane(this.organismNameTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(400, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 5), 0, 0));
        jPanel.add((Component)this.projectIdLable, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 5), 0, 0));
        jPanel.add((Component)this.projectNameLable, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 15), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 0, 0));
        jPanel.add((Component)this.descriptionArea, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 15), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 15), 0, 0));
        jPanel.add((Component)this.organismCountLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 0, 15), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 25, 0, 15), 0, 0));
        return jPanel;
    }

    public void updateValue(List list) {
        this.setTitle("Project List (" + AccessServer.getInstance().getServerUrl() + ")");
        this.getServerProjectTabelModel().setProjectList(list);
    }

    public void updateInfo() {
        Project project = this.getSelectedProject();
        if (project == null) {
            this.projectIdLable.setText("");
            this.projectNameLable.setText("");
            this.descriptionArea.setText("");
        }
        this.projectIdLable.setText(project.getProjectId4Server());
        this.projectNameLable.setText(project.getProjectName());
        this.descriptionArea.setText(project.getDescription());
        List list = OrganismUtil.getOrganismList(project.getOrganismCodeList());
        this.organismCountLabel.setText(String.valueOf(list.size()));
        this.getOrganismTableModel().setOrganismList(list);
    }

    private void updateButtonState() {
        if (this.projectTable.getSelectedRowCount() > 0) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    private ServerProjectTabelModel getServerProjectTabelModel() {
        return (ServerProjectTabelModel)this.projectTable.getModel();
    }

    private OrganismTableModel getOrganismTableModel() {
        return (OrganismTableModel)this.organismNameTable.getModel();
    }

    public Project getSelectedProject() {
        int n = this.projectTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        Project project = this.getServerProjectTabelModel().getProject(n);
        String string = new File(ProjectUtil.getDefaultRootProjectDirpath(), project.getProjectName()).getAbsolutePath();
        project.setDirectoryPath(string);
        return project;
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private class ServerProjectTabelModel
    extends AbstractTableModel {
        private final String[] COLUMNS = new String[]{"#Id", "Name", "Description"};
        private List projectList = new ArrayList();

        private ServerProjectTabelModel() {
        }

        public void setProjectList(List list) {
            this.projectList = list;
            this.fireTableDataChanged();
        }

        public Project getProject(int n) {
            return (Project)this.projectList.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMNS[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.projectList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Project project = (Project)this.projectList.get(n);
            if (n2 == 0) {
                return project.getProjectId4Server();
            }
            if (n2 == 1) {
                return project.getProjectName();
            }
            if (n2 == 2) {
                return project.getDescription();
            }
            return null;
        }
    }
}

